/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import androidx.exifinterface.media.ExifInterface;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/imageutils/HeifExifUtil;", "", "<init>", "()V", "TAG", "", "getOrientation", "", "inputStream", "Ljava/io/InputStream;", "imagepipeline-base_release"})
public final class HeifExifUtil {
    @NotNull
    public static final HeifExifUtil INSTANCE = new HeifExifUtil();
    @NotNull
    private static final String TAG = "HeifExifUtil";

    private HeifExifUtil() {
    }

    @JvmStatic
    public static final int getOrientation(@Nullable InputStream inputStream) {
        int n;
        if (inputStream == null) {
            FLog.d((String)TAG, (String)"Trying to read Heif Exif from null inputStream -> ignoring");
            return 0;
        }
        try {
            ExifInterface exifInterface = new ExifInterface(inputStream);
            n = exifInterface.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            FLog.d((String)TAG, (String)"Failed reading Heif Exif orientation -> ignoring", (Throwable)e);
            n = 0;
        }
        return n;
    }
}

