/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import com.facebook.imageutils.StreamProcessor;
import com.facebook.imageutils.TiffUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/imageutils/JfifUtil;", "", "()V", "APP1_EXIF_MAGIC", "", "MARKER_APP1", "MARKER_EOI", "MARKER_ESCAPE_BYTE", "MARKER_FIRST_BYTE", "MARKER_RST0", "MARKER_RST7", "MARKER_SOFn", "MARKER_SOI", "MARKER_SOS", "MARKER_TEM", "getAutoRotateAngleFromOrientation", "orientation", "getOrientation", "inputStream", "Ljava/io/InputStream;", "jpeg", "", "isSOFn", "", "marker", "moveToAPP1EXIF", "moveToMarker", "markerToFind", "imagepipeline-base_release"})
public final class JfifUtil {
    @NotNull
    public static final JfifUtil INSTANCE = new JfifUtil();
    public static final int MARKER_FIRST_BYTE = 255;
    public static final int MARKER_ESCAPE_BYTE = 0;
    public static final int MARKER_SOI = 216;
    public static final int MARKER_TEM = 1;
    public static final int MARKER_EOI = 217;
    public static final int MARKER_SOS = 218;
    public static final int MARKER_APP1 = 225;
    public static final int MARKER_SOFn = 192;
    public static final int MARKER_RST0 = 208;
    public static final int MARKER_RST7 = 215;
    public static final int APP1_EXIF_MAGIC = 1165519206;

    private JfifUtil() {
    }

    @JvmStatic
    public static final int getAutoRotateAngleFromOrientation(int orientation) {
        return TiffUtil.getAutoRotateAngleFromOrientation(orientation);
    }

    @JvmStatic
    public static final int getOrientation(@Nullable byte[] jpeg) {
        return JfifUtil.getOrientation(new ByteArrayInputStream(jpeg));
    }

    @JvmStatic
    public static final int getOrientation(@NotNull InputStream inputStream) {
        int n;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            int length = INSTANCE.moveToAPP1EXIF(inputStream);
            n = length == 0 ? 0 : TiffUtil.readOrientationFromTIFF(inputStream, length);
        }
        catch (IOException ioe) {
            n = 0;
        }
        return n;
    }

    @JvmStatic
    public static final boolean moveToMarker(@NotNull InputStream inputStream, int markerToFind) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        block6: while (StreamProcessor.readPackedInt(inputStream, 1, false) == 255) {
            int marker = 255;
            while (marker == 255) {
                marker = StreamProcessor.readPackedInt(inputStream, 1, false);
            }
            if (markerToFind == 192 && INSTANCE.isSOFn(marker)) {
                return true;
            }
            if (marker == markerToFind) {
                return true;
            }
            switch (marker) {
                case 1: 
                case 216: {
                    continue block6;
                }
            }
            switch (marker) {
                case 217: 
                case 218: {
                    return false;
                }
            }
            int length = StreamProcessor.readPackedInt(inputStream, 2, false) - 2;
            inputStream.skip(length);
        }
        return false;
    }

    private final boolean isSOFn(int marker) {
        boolean bl;
        switch (marker) {
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 207: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final int moveToAPP1EXIF(InputStream inputStream) throws IOException {
        int length;
        if (JfifUtil.moveToMarker(inputStream, 225) && (length = StreamProcessor.readPackedInt(inputStream, 2, false) - 2) > 6) {
            int magic = StreamProcessor.readPackedInt(inputStream, 4, false);
            length -= 4;
            int zero = StreamProcessor.readPackedInt(inputStream, 2, false);
            length -= 2;
            if (magic == 1165519206 && zero == 0) {
                return length;
            }
        }
        return 0;
    }
}

