/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.image.ImageInfoImpl;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class BaseCloseableImage
implements CloseableImage {
    private Map<String, Object> mExtras = new HashMap<String, Object>();
    private static final Set<String> mImageExtrasList = new HashSet<String>(Arrays.asList("encoded_size", "encoded_width", "encoded_height", "uri_source", "image_format", "bitmap_config", "is_rounded", "non_fatal_decode_error", "modified_url", "image_color_space"));
    @Nullable
    private ImageInfo mCacheImageInfo;

    @Override
    public QualityInfo getQualityInfo() {
        return ImmutableQualityInfo.FULL_QUALITY;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public Map<String, Object> getExtras() {
        return this.mExtras;
    }

    public void putExtras(@Nullable Map<String, ?> extras) {
        if (extras == null) {
            return;
        }
        for (String extra : mImageExtrasList) {
            Object val = extras.get(extra);
            if (val == null) continue;
            this.mExtras.put(extra, val);
        }
    }

    public <E> void putExtra(String extra, @Nullable E value) {
        if (mImageExtrasList.contains(extra)) {
            this.mExtras.put(extra, value);
        }
    }

    public <T> T getExtra(String key) {
        return this.getExtra(key, null);
    }

    public <T> T getExtra(String key, @Nullable T valueIfNotFound) {
        Object value = this.mExtras.get(key);
        if (value == null) {
            return valueIfNotFound;
        }
        return (T)value;
    }

    @Override
    public ImageInfo getImageInfo() {
        if (this.mCacheImageInfo == null) {
            this.mCacheImageInfo = new ImageInfoImpl(this.getWidth(), this.getHeight(), this.getSizeInBytes(), this.getQualityInfo(), this.getExtras());
        }
        return this.mCacheImageInfo;
    }
}

