/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.instrumentation;

import androidx.annotation.Nullable;

public final class FrescoInstrumenter {
    @Nullable
    private static volatile Instrumenter sInstance;

    public static void provide(@Nullable Instrumenter instrumenter) {
        sInstance = instrumenter;
    }

    public static boolean isTracing() {
        Instrumenter instrumenter = sInstance;
        if (instrumenter == null) {
            return false;
        }
        return instrumenter.isTracing();
    }

    @Nullable
    public static Object onBeforeSubmitWork(@Nullable String tag) {
        Instrumenter instrumenter = sInstance;
        if (instrumenter == null || tag == null) {
            return null;
        }
        return instrumenter.onBeforeSubmitWork(tag);
    }

    @Nullable
    public static Object onBeginWork(@Nullable Object token, @Nullable String tag) {
        Instrumenter instrumenter = sInstance;
        if (instrumenter == null || token == null) {
            return null;
        }
        return instrumenter.onBeginWork(token, tag);
    }

    public static void onEndWork(@Nullable Object token) {
        Instrumenter instrumenter = sInstance;
        if (instrumenter == null || token == null) {
            return;
        }
        instrumenter.onEndWork(token);
    }

    public static void markFailure(@Nullable Object token, Throwable th) {
        Instrumenter instrumenter = sInstance;
        if (instrumenter == null || token == null) {
            return;
        }
        instrumenter.markFailure(token, th);
    }

    @Nullable
    public static Runnable decorateRunnable(@Nullable Runnable runnable, @Nullable String tag) {
        Instrumenter instrumenter = sInstance;
        if (instrumenter == null || runnable == null || tag == null) {
            return runnable;
        }
        return instrumenter.decorateRunnable(runnable, tag);
    }

    public static interface Instrumenter {
        public boolean isTracing();

        @Nullable
        public Object onBeforeSubmitWork(String var1);

        @Nullable
        public Object onBeginWork(Object var1, @Nullable String var2);

        @Nullable
        public void onEndWork(Object var1);

        public void markFailure(Object var1, Throwable var2);

        @Nullable
        public Runnable decorateRunnable(Runnable var1, String var2);
    }
}

