/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import android.os.SystemClock;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Predicate;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.cache.CountingLruMap;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.imagepipeline.cache.ValueDescriptor;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CountingMemoryCache<K, V>
implements MemoryCache<K, V>,
MemoryTrimmable {
    @Nullable
    private final EntryStateObserver<K> mEntryStateObserver;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, Entry<K, V>> mExclusiveEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, Entry<K, V>> mCachedEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<Bitmap, Object> mOtherEntries = new WeakHashMap<Bitmap, Object>();
    private final ValueDescriptor<V> mValueDescriptor;
    private final MemoryCache.CacheTrimStrategy mCacheTrimStrategy;
    private final Supplier<MemoryCacheParams> mMemoryCacheParamsSupplier;
    @GuardedBy(value="this")
    protected MemoryCacheParams mMemoryCacheParams;
    @GuardedBy(value="this")
    private long mLastCacheParamsCheck;

    public CountingMemoryCache(ValueDescriptor<V> valueDescriptor, MemoryCache.CacheTrimStrategy cacheTrimStrategy, Supplier<MemoryCacheParams> memoryCacheParamsSupplier, @Nullable EntryStateObserver<K> entryStateObserver) {
        this.mValueDescriptor = valueDescriptor;
        this.mExclusiveEntries = new CountingLruMap<K, Entry<K, Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCachedEntries = new CountingLruMap<K, Entry<K, Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCacheTrimStrategy = cacheTrimStrategy;
        this.mMemoryCacheParamsSupplier = memoryCacheParamsSupplier;
        this.mMemoryCacheParams = (MemoryCacheParams)this.mMemoryCacheParamsSupplier.get();
        this.mLastCacheParamsCheck = SystemClock.uptimeMillis();
        this.mEntryStateObserver = entryStateObserver;
    }

    private ValueDescriptor<Entry<K, V>> wrapValueDescriptor(final ValueDescriptor<V> evictableValueDescriptor) {
        return new ValueDescriptor<Entry<K, V>>(){

            @Override
            public int getSizeInBytes(Entry<K, V> entry) {
                return evictableValueDescriptor.getSizeInBytes(entry.valueRef.get());
            }
        };
    }

    @Override
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef) {
        return this.cache(key, valueRef, this.mEntryStateObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef, EntryStateObserver<K> observer) {
        Entry<K, V> oldExclusive;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(valueRef);
        this.maybeUpdateCacheParams();
        CloseableReference<V> oldRefToClose = null;
        CloseableReference<V> clientRef = null;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            oldExclusive = this.mExclusiveEntries.remove(key);
            Entry<K, V> oldEntry = this.mCachedEntries.remove(key);
            if (oldEntry != null) {
                this.makeOrphan(oldEntry);
                oldRefToClose = this.referenceToClose(oldEntry);
            }
            if (this.canCacheNewValue(valueRef.get())) {
                Entry<K, V> newEntry = Entry.of(key, valueRef, observer);
                this.mCachedEntries.put(key, newEntry);
                clientRef = this.newClientReference(newEntry);
            }
        }
        CloseableReference.closeSafely(oldRefToClose);
        CountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        this.maybeEvictEntries();
        return clientRef;
    }

    private synchronized boolean canCacheNewValue(V value) {
        int newValueSize = this.mValueDescriptor.getSizeInBytes(value);
        return newValueSize <= this.mMemoryCacheParams.maxCacheEntrySize && this.getInUseCount() <= this.mMemoryCacheParams.maxCacheEntries - 1 && this.getInUseSizeInBytes() <= this.mMemoryCacheParams.maxCacheSize - newValueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> get(K key) {
        Entry<K, V> oldExclusive;
        Preconditions.checkNotNull(key);
        CloseableReference<V> clientRef = null;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            oldExclusive = this.mExclusiveEntries.remove(key);
            Entry<K, V> entry = this.mCachedEntries.get(key);
            if (entry != null) {
                clientRef = this.newClientReference(entry);
            }
        }
        CountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return clientRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void probe(K key) {
        Preconditions.checkNotNull(key);
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            Entry<K, V> oldExclusive = this.mExclusiveEntries.remove(key);
            if (oldExclusive != null) {
                this.mExclusiveEntries.put(key, oldExclusive);
            }
        }
    }

    private synchronized CloseableReference<V> newClientReference(final Entry<K, V> entry) {
        this.increaseClientCount(entry);
        return CloseableReference.of((Object)entry.valueRef.get(), (ResourceReleaser)new ResourceReleaser<V>(){

            public void release(V unused) {
                CountingMemoryCache.this.releaseClientReference(entry);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseClientReference(Entry<K, V> entry) {
        CloseableReference<V> oldRefToClose;
        boolean isExclusiveAdded;
        Preconditions.checkNotNull(entry);
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            this.decreaseClientCount(entry);
            isExclusiveAdded = this.maybeAddToExclusives(entry);
            oldRefToClose = this.referenceToClose(entry);
        }
        CloseableReference.closeSafely(oldRefToClose);
        CountingMemoryCache.maybeNotifyExclusiveEntryInsertion(isExclusiveAdded ? entry : null);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized boolean maybeAddToExclusives(Entry<K, V> entry) {
        if (!entry.isOrphan && entry.clientCount == 0) {
            this.mExclusiveEntries.put(entry.key, entry);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CloseableReference<V> reuse(K key) {
        Preconditions.checkNotNull(key);
        CloseableReference clientRef = null;
        boolean removed = false;
        Entry<K, V> oldExclusive = null;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            oldExclusive = this.mExclusiveEntries.remove(key);
            if (oldExclusive != null) {
                Entry<K, V> entry = this.mCachedEntries.remove(key);
                Preconditions.checkNotNull(entry);
                Preconditions.checkState((entry.clientCount == 0 ? 1 : 0) != 0);
                clientRef = entry.valueRef;
                removed = true;
            }
        }
        if (removed) {
            CountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        }
        return clientRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(Predicate<K> predicate) {
        ArrayList<Entry<K, V>> oldEntries;
        ArrayList<Entry<K, V>> oldExclusives;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            oldExclusives = this.mExclusiveEntries.removeAll(predicate);
            oldEntries = this.mCachedEntries.removeAll(predicate);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldExclusives);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return oldEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Entry<K, V>> oldEntries;
        ArrayList<Entry<K, V>> oldExclusives;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            oldExclusives = this.mExclusiveEntries.clear();
            oldEntries = this.mCachedEntries.clear();
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldExclusives);
        this.maybeUpdateCacheParams();
    }

    @Override
    public synchronized boolean contains(Predicate<K> predicate) {
        return !this.mCachedEntries.getMatchingEntries(predicate).isEmpty();
    }

    @Override
    public synchronized boolean contains(K key) {
        return this.mCachedEntries.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(MemoryTrimType trimType) {
        ArrayList<Entry<K, V>> oldEntries;
        double trimRatio = this.mCacheTrimStrategy.getTrimRatio(trimType);
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            int targetCacheSize = (int)((double)this.mCachedEntries.getSizeInBytes() * (1.0 - trimRatio));
            int targetEvictionQueueSize = Math.max(0, targetCacheSize - this.getInUseSizeInBytes());
            oldEntries = this.trimExclusivelyOwnedEntries(Integer.MAX_VALUE, targetEvictionQueueSize);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldEntries);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized void maybeUpdateCacheParams() {
        if (this.mLastCacheParamsCheck + this.mMemoryCacheParams.paramsCheckIntervalMs > SystemClock.uptimeMillis()) {
            return;
        }
        this.mLastCacheParamsCheck = SystemClock.uptimeMillis();
        this.mMemoryCacheParams = (MemoryCacheParams)this.mMemoryCacheParamsSupplier.get();
    }

    public MemoryCacheParams getMemoryCacheParams() {
        return this.mMemoryCacheParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictEntries() {
        ArrayList<Entry<K, V>> oldEntries;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            int maxCount = Math.min(this.mMemoryCacheParams.maxEvictionQueueEntries, this.mMemoryCacheParams.maxCacheEntries - this.getInUseCount());
            int maxSize = Math.min(this.mMemoryCacheParams.maxEvictionQueueSize, this.mMemoryCacheParams.maxCacheSize - this.getInUseSizeInBytes());
            oldEntries = this.trimExclusivelyOwnedEntries(maxCount, maxSize);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldEntries);
    }

    @Nullable
    private synchronized ArrayList<Entry<K, V>> trimExclusivelyOwnedEntries(int count, int size) {
        count = Math.max(count, 0);
        size = Math.max(size, 0);
        if (this.mExclusiveEntries.getCount() <= count && this.mExclusiveEntries.getSizeInBytes() <= size) {
            return null;
        }
        ArrayList<Entry<K, V>> oldEntries = new ArrayList<Entry<K, V>>();
        while (this.mExclusiveEntries.getCount() > count || this.mExclusiveEntries.getSizeInBytes() > size) {
            K key = this.mExclusiveEntries.getFirstKey();
            this.mExclusiveEntries.remove(key);
            oldEntries.add(this.mCachedEntries.remove(key));
        }
        return oldEntries;
    }

    private void maybeClose(@Nullable ArrayList<Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (Entry<K, V> oldEntry : oldEntries) {
                CloseableReference.closeSafely(this.referenceToClose(oldEntry));
            }
        }
    }

    private void maybeNotifyExclusiveEntryRemoval(@Nullable ArrayList<Entry<K, V>> entries) {
        if (entries != null) {
            for (Entry<K, V> entry : entries) {
                CountingMemoryCache.maybeNotifyExclusiveEntryRemoval(entry);
            }
        }
    }

    private static <K, V> void maybeNotifyExclusiveEntryRemoval(@Nullable Entry<K, V> entry) {
        if (entry != null && entry.observer != null) {
            entry.observer.onExclusivityChanged(entry.key, false);
        }
    }

    private static <K, V> void maybeNotifyExclusiveEntryInsertion(@Nullable Entry<K, V> entry) {
        if (entry != null && entry.observer != null) {
            entry.observer.onExclusivityChanged(entry.key, true);
        }
    }

    private synchronized void makeOrphans(@Nullable ArrayList<Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (Entry<K, V> oldEntry : oldEntries) {
                this.makeOrphan(oldEntry);
            }
        }
    }

    private synchronized void makeOrphan(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        entry.isOrphan = true;
    }

    private synchronized void increaseClientCount(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        ++entry.clientCount;
    }

    private synchronized void decreaseClientCount(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((entry.clientCount > 0 ? 1 : 0) != 0);
        --entry.clientCount;
    }

    @Nullable
    private synchronized CloseableReference<V> referenceToClose(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return entry.isOrphan && entry.clientCount == 0 ? entry.valueRef : null;
    }

    @Override
    public synchronized int getCount() {
        return this.mCachedEntries.getCount();
    }

    @Override
    public synchronized int getSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes();
    }

    public synchronized int getInUseCount() {
        return this.mCachedEntries.getCount() - this.mExclusiveEntries.getCount();
    }

    public synchronized int getInUseSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes() - this.mExclusiveEntries.getSizeInBytes();
    }

    public synchronized int getEvictionQueueCount() {
        return this.mExclusiveEntries.getCount();
    }

    public synchronized int getEvictionQueueSizeInBytes() {
        return this.mExclusiveEntries.getSizeInBytes();
    }

    public String reportData() {
        return Objects.toStringHelper((String)"CountingMemoryCache").add("cached_entries_count:", this.mCachedEntries.getCount()).add("cached_entries_size_bytes", this.mCachedEntries.getSizeInBytes()).add("exclusive_entries_count", this.mExclusiveEntries.getCount()).add("exclusive_entries_size_bytes", this.mExclusiveEntries.getSizeInBytes()).toString();
    }

    @VisibleForTesting
    static class Entry<K, V> {
        public final K key;
        public final CloseableReference<V> valueRef;
        public int clientCount;
        public boolean isOrphan;
        @Nullable
        public final EntryStateObserver<K> observer;

        private Entry(K key, CloseableReference<V> valueRef, @Nullable EntryStateObserver<K> observer) {
            this.key = Preconditions.checkNotNull(key);
            this.valueRef = (CloseableReference)Preconditions.checkNotNull((Object)CloseableReference.cloneOrNull(valueRef));
            this.clientCount = 0;
            this.isOrphan = false;
            this.observer = observer;
        }

        @VisibleForTesting
        static <K, V> Entry<K, V> of(K key, CloseableReference<V> valueRef, @Nullable EntryStateObserver<K> observer) {
            return new Entry<K, V>(key, valueRef, observer);
        }
    }

    public static interface EntryStateObserver<K> {
        public void onExclusivityChanged(K var1, boolean var2);
    }
}

