/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.media.ExifInterface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import java.io.InputStream;

public class HeifExifUtil {
    public static final String TAG = "HeifExifUtil";

    public static int getOrientation(InputStream inputStream) {
        if (Build.VERSION.SDK_INT >= 24) {
            return HeifExifUtilAndroidN.getOrientation(inputStream);
        }
        FLog.d((String)TAG, (String)"Trying to read Heif Exif information before Android N -> ignoring");
        return 0;
    }

    @DoNotStrip
    private static class HeifExifUtilAndroidN {
        private HeifExifUtilAndroidN() {
        }

        @RequiresApi(api=24)
        static int getOrientation(InputStream inputStream) {
            try {
                ExifInterface exifInterface = new ExifInterface(inputStream);
                return exifInterface.getAttributeInt("Orientation", 1);
            }
            catch (IOException e) {
                FLog.d((String)HeifExifUtil.TAG, (String)"Failed reading Heif Exif orientation -> ignoring", (Throwable)e);
                return 0;
            }
        }
    }
}

