/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.os.Build;
import android.support.v4.util.Pools;
import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.imageutils.ImageMetaData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public final class BitmapUtil {
    private static final int DECODE_BUFFER_SIZE = 16384;
    private static final int POOL_SIZE = 12;
    private static final Pools.SynchronizedPool<ByteBuffer> DECODE_BUFFERS = new Pools.SynchronizedPool(12);
    public static final int ALPHA_8_BYTES_PER_PIXEL = 1;
    public static final int ARGB_4444_BYTES_PER_PIXEL = 2;
    public static final int ARGB_8888_BYTES_PER_PIXEL = 4;
    public static final int RGB_565_BYTES_PER_PIXEL = 2;
    public static final int RGBA_F16_BYTES_PER_PIXEL = 8;
    public static final float MAX_BITMAP_SIZE = 2048.0f;

    @SuppressLint(value={"NewApi"})
    public static int getSizeInBytes(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(byte[] bytes) {
        return BitmapUtil.decodeDimensions(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        ByteBuffer byteBuffer = (ByteBuffer)DECODE_BUFFERS.acquire();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(16384);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            options.inTempStorage = byteBuffer.array();
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            Pair pair = options.outWidth == -1 || options.outHeight == -1 ? null : new Pair((Object)options.outWidth, (Object)options.outHeight);
            return pair;
        }
        finally {
            DECODE_BUFFERS.release((Object)byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageMetaData decodeDimensionsAndColorSpace(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        ByteBuffer byteBuffer = (ByteBuffer)DECODE_BUFFERS.acquire();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(16384);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            options.inTempStorage = byteBuffer.array();
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            ColorSpace colorSpace = null;
            if (Build.VERSION.SDK_INT >= 26) {
                colorSpace = options.outColorSpace;
            }
            ImageMetaData imageMetaData = new ImageMetaData(options.outWidth, options.outHeight, colorSpace);
            return imageMetaData;
        }
        finally {
            DECODE_BUFFERS.release((Object)byteBuffer);
        }
    }

    public static int getPixelSizeForBitmapConfig(Bitmap.Config bitmapConfig) {
        switch (bitmapConfig) {
            case ARGB_8888: {
                return 4;
            }
            case ALPHA_8: {
                return 1;
            }
            case ARGB_4444: {
                return 2;
            }
            case RGB_565: {
                return 2;
            }
            case RGBA_F16: {
                return 8;
            }
        }
        throw new UnsupportedOperationException("The provided Bitmap.Config is not supported");
    }

    public static int getSizeInByteForBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        return width * height * BitmapUtil.getPixelSizeForBitmapConfig(bitmapConfig);
    }
}

