/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.common.util.HashCodeUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class RotationOptions {
    public static final int NO_ROTATION = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    private static final int USE_EXIF_ROTATION_ANGLE = -1;
    private final int mRotation;
    private final boolean mDeferUntilRendered;

    public static RotationOptions autoRotate() {
        return new RotationOptions(-1, false);
    }

    public static RotationOptions autoRotateAtRenderTime() {
        return new RotationOptions(-1, true);
    }

    public static RotationOptions forceRotation(int angle) {
        return new RotationOptions(angle, false);
    }

    private RotationOptions(int rotation, boolean canDeferUntilRendered) {
        this.mRotation = rotation;
        this.mDeferUntilRendered = canDeferUntilRendered;
    }

    public boolean useImageMetadata() {
        return this.mRotation == -1;
    }

    public int getForcedAngle() {
        if (this.useImageMetadata()) {
            throw new IllegalStateException("Rotation is set to use EXIF");
        }
        return this.mRotation;
    }

    public boolean canDeferUntilRendered() {
        return this.mDeferUntilRendered;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((Object)this.mRotation, (Object)this.mDeferUntilRendered);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RotationOptions)) {
            return false;
        }
        RotationOptions that = (RotationOptions)other;
        return this.mRotation == that.mRotation && this.mDeferUntilRendered == that.mDeferUntilRendered;
    }

    public String toString() {
        return String.format((Locale)null, "%d defer:%b", this.mRotation, this.mDeferUntilRendered);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RotationAngle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Rotation {
    }
}

