/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.EntryEvictionComparator;
import com.facebook.cache.disk.EntryEvictionComparatorSupplier;
import com.facebook.common.internal.VisibleForTesting;

public class ScoreBasedEvictionComparatorSupplier
implements EntryEvictionComparatorSupplier {
    private final float mAgeWeight;
    private final float mSizeWeight;

    public ScoreBasedEvictionComparatorSupplier(float ageWeight, float sizeWeight) {
        this.mAgeWeight = ageWeight;
        this.mSizeWeight = sizeWeight;
    }

    @Override
    public EntryEvictionComparator get() {
        return new EntryEvictionComparator(){
            long now = System.currentTimeMillis();

            @Override
            public int compare(DiskStorage.Entry lhs, DiskStorage.Entry rhs) {
                float score2;
                float score1 = ScoreBasedEvictionComparatorSupplier.this.calculateScore(lhs, this.now);
                return score1 < (score2 = ScoreBasedEvictionComparatorSupplier.this.calculateScore(rhs, this.now)) ? 1 : (score2 == score1 ? 0 : -1);
            }
        };
    }

    @VisibleForTesting
    float calculateScore(DiskStorage.Entry entry, long now) {
        long ageMs = now - entry.getTimestamp();
        long bytes = entry.getSize();
        return this.mAgeWeight * (float)ageMs + this.mSizeWeight * (float)bytes;
    }
}

