/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.generic;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.VisibilityAwareDrawable;
import com.facebook.drawee.drawable.VisibilityCallback;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class RootDrawable
extends ForwardingDrawable
implements VisibilityAwareDrawable {
    @Nullable
    @VisibleForTesting
    Drawable mControllerOverlay = null;
    @Nullable
    private VisibilityCallback mVisibilityCallback;

    public RootDrawable(Drawable drawable) {
        super(drawable);
    }

    @Override
    public int getIntrinsicWidth() {
        return -1;
    }

    @Override
    public int getIntrinsicHeight() {
        return -1;
    }

    @Override
    public void setVisibilityCallback(@Nullable VisibilityCallback visibilityCallback) {
        this.mVisibilityCallback = visibilityCallback;
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        if (this.mVisibilityCallback != null) {
            this.mVisibilityCallback.onVisibilityChange(visible);
        }
        return super.setVisible(visible, restart);
    }

    @Override
    @SuppressLint(value={"WrongCall"})
    public void draw(Canvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (this.mVisibilityCallback != null) {
            this.mVisibilityCallback.onDraw();
        }
        super.draw(canvas);
        if (this.mControllerOverlay != null) {
            this.mControllerOverlay.setBounds(this.getBounds());
            this.mControllerOverlay.draw(canvas);
        }
    }

    public void setControllerOverlay(@Nullable Drawable controllerOverlay) {
        this.mControllerOverlay = controllerOverlay;
        this.invalidateSelf();
    }
}

