/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.controller;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.MotionEvent;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.components.DeferredReleaser;
import com.facebook.drawee.components.DraweeEventTracker;
import com.facebook.drawee.components.RetryManager;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.controller.ControllerViewportVisibilityListener;
import com.facebook.drawee.controller.ForwardingControllerListener;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.gestures.GestureDetector;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.interfaces.SettableDraweeHierarchy;
import com.facebook.fresco.middleware.MiddlewareUtils;
import com.facebook.fresco.ui.common.ControllerListener2;
import com.facebook.fresco.ui.common.ForwardingControllerListener2;
import com.facebook.fresco.ui.common.LegacyOnFadeListener;
import com.facebook.fresco.ui.common.OnFadeListener;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ReturnsOwnership;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@NotThreadSafe
public abstract class AbstractDraweeController<T, INFO>
implements DraweeController,
DeferredReleaser.Releasable,
GestureDetector.ClickListener {
    private static final Map<String, Object> COMPONENT_EXTRAS = ImmutableMap.of((Object)"component_tag", (Object)"drawee");
    private static final Map<String, Object> SHORTCUT_EXTRAS = ImmutableMap.of((Object)"origin", (Object)"memory_bitmap", (Object)"origin_sub", (Object)"shortcut");
    private static final Class<?> TAG = AbstractDraweeController.class;
    private final DraweeEventTracker mEventTracker = DraweeEventTracker.newInstance();
    private final DeferredReleaser mDeferredReleaser;
    private final Executor mUiThreadImmediateExecutor;
    @Nullable
    private RetryManager mRetryManager;
    @Nullable
    private GestureDetector mGestureDetector;
    @Nullable
    private ControllerViewportVisibilityListener mControllerViewportVisibilityListener;
    @Nullable
    protected ControllerListener<INFO> mControllerListener;
    protected ForwardingControllerListener2<INFO> mControllerListener2 = new ForwardingControllerListener2();
    @Nullable
    protected LegacyOnFadeListener mLegacyOnFadeListener;
    @Nullable
    private SettableDraweeHierarchy mSettableDraweeHierarchy;
    @Nullable
    private Drawable mControllerOverlay;
    private String mId;
    private Object mCallerContext;
    private boolean mIsAttached;
    private boolean mIsRequestSubmitted;
    private boolean mIsVisibleInViewportHint;
    private boolean mHasFetchFailed;
    private boolean mRetainImageOnFailure;
    @Nullable
    private String mContentDescription;
    @Nullable
    private DataSource<T> mDataSource;
    @Nullable
    private T mFetchedImage;
    private boolean mJustConstructed = true;
    private boolean mLogWithHighSamplingRate = false;
    @Nullable
    protected Drawable mDrawable;

    public AbstractDraweeController(DeferredReleaser deferredReleaser, Executor uiThreadImmediateExecutor, String id, Object callerContext) {
        this.mDeferredReleaser = deferredReleaser;
        this.mUiThreadImmediateExecutor = uiThreadImmediateExecutor;
        this.init(id, callerContext);
    }

    protected void initialize(String id, Object callerContext) {
        this.init(id, callerContext);
        this.mJustConstructed = false;
        this.mLogWithHighSamplingRate = false;
    }

    private synchronized void init(String id, Object callerContext) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractDraweeController#init");
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_INIT_CONTROLLER);
        if (!this.mJustConstructed && this.mDeferredReleaser != null) {
            this.mDeferredReleaser.cancelDeferredRelease(this);
        }
        this.mIsAttached = false;
        this.mIsVisibleInViewportHint = false;
        this.releaseFetch();
        this.mRetainImageOnFailure = false;
        if (this.mRetryManager != null) {
            this.mRetryManager.init();
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.init();
            this.mGestureDetector.setClickListener(this);
        }
        if (this.mControllerListener instanceof InternalForwardingListener) {
            ((InternalForwardingListener)this.mControllerListener).clearListeners();
        } else {
            this.mControllerListener = null;
        }
        this.mControllerViewportVisibilityListener = null;
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.reset();
            this.mSettableDraweeHierarchy.setControllerOverlay(null);
            this.mSettableDraweeHierarchy = null;
        }
        this.mControllerOverlay = null;
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s -> %s: initialize", (Object)System.identityHashCode(this), (Object)this.mId, (Object)id);
        }
        this.mId = id;
        this.mCallerContext = callerContext;
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        if (this.mLegacyOnFadeListener != null) {
            this.setUpLoggingListener();
        }
    }

    @Override
    public void release() {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_RELEASE_CONTROLLER);
        if (this.mRetryManager != null) {
            this.mRetryManager.reset();
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.reset();
        }
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.reset();
        }
        this.releaseFetch();
    }

    private void releaseFetch() {
        boolean wasRequestSubmitted = this.mIsRequestSubmitted;
        this.mIsRequestSubmitted = false;
        this.mHasFetchFailed = false;
        Map datasourceExtras = null;
        Map<String, Object> imageExtras = null;
        if (this.mDataSource != null) {
            datasourceExtras = this.mDataSource.getExtras();
            this.mDataSource.close();
            this.mDataSource = null;
        }
        if (this.mDrawable != null) {
            this.releaseDrawable(this.mDrawable);
        }
        if (this.mContentDescription != null) {
            this.mContentDescription = null;
        }
        this.mDrawable = null;
        if (this.mFetchedImage != null) {
            imageExtras = this.obtainExtrasFromImage(this.getImageInfo(this.mFetchedImage));
            this.logMessageAndImage("release", this.mFetchedImage);
            this.releaseImage(this.mFetchedImage);
            this.mFetchedImage = null;
        }
        if (wasRequestSubmitted) {
            this.reportRelease(datasourceExtras, imageExtras);
        }
    }

    public String getId() {
        return this.mId;
    }

    public Object getCallerContext() {
        return this.mCallerContext;
    }

    @ReturnsOwnership
    protected RetryManager getRetryManager() {
        if (this.mRetryManager == null) {
            this.mRetryManager = new RetryManager();
        }
        return this.mRetryManager;
    }

    @Nullable
    protected GestureDetector getGestureDetector() {
        return this.mGestureDetector;
    }

    protected void setGestureDetector(@Nullable GestureDetector gestureDetector) {
        this.mGestureDetector = gestureDetector;
        if (this.mGestureDetector != null) {
            this.mGestureDetector.setClickListener(this);
        }
    }

    protected void setRetainImageOnFailure(boolean enabled) {
        this.mRetainImageOnFailure = enabled;
    }

    protected boolean isLogWithHighSamplingRate() {
        return this.mLogWithHighSamplingRate;
    }

    protected void setLogWithHighSamplingRate(boolean logWithHighSamplingRate) {
        this.mLogWithHighSamplingRate = logWithHighSamplingRate;
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.mContentDescription;
    }

    @Override
    public void setContentDescription(@Nullable String contentDescription) {
        this.mContentDescription = contentDescription;
    }

    public void addControllerListener(ControllerListener<? super INFO> controllerListener) {
        Preconditions.checkNotNull(controllerListener);
        if (this.mControllerListener instanceof InternalForwardingListener) {
            ((InternalForwardingListener)this.mControllerListener).addListener(controllerListener);
            return;
        }
        if (this.mControllerListener != null) {
            this.mControllerListener = InternalForwardingListener.createInternal(this.mControllerListener, controllerListener);
            return;
        }
        this.mControllerListener = controllerListener;
    }

    public void addControllerListener2(ControllerListener2<INFO> controllerListener2) {
        this.mControllerListener2.addListener(controllerListener2);
    }

    public void removeControllerListener2(ControllerListener2<INFO> controllerListener2) {
        this.mControllerListener2.removeListener(controllerListener2);
    }

    public void setLoggingListener(LegacyOnFadeListener legacyOnFadeListener) {
        this.mLegacyOnFadeListener = legacyOnFadeListener;
    }

    @Nullable
    protected LegacyOnFadeListener getLoggingListener() {
        return this.mLegacyOnFadeListener;
    }

    public void removeControllerListener(ControllerListener<? super INFO> controllerListener) {
        Preconditions.checkNotNull(controllerListener);
        if (this.mControllerListener instanceof InternalForwardingListener) {
            ((InternalForwardingListener)this.mControllerListener).removeListener(controllerListener);
            return;
        }
        if (this.mControllerListener == controllerListener) {
            this.mControllerListener = null;
        }
    }

    protected ControllerListener<INFO> getControllerListener() {
        if (this.mControllerListener == null) {
            return BaseControllerListener.getNoOpListener();
        }
        return this.mControllerListener;
    }

    protected ControllerListener2<INFO> getControllerListener2() {
        return this.mControllerListener2;
    }

    public void setControllerViewportVisibilityListener(@Nullable ControllerViewportVisibilityListener controllerViewportVisibilityListener) {
        this.mControllerViewportVisibilityListener = controllerViewportVisibilityListener;
    }

    @Override
    @Nullable
    public DraweeHierarchy getHierarchy() {
        return this.mSettableDraweeHierarchy;
    }

    @Override
    public void setHierarchy(@Nullable DraweeHierarchy hierarchy) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: setHierarchy: %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)hierarchy);
        }
        this.mEventTracker.recordEvent(hierarchy != null ? DraweeEventTracker.Event.ON_SET_HIERARCHY : DraweeEventTracker.Event.ON_CLEAR_HIERARCHY);
        if (this.mIsRequestSubmitted) {
            this.mDeferredReleaser.cancelDeferredRelease(this);
            this.release();
        }
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.setControllerOverlay(null);
            this.mSettableDraweeHierarchy = null;
        }
        if (hierarchy != null) {
            Preconditions.checkArgument((Boolean)(hierarchy instanceof SettableDraweeHierarchy));
            this.mSettableDraweeHierarchy = (SettableDraweeHierarchy)hierarchy;
            this.mSettableDraweeHierarchy.setControllerOverlay(this.mControllerOverlay);
        }
        if (this.mLegacyOnFadeListener != null) {
            this.setUpLoggingListener();
        }
    }

    private void setUpLoggingListener() {
        if (this.mSettableDraweeHierarchy instanceof GenericDraweeHierarchy) {
            ((GenericDraweeHierarchy)this.mSettableDraweeHierarchy).setOnFadeListener(new OnFadeListener(){

                public void onFadeFinished() {
                    if (AbstractDraweeController.this.mLegacyOnFadeListener != null) {
                        AbstractDraweeController.this.mLegacyOnFadeListener.onFadeFinished(AbstractDraweeController.this.mId);
                    }
                }

                public void onShownImmediately() {
                }

                public void onFadeStarted() {
                    if (AbstractDraweeController.this.mLegacyOnFadeListener != null) {
                        AbstractDraweeController.this.mLegacyOnFadeListener.onFadeStarted(AbstractDraweeController.this.mId);
                    }
                }
            });
        }
    }

    protected void setControllerOverlay(@Nullable Drawable controllerOverlay) {
        this.mControllerOverlay = controllerOverlay;
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.setControllerOverlay(this.mControllerOverlay);
        }
    }

    @Nullable
    protected Drawable getControllerOverlay() {
        return this.mControllerOverlay;
    }

    @Override
    public void onAttach() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractDraweeController#onAttach");
        }
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onAttach: %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)(this.mIsRequestSubmitted ? "request already submitted" : "request needs submit"));
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_ATTACH_CONTROLLER);
        Preconditions.checkNotNull((Object)this.mSettableDraweeHierarchy);
        this.mDeferredReleaser.cancelDeferredRelease(this);
        this.mIsAttached = true;
        if (!this.mIsRequestSubmitted) {
            this.submitRequest();
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    @Override
    public void onDetach() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractDraweeController#onDetach");
        }
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onDetach", (Object)System.identityHashCode(this), (Object)this.mId);
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_DETACH_CONTROLLER);
        this.mIsAttached = false;
        this.mDeferredReleaser.scheduleDeferredRelease(this);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    @Override
    public void onViewportVisibilityHint(boolean isVisibleInViewportHint) {
        ControllerViewportVisibilityListener listener = this.mControllerViewportVisibilityListener;
        if (listener != null) {
            if (isVisibleInViewportHint && !this.mIsVisibleInViewportHint) {
                listener.onDraweeViewportEntry(this.mId);
            } else if (!isVisibleInViewportHint && this.mIsVisibleInViewportHint) {
                listener.onDraweeViewportExit(this.mId);
            }
        }
        this.mIsVisibleInViewportHint = isVisibleInViewportHint;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onTouchEvent %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)event);
        }
        if (this.mGestureDetector == null) {
            return false;
        }
        if (this.mGestureDetector.isCapturingGesture() || this.shouldHandleGesture()) {
            this.mGestureDetector.onTouchEvent(event);
            return true;
        }
        return false;
    }

    protected boolean shouldHandleGesture() {
        return this.shouldRetryOnTap();
    }

    private boolean shouldRetryOnTap() {
        return this.mHasFetchFailed && this.mRetryManager != null && this.mRetryManager.shouldRetryOnTap();
    }

    @Override
    public boolean onClick() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onClick", (Object)System.identityHashCode(this), (Object)this.mId);
        }
        if (this.shouldRetryOnTap()) {
            this.mRetryManager.notifyTapToRetry();
            this.mSettableDraweeHierarchy.reset();
            this.submitRequest();
            return true;
        }
        return false;
    }

    protected void submitRequest() {
        T closeableImage;
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractDraweeController#submitRequest");
        }
        if ((closeableImage = this.getCachedImage()) != null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"AbstractDraweeController#submitRequest->cache");
            }
            this.mDataSource = null;
            this.mIsRequestSubmitted = true;
            this.mHasFetchFailed = false;
            this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_SUBMIT_CACHE_HIT);
            this.reportSubmit(this.mDataSource, this.getImageInfo(closeableImage));
            this.onImageLoadedFromCacheImmediately(this.mId, closeableImage);
            this.onNewResultInternal(this.mId, this.mDataSource, closeableImage, 1.0f, true, true, true);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return;
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_DATASOURCE_SUBMIT);
        this.mSettableDraweeHierarchy.setProgress(0.0f, true);
        this.mIsRequestSubmitted = true;
        this.mHasFetchFailed = false;
        this.mDataSource = this.getDataSource();
        this.reportSubmit(this.mDataSource, null);
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: submitRequest: dataSource: %x", (Object)System.identityHashCode(this), (Object)this.mId, (Object)System.identityHashCode(this.mDataSource));
        }
        final String id = this.mId;
        final boolean wasImmediate = this.mDataSource.hasResult();
        BaseDataSubscriber dataSubscriber = new BaseDataSubscriber<T>(){

            public void onNewResultImpl(DataSource<T> dataSource) {
                boolean isFinished = dataSource.isFinished();
                boolean hasMultipleResults = dataSource.hasMultipleResults();
                float progress = dataSource.getProgress();
                Object image = dataSource.getResult();
                if (image != null) {
                    AbstractDraweeController.this.onNewResultInternal(id, dataSource, image, progress, isFinished, wasImmediate, hasMultipleResults);
                } else if (isFinished) {
                    AbstractDraweeController.this.onFailureInternal(id, dataSource, new NullPointerException(), true);
                }
            }

            public void onFailureImpl(DataSource<T> dataSource) {
                AbstractDraweeController.this.onFailureInternal(id, dataSource, dataSource.getFailureCause(), true);
            }

            public void onProgressUpdate(DataSource<T> dataSource) {
                boolean isFinished = dataSource.isFinished();
                float progress = dataSource.getProgress();
                AbstractDraweeController.this.onProgressUpdateInternal(id, dataSource, progress, isFinished);
            }
        };
        this.mDataSource.subscribe((DataSubscriber)dataSubscriber, this.mUiThreadImmediateExecutor);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewResultInternal(String id, DataSource<T> dataSource, @Nullable T image, float progress, boolean isFinished, boolean wasImmediate, boolean deliverTempResult) {
        try {
            Drawable drawable;
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"AbstractDraweeController#onNewResultInternal");
            }
            if (!this.isExpectedDataSource(id, dataSource)) {
                this.logMessageAndImage("ignore_old_datasource @ onNewResult", image);
                this.releaseImage(image);
                dataSource.close();
                return;
            }
            this.mEventTracker.recordEvent(isFinished ? DraweeEventTracker.Event.ON_DATASOURCE_RESULT : DraweeEventTracker.Event.ON_DATASOURCE_RESULT_INT);
            try {
                drawable = this.createDrawable(image);
            }
            catch (Exception exception) {
                this.logMessageAndImage("drawable_failed @ onNewResult", image);
                this.releaseImage(image);
                this.onFailureInternal(id, dataSource, exception, isFinished);
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
                return;
            }
            T previousImage = this.mFetchedImage;
            Drawable previousDrawable = this.mDrawable;
            this.mFetchedImage = image;
            this.mDrawable = drawable;
            try {
                if (isFinished) {
                    this.logMessageAndImage("set_final_result @ onNewResult", image);
                    this.mDataSource = null;
                    this.getSettableDraweeHierarchy().setImage(drawable, 1.0f, wasImmediate);
                    this.reportSuccess(id, image, dataSource);
                } else if (deliverTempResult) {
                    this.logMessageAndImage("set_temporary_result @ onNewResult", image);
                    this.getSettableDraweeHierarchy().setImage(drawable, 1.0f, wasImmediate);
                    this.reportSuccess(id, image, dataSource);
                } else {
                    this.logMessageAndImage("set_intermediate_result @ onNewResult", image);
                    this.getSettableDraweeHierarchy().setImage(drawable, progress, wasImmediate);
                    this.reportIntermediateSet(id, image);
                }
            }
            finally {
                if (previousDrawable != null && previousDrawable != drawable) {
                    this.releaseDrawable(previousDrawable);
                }
                if (previousImage != null && previousImage != image) {
                    this.logMessageAndImage("release_previous_result @ onNewResult", previousImage);
                    this.releaseImage(previousImage);
                }
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    private void onFailureInternal(String id, DataSource<T> dataSource, Throwable throwable, boolean isFinished) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractDraweeController#onFailureInternal");
        }
        if (!this.isExpectedDataSource(id, dataSource)) {
            this.logMessageAndFailure("ignore_old_datasource @ onFailure", throwable);
            dataSource.close();
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return;
        }
        this.mEventTracker.recordEvent(isFinished ? DraweeEventTracker.Event.ON_DATASOURCE_FAILURE : DraweeEventTracker.Event.ON_DATASOURCE_FAILURE_INT);
        if (isFinished) {
            this.logMessageAndFailure("final_failed @ onFailure", throwable);
            this.mDataSource = null;
            this.mHasFetchFailed = true;
            SettableDraweeHierarchy hierarchy = this.mSettableDraweeHierarchy;
            if (hierarchy != null) {
                if (this.mRetainImageOnFailure && this.mDrawable != null) {
                    hierarchy.setImage(this.mDrawable, 1.0f, true);
                } else if (this.shouldRetryOnTap()) {
                    hierarchy.setRetry(throwable);
                } else {
                    hierarchy.setFailure(throwable);
                }
            }
            this.reportFailure(throwable, dataSource);
        } else {
            this.logMessageAndFailure("intermediate_failed @ onFailure", throwable);
            this.reportIntermediateFailure(throwable);
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    private void onProgressUpdateInternal(String id, DataSource<T> dataSource, float progress, boolean isFinished) {
        if (!this.isExpectedDataSource(id, dataSource)) {
            this.logMessageAndFailure("ignore_old_datasource @ onProgress", null);
            dataSource.close();
            return;
        }
        if (!isFinished) {
            this.mSettableDraweeHierarchy.setProgress(progress, false);
        }
    }

    private boolean isExpectedDataSource(String id, DataSource<T> dataSource) {
        if (dataSource == null && this.mDataSource == null) {
            return true;
        }
        return id.equals(this.mId) && dataSource == this.mDataSource && this.mIsRequestSubmitted;
    }

    private void logMessageAndImage(String messageAndMethod, T image) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: %s: image: %s %x", (Object[])new Object[]{System.identityHashCode(this), this.mId, messageAndMethod, this.getImageClass(image), this.getImageHash(image)});
        }
    }

    private void logMessageAndFailure(String messageAndMethod, Throwable throwable) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: %s: failure: %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)messageAndMethod, (Object)throwable);
        }
    }

    @Override
    @Nullable
    public Animatable getAnimatable() {
        return this.mDrawable instanceof Animatable ? (Animatable)this.mDrawable : null;
    }

    protected abstract DataSource<T> getDataSource();

    protected abstract Drawable createDrawable(T var1);

    @Nullable
    protected abstract INFO getImageInfo(T var1);

    protected String getImageClass(@Nullable T image) {
        return image != null ? image.getClass().getSimpleName() : "<null>";
    }

    protected int getImageHash(@Nullable T image) {
        return System.identityHashCode(image);
    }

    protected abstract void releaseImage(@Nullable T var1);

    protected abstract void releaseDrawable(@Nullable Drawable var1);

    public String toString() {
        return Objects.toStringHelper((Object)this).add("isAttached", this.mIsAttached).add("isRequestSubmitted", this.mIsRequestSubmitted).add("hasFetchFailed", this.mHasFetchFailed).add("fetchedImage", this.getImageHash(this.mFetchedImage)).add("events", (Object)this.mEventTracker.toString()).toString();
    }

    @Nullable
    protected T getCachedImage() {
        return null;
    }

    protected void onImageLoadedFromCacheImmediately(String id, T cachedImage) {
    }

    protected void reportSubmit(DataSource<T> dataSource, @Nullable INFO info) {
        this.getControllerListener().onSubmit(this.mId, this.mCallerContext);
        this.getControllerListener2().onSubmit(this.mId, this.mCallerContext, this.obtainExtras(dataSource, info, this.getMainUri()));
    }

    private void reportIntermediateSet(String id, @Nullable T image) {
        INFO info = this.getImageInfo(image);
        this.getControllerListener().onIntermediateImageSet(id, info);
        this.getControllerListener2().onIntermediateImageSet(id, info);
    }

    private void reportIntermediateFailure(Throwable throwable) {
        this.getControllerListener().onIntermediateImageFailed(this.mId, throwable);
        this.getControllerListener2().onIntermediateImageFailed(this.mId);
    }

    private void reportSuccess(String id, @Nullable T image, @Nullable DataSource<T> dataSource) {
        INFO info = this.getImageInfo(image);
        this.getControllerListener().onFinalImageSet(id, info, this.getAnimatable());
        this.getControllerListener2().onFinalImageSet(id, info, this.obtainExtras(dataSource, info, null));
    }

    private void reportFailure(Throwable throwable, @Nullable DataSource<T> dataSource) {
        ControllerListener2.Extras extras = this.obtainExtras(dataSource, null, null);
        this.getControllerListener().onFailure(this.mId, throwable);
        this.getControllerListener2().onFailure(this.mId, throwable, extras);
    }

    private void reportRelease(@Nullable Map<String, Object> datasourceExtras, @Nullable Map<String, Object> imageExtras) {
        this.getControllerListener().onRelease(this.mId);
        this.getControllerListener2().onRelease(this.mId, this.obtainExtras(datasourceExtras, imageExtras, null));
    }

    private ControllerListener2.Extras obtainExtras(@Nullable Map<String, Object> datasourceExtras, @Nullable Map<String, Object> imageExtras, @Nullable Uri mainUri) {
        String scaleType = null;
        PointF focusPoint = null;
        SettableDraweeHierarchy hierarchy = this.mSettableDraweeHierarchy;
        if (hierarchy instanceof GenericDraweeHierarchy) {
            scaleType = String.valueOf(((GenericDraweeHierarchy)hierarchy).getActualImageScaleType());
            focusPoint = ((GenericDraweeHierarchy)hierarchy).getActualImageFocusPoint();
        }
        return MiddlewareUtils.obtainExtras(COMPONENT_EXTRAS, SHORTCUT_EXTRAS, datasourceExtras, null, (Rect)this.getDimensions(), (String)scaleType, (PointF)focusPoint, imageExtras, (Object)this.getCallerContext(), (boolean)this.isLogWithHighSamplingRate(), (Uri)mainUri);
    }

    @Nullable
    protected Uri getMainUri() {
        return null;
    }

    private ControllerListener2.Extras obtainExtras(@Nullable DataSource<T> datasource, @Nullable INFO info, @Nullable Uri mainUri) {
        return this.obtainExtras(datasource == null ? null : datasource.getExtras(), this.obtainExtrasFromImage(info), mainUri);
    }

    @Nullable
    private Rect getDimensions() {
        if (this.mSettableDraweeHierarchy == null) {
            return null;
        }
        return this.mSettableDraweeHierarchy.getBounds();
    }

    @Nullable
    public abstract Map<String, Object> obtainExtrasFromImage(INFO var1);

    private SettableDraweeHierarchy getSettableDraweeHierarchy() {
        SettableDraweeHierarchy hierarchy = this.mSettableDraweeHierarchy;
        if (hierarchy == null) {
            throw new IllegalStateException("mSettableDraweeHierarchy is null; Caller context: " + this.mCallerContext);
        }
        return hierarchy;
    }

    private static class InternalForwardingListener<INFO>
    extends ForwardingControllerListener<INFO> {
        private InternalForwardingListener() {
        }

        public static <INFO> InternalForwardingListener<INFO> createInternal(ControllerListener<? super INFO> listener1, ControllerListener<? super INFO> listener2) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"AbstractDraweeController#createInternal");
            }
            InternalForwardingListener<Object> forwarder = new InternalForwardingListener<Object>();
            forwarder.addListener(listener1);
            forwarder.addListener(listener2);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return forwarder;
        }
    }
}

