/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Objects;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ScaleTypeDrawable
extends ForwardingDrawable {
    @VisibleForTesting
    ScalingUtils.ScaleType mScaleType;
    @Nullable
    @VisibleForTesting
    Object mScaleTypeState;
    @Nullable
    @VisibleForTesting
    PointF mFocusPoint = null;
    @VisibleForTesting
    int mUnderlyingWidth = 0;
    @VisibleForTesting
    int mUnderlyingHeight = 0;
    @Nullable
    @VisibleForTesting
    Matrix mDrawMatrix;
    private Matrix mTempMatrix = new Matrix();

    public ScaleTypeDrawable(@Nullable Drawable drawable, ScalingUtils.ScaleType scaleType) {
        super(drawable);
        this.mScaleType = scaleType;
    }

    public ScaleTypeDrawable(@Nullable Drawable drawable, ScalingUtils.ScaleType scaleType, @Nullable PointF focusPoint) {
        super(drawable);
        this.mScaleType = scaleType;
        this.mFocusPoint = focusPoint;
    }

    @Override
    @Nullable
    public Drawable setCurrent(@Nullable Drawable newDelegate) {
        Drawable previousDelegate = super.setCurrent(newDelegate);
        this.configureBounds();
        return previousDelegate;
    }

    public ScalingUtils.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ScalingUtils.ScaleType scaleType) {
        if (Objects.equal((Object)this.mScaleType, (Object)scaleType)) {
            return;
        }
        this.mScaleType = scaleType;
        this.mScaleTypeState = null;
        this.configureBounds();
        this.invalidateSelf();
    }

    @Nullable
    public PointF getFocusPoint() {
        return this.mFocusPoint;
    }

    public void setFocusPoint(@Nullable PointF focusPoint) {
        if (Objects.equal((Object)this.mFocusPoint, (Object)focusPoint)) {
            return;
        }
        if (focusPoint == null) {
            this.mFocusPoint = null;
        } else {
            if (this.mFocusPoint == null) {
                this.mFocusPoint = new PointF();
            }
            this.mFocusPoint.set(focusPoint);
        }
        this.configureBounds();
        this.invalidateSelf();
    }

    @Override
    public void draw(Canvas canvas) {
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            int saveCount = canvas.save();
            canvas.clipRect(this.getBounds());
            canvas.concat(this.mDrawMatrix);
            super.draw(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.draw(canvas);
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        this.configureBounds();
    }

    private void configureBoundsIfUnderlyingChanged() {
        boolean underlyingChanged;
        Drawable current;
        boolean scaleTypeChanged = false;
        if (this.mScaleType instanceof ScalingUtils.StatefulScaleType) {
            Object state = ((ScalingUtils.StatefulScaleType)((Object)this.mScaleType)).getState();
            scaleTypeChanged = state == null || !state.equals(this.mScaleTypeState);
            this.mScaleTypeState = state;
        }
        if ((current = this.getCurrent()) == null) {
            return;
        }
        boolean bl = underlyingChanged = this.mUnderlyingWidth != current.getIntrinsicWidth() || this.mUnderlyingHeight != current.getIntrinsicHeight();
        if (underlyingChanged || scaleTypeChanged) {
            this.configureBounds();
        }
    }

    @VisibleForTesting
    void configureBounds() {
        Drawable underlyingDrawable = this.getCurrent();
        if (underlyingDrawable == null) {
            this.mUnderlyingHeight = 0;
            this.mUnderlyingWidth = 0;
            this.mDrawMatrix = null;
            return;
        }
        Rect bounds = this.getBounds();
        int viewWidth = bounds.width();
        int viewHeight = bounds.height();
        int underlyingWidth = this.mUnderlyingWidth = underlyingDrawable.getIntrinsicWidth();
        int underlyingHeight = this.mUnderlyingHeight = underlyingDrawable.getIntrinsicHeight();
        if (underlyingWidth <= 0 || underlyingHeight <= 0) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        if (underlyingWidth == viewWidth && underlyingHeight == viewHeight) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        if (this.mScaleType == ScalingUtils.ScaleType.FIT_XY) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        underlyingDrawable.setBounds(0, 0, underlyingWidth, underlyingHeight);
        this.mScaleType.getTransform(this.mTempMatrix, bounds, underlyingWidth, underlyingHeight, this.mFocusPoint != null ? this.mFocusPoint.x : 0.5f, this.mFocusPoint != null ? this.mFocusPoint.y : 0.5f);
        this.mDrawMatrix = this.mTempMatrix;
    }

    @Override
    public void getTransform(Matrix transform) {
        this.getParentTransform(transform);
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            transform.preConcat(this.mDrawMatrix);
        }
    }
}

