/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;

public class InstrumentedDrawable
extends ForwardingDrawable {
    private final String mScaleType;
    private final Listener mListener;
    private boolean mIsChecked = false;

    public InstrumentedDrawable(Drawable drawable, Listener listener) {
        super(drawable);
        this.mListener = listener;
        this.mScaleType = this.getScaleType(drawable);
    }

    private String getScaleType(Drawable drawable) {
        if (drawable instanceof ScaleTypeDrawable) {
            ScalingUtils.ScaleType type = ((ScaleTypeDrawable)drawable).getScaleType();
            return type.toString();
        }
        return "none";
    }

    @Override
    public void draw(Canvas canvas) {
        if (!this.mIsChecked) {
            this.mIsChecked = true;
            RectF bounds = new RectF();
            this.getRootBounds(bounds);
            int viewWidth = (int)bounds.width();
            int viewHeight = (int)bounds.height();
            this.getTransformedBounds(bounds);
            int scaledWidth = (int)bounds.width();
            int scaledHeight = (int)bounds.height();
            int imageWidth = this.getIntrinsicWidth();
            int imageHeight = this.getIntrinsicHeight();
            if (this.mListener != null) {
                this.mListener.track(viewWidth, viewHeight, imageWidth, imageHeight, scaledWidth, scaledHeight, this.mScaleType);
            }
        }
        super.draw(canvas);
    }

    public static interface Listener {
        public void track(int var1, int var2, int var3, int var4, int var5, int var6, String var7);
    }
}

