/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.ArrayDrawable;
import java.util.Arrays;

public class FadeDrawable
extends ArrayDrawable {
    @VisibleForTesting
    public static final int TRANSITION_STARTING = 0;
    @VisibleForTesting
    public static final int TRANSITION_RUNNING = 1;
    @VisibleForTesting
    public static final int TRANSITION_NONE = 2;
    private final Drawable[] mLayers;
    private final boolean mDefaultLayerIsOn;
    private final int mDefaultLayerAlpha;
    @VisibleForTesting
    int mTransitionState;
    @VisibleForTesting
    int mDurationMs;
    @VisibleForTesting
    long mStartTimeMs;
    @VisibleForTesting
    int[] mStartAlphas;
    @VisibleForTesting
    int[] mAlphas;
    @VisibleForTesting
    int mAlpha;
    @VisibleForTesting
    boolean[] mIsLayerOn;
    @VisibleForTesting
    int mPreventInvalidateCount;

    public FadeDrawable(Drawable[] layers) {
        this(layers, false);
    }

    public FadeDrawable(Drawable[] layers, boolean allLayersVisible) {
        super(layers);
        Preconditions.checkState((layers.length >= 1 ? 1 : 0) != 0, (Object)"At least one layer required!");
        this.mLayers = layers;
        this.mStartAlphas = new int[layers.length];
        this.mAlphas = new int[layers.length];
        this.mAlpha = 255;
        this.mIsLayerOn = new boolean[layers.length];
        this.mPreventInvalidateCount = 0;
        this.mDefaultLayerIsOn = allLayersVisible;
        this.mDefaultLayerAlpha = this.mDefaultLayerIsOn ? 255 : 0;
        this.resetInternal();
    }

    public void invalidateSelf() {
        if (this.mPreventInvalidateCount == 0) {
            super.invalidateSelf();
        }
    }

    public void beginBatchMode() {
        ++this.mPreventInvalidateCount;
    }

    public void endBatchMode() {
        --this.mPreventInvalidateCount;
        this.invalidateSelf();
    }

    public void setTransitionDuration(int durationMs) {
        this.mDurationMs = durationMs;
        if (this.mTransitionState == 1) {
            this.mTransitionState = 0;
        }
    }

    public int getTransitionDuration() {
        return this.mDurationMs;
    }

    private void resetInternal() {
        this.mTransitionState = 2;
        Arrays.fill(this.mStartAlphas, this.mDefaultLayerAlpha);
        this.mStartAlphas[0] = 255;
        Arrays.fill(this.mAlphas, this.mDefaultLayerAlpha);
        this.mAlphas[0] = 255;
        Arrays.fill(this.mIsLayerOn, this.mDefaultLayerIsOn);
        this.mIsLayerOn[0] = true;
    }

    public void reset() {
        this.resetInternal();
        this.invalidateSelf();
    }

    public void fadeInLayer(int index) {
        this.mTransitionState = 0;
        this.mIsLayerOn[index] = true;
        this.invalidateSelf();
    }

    public void fadeOutLayer(int index) {
        this.mTransitionState = 0;
        this.mIsLayerOn[index] = false;
        this.invalidateSelf();
    }

    public void fadeInAllLayers() {
        this.mTransitionState = 0;
        Arrays.fill(this.mIsLayerOn, true);
        this.invalidateSelf();
    }

    public void fadeOutAllLayers() {
        this.mTransitionState = 0;
        Arrays.fill(this.mIsLayerOn, false);
        this.invalidateSelf();
    }

    public void fadeToLayer(int index) {
        this.mTransitionState = 0;
        Arrays.fill(this.mIsLayerOn, false);
        this.mIsLayerOn[index] = true;
        this.invalidateSelf();
    }

    public void fadeUpToLayer(int index) {
        this.mTransitionState = 0;
        Arrays.fill(this.mIsLayerOn, 0, index + 1, true);
        Arrays.fill(this.mIsLayerOn, index + 1, this.mLayers.length, false);
        this.invalidateSelf();
    }

    public void showLayerImmediately(int index) {
        this.mIsLayerOn[index] = true;
        this.mAlphas[index] = 255;
        this.invalidateSelf();
    }

    public void hideLayerImmediately(int index) {
        this.mIsLayerOn[index] = false;
        this.mAlphas[index] = 0;
        this.invalidateSelf();
    }

    public void finishTransitionImmediately() {
        this.mTransitionState = 2;
        for (int i = 0; i < this.mLayers.length; ++i) {
            this.mAlphas[i] = this.mIsLayerOn[i] ? 255 : 0;
        }
        this.invalidateSelf();
    }

    private boolean updateAlphas(float ratio) {
        boolean done = true;
        for (int i = 0; i < this.mLayers.length; ++i) {
            int dir = this.mIsLayerOn[i] ? 1 : -1;
            this.mAlphas[i] = (int)((float)this.mStartAlphas[i] + (float)(dir * 255) * ratio);
            if (this.mAlphas[i] < 0) {
                this.mAlphas[i] = 0;
            }
            if (this.mAlphas[i] > 255) {
                this.mAlphas[i] = 255;
            }
            if (this.mIsLayerOn[i] && this.mAlphas[i] < 255) {
                done = false;
            }
            if (this.mIsLayerOn[i] || this.mAlphas[i] <= 0) continue;
            done = false;
        }
        return done;
    }

    @Override
    public void draw(Canvas canvas) {
        boolean done = true;
        switch (this.mTransitionState) {
            case 0: {
                System.arraycopy(this.mAlphas, 0, this.mStartAlphas, 0, this.mLayers.length);
                this.mStartTimeMs = this.getCurrentTimeMs();
                float ratio = this.mDurationMs == 0 ? 1.0f : 0.0f;
                done = this.updateAlphas(ratio);
                this.mTransitionState = done ? 2 : 1;
                break;
            }
            case 1: {
                Preconditions.checkState((this.mDurationMs > 0 ? 1 : 0) != 0);
                float ratio = (float)(this.getCurrentTimeMs() - this.mStartTimeMs) / (float)this.mDurationMs;
                done = this.updateAlphas(ratio);
                this.mTransitionState = done ? 2 : 1;
                break;
            }
            case 2: {
                done = true;
            }
        }
        for (int i = 0; i < this.mLayers.length; ++i) {
            this.drawDrawableWithAlpha(canvas, this.mLayers[i], this.mAlphas[i] * this.mAlpha / 255);
        }
        if (!done) {
            this.invalidateSelf();
        }
    }

    private void drawDrawableWithAlpha(Canvas canvas, Drawable drawable, int alpha) {
        if (drawable != null && alpha > 0) {
            ++this.mPreventInvalidateCount;
            drawable.mutate().setAlpha(alpha);
            --this.mPreventInvalidateCount;
            drawable.draw(canvas);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    protected long getCurrentTimeMs() {
        return SystemClock.uptimeMillis();
    }

    @VisibleForTesting
    public int getTransitionState() {
        return this.mTransitionState;
    }

    public boolean isLayerOn(int index) {
        return this.mIsLayerOn[index];
    }

    public boolean isDefaultLayerIsOn() {
        return this.mDefaultLayerIsOn;
    }
}

