/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.debug.listener;

import android.graphics.drawable.Animatable;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.debug.listener.ImageLoadingTimeListener;
import javax.annotation.Nullable;

public class ImageLoadingTimeControllerListener
extends BaseControllerListener {
    private long mRequestSubmitTimeMs = -1L;
    private long mFinalImageSetTimeMs = -1L;
    @Nullable
    private ImageLoadingTimeListener mImageLoadingTimeListener;

    public ImageLoadingTimeControllerListener(@Nullable ImageLoadingTimeListener imageLoadingTimeListener) {
        this.mImageLoadingTimeListener = imageLoadingTimeListener;
    }

    @Override
    public void onSubmit(String id, Object callerContext) {
        this.mRequestSubmitTimeMs = System.currentTimeMillis();
    }

    @Override
    public void onFinalImageSet(String id, @Nullable Object imageInfo, @Nullable Animatable animatable) {
        this.mFinalImageSetTimeMs = System.currentTimeMillis();
        if (this.mImageLoadingTimeListener != null) {
            this.mImageLoadingTimeListener.onFinalImageSet(this.mFinalImageSetTimeMs - this.mRequestSubmitTimeMs);
        }
    }
}

