/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.R;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.imagepipeline.request.ImageRequest;
import javax.annotation.Nullable;

public class SimpleDraweeView
extends GenericDraweeView {
    private static Supplier<? extends AbstractDraweeControllerBuilder> sDraweecontrollerbuildersupplier;
    private AbstractDraweeControllerBuilder mControllerBuilder;

    public static void initialize(Supplier<? extends AbstractDraweeControllerBuilder> draweeControllerBuilderSupplier) {
        sDraweecontrollerbuildersupplier = draweeControllerBuilderSupplier;
    }

    public static void shutDown() {
        sDraweecontrollerbuildersupplier = null;
    }

    public SimpleDraweeView(Context context, GenericDraweeHierarchy hierarchy) {
        super(context, hierarchy);
        this.init(context, null);
    }

    public SimpleDraweeView(Context context) {
        super(context);
        this.init(context, null);
    }

    public SimpleDraweeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SimpleDraweeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public SimpleDraweeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        Preconditions.checkNotNull(sDraweecontrollerbuildersupplier, (Object)"SimpleDraweeView was not initialized!");
        this.mControllerBuilder = (AbstractDraweeControllerBuilder)sDraweecontrollerbuildersupplier.get();
        if (attrs != null) {
            TypedArray gdhAttrs = context.obtainStyledAttributes(attrs, R.styleable.SimpleDraweeView);
            try {
                int resId;
                if (gdhAttrs.hasValue(R.styleable.SimpleDraweeView_actualImageUri)) {
                    this.setImageURI(Uri.parse((String)gdhAttrs.getString(R.styleable.SimpleDraweeView_actualImageUri)), null);
                } else if (gdhAttrs.hasValue(R.styleable.SimpleDraweeView_actualImageResource) && (resId = gdhAttrs.getResourceId(R.styleable.SimpleDraweeView_actualImageResource, -1)) != -1) {
                    this.setActualImageResource(resId);
                }
            }
            finally {
                gdhAttrs.recycle();
            }
        }
    }

    protected AbstractDraweeControllerBuilder getControllerBuilder() {
        return this.mControllerBuilder;
    }

    public void setImageRequest(ImageRequest request) {
        AbstractDraweeControllerBuilder controllerBuilder = this.mControllerBuilder;
        AbstractDraweeController controller = ((AbstractDraweeControllerBuilder)((AbstractDraweeControllerBuilder)controllerBuilder.setImageRequest(request)).setOldController(this.getController())).build();
        this.setController(controller);
    }

    @Override
    public void setImageURI(Uri uri) {
        this.setImageURI(uri, null);
    }

    public void setImageURI(@Nullable String uriString) {
        this.setImageURI(uriString, null);
    }

    public void setImageURI(Uri uri, @Nullable Object callerContext) {
        DraweeController controller = this.mControllerBuilder.setCallerContext(callerContext).setUri(uri).setOldController(this.getController()).build();
        this.setController(controller);
    }

    public void setImageURI(@Nullable String uriString, @Nullable Object callerContext) {
        Uri uri = uriString != null ? Uri.parse((String)uriString) : null;
        this.setImageURI(uri, callerContext);
    }

    public void setActualImageResource(@DrawableRes int resourceId) {
        this.setActualImageResource(resourceId, null);
    }

    public void setActualImageResource(@DrawableRes int resourceId, @Nullable Object callerContext) {
        this.setImageURI(UriUtil.getUriForResourceId((int)resourceId), callerContext);
    }

    @Override
    public void setImageResource(int resId) {
        super.setImageResource(resId);
    }
}

