/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Matrix;
import android.graphics.Rect;

public class ScalingUtils {
    public static Matrix getTransform(Matrix transform, Rect parentBounds, int childWidth, int childHeight, float focusX, float focusY, ScaleType scaleType) {
        int parentWidth = parentBounds.width();
        int parentHeight = parentBounds.height();
        float scaleX = (float)parentWidth / (float)childWidth;
        float scaleY = (float)parentHeight / (float)childHeight;
        float scale = 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        switch (scaleType) {
            case FIT_XY: {
                dx = parentBounds.left;
                dy = parentBounds.top;
                transform.setScale(scaleX, scaleY);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case FIT_START: {
                scale = Math.min(scaleX, scaleY);
                dx = parentBounds.left;
                dy = parentBounds.top;
                transform.setScale(scale, scale);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case FIT_CENTER: {
                scale = Math.min(scaleX, scaleY);
                dx = (float)parentBounds.left + ((float)parentWidth - (float)childWidth * scale) * 0.5f;
                dy = (float)parentBounds.top + ((float)parentHeight - (float)childHeight * scale) * 0.5f;
                transform.setScale(scale, scale);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case FIT_END: {
                scale = Math.min(scaleX, scaleY);
                dx = (float)parentBounds.left + ((float)parentWidth - (float)childWidth * scale);
                dy = (float)parentBounds.top + ((float)parentHeight - (float)childHeight * scale);
                transform.setScale(scale, scale);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case CENTER: {
                dx = (float)parentBounds.left + (float)(parentWidth - childWidth) * 0.5f;
                dy = (float)parentBounds.top + (float)(parentHeight - childHeight) * 0.5f;
                transform.setTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case CENTER_INSIDE: {
                scale = Math.min(Math.min(scaleX, scaleY), 1.0f);
                dx = (float)parentBounds.left + ((float)parentWidth - (float)childWidth * scale) * 0.5f;
                dy = (float)parentBounds.top + ((float)parentHeight - (float)childHeight * scale) * 0.5f;
                transform.setScale(scale, scale);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case CENTER_CROP: {
                if (scaleY > scaleX) {
                    scale = scaleY;
                    dx = (float)parentBounds.left + ((float)parentWidth - (float)childWidth * scale) * 0.5f;
                    dy = parentBounds.top;
                } else {
                    scale = scaleX;
                    dx = parentBounds.left;
                    dy = (float)parentBounds.top + ((float)parentHeight - (float)childHeight * scale) * 0.5f;
                }
                transform.setScale(scale, scale);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            case FOCUS_CROP: {
                if (scaleY > scaleX) {
                    scale = scaleY;
                    dx = (float)parentWidth * 0.5f - (float)childWidth * scale * focusX;
                    dx = (float)parentBounds.left + Math.max(Math.min(dx, 0.0f), (float)parentWidth - (float)childWidth * scale);
                    dy = parentBounds.top;
                } else {
                    scale = scaleX;
                    dx = parentBounds.left;
                    dy = (float)parentHeight * 0.5f - (float)childHeight * scale * focusY;
                    dy = (float)parentBounds.top + Math.max(Math.min(dy, 0.0f), (float)parentHeight - (float)childHeight * scale);
                }
                transform.setScale(scale, scale);
                transform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scale type: " + (Object)((Object)scaleType));
            }
        }
        return transform;
    }

    public static enum ScaleType {
        FIT_XY,
        FIT_START,
        FIT_CENTER,
        FIT_END,
        CENTER,
        CENTER_INSIDE,
        CENTER_CROP,
        FOCUS_CROP;


        public static ScaleType fromString(String value) {
            if (value.equals("none")) {
                return null;
            }
            if (value.equals("fitXY")) {
                return FIT_XY;
            }
            if (value.equals("fitStart")) {
                return FIT_START;
            }
            if (value.equals("fitCenter")) {
                return FIT_CENTER;
            }
            if (value.equals("fitEnd")) {
                return FIT_END;
            }
            if (value.equals("center")) {
                return CENTER;
            }
            if (value.equals("centerInside")) {
                return CENTER_INSIDE;
            }
            if (value.equals("centerCrop")) {
                return CENTER_CROP;
            }
            if (value.equals("focusCrop")) {
                return FOCUS_CROP;
            }
            throw new IllegalArgumentException("Unrecognized scale type: " + value + "; use a value defined in the ScalingUtils.fromString method");
        }
    }
}

