/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import javax.annotation.Nullable;

public class DrawableUtils {
    public static void copyProperties(Drawable to, Drawable from) {
        if (from == null || to == null || to == from) {
            return;
        }
        to.setBounds(from.getBounds());
        to.setChangingConfigurations(from.getChangingConfigurations());
        to.setLevel(from.getLevel());
        to.setVisible(from.isVisible(), false);
        to.setState(from.getState());
    }

    public static void setDrawableProperties(Drawable drawable, DrawableProperties properties) {
        if (drawable == null || properties == null) {
            return;
        }
        drawable.setAlpha(properties.getAlpha());
        drawable.setColorFilter(properties.getColorFilter());
        drawable.setDither(properties.isDither());
        drawable.setFilterBitmap(properties.isFilterBitmap());
    }

    public static void setCallbacks(Drawable drawable, @Nullable Drawable.Callback callback, @Nullable TransformCallback transformCallback) {
        if (drawable != null) {
            drawable.setCallback(callback);
            if (drawable instanceof TransformAwareDrawable) {
                ((TransformAwareDrawable)drawable).setTransformCallback(transformCallback);
            }
        }
    }

    public static int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        alpha += alpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * alpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    public static int getOpacityFromColor(int color) {
        int colorAlpha = color >>> 24;
        if (colorAlpha == 255) {
            return -1;
        }
        if (colorAlpha == 0) {
            return -2;
        }
        return -3;
    }
}

