/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Matrix;
import android.graphics.Rect;
import javax.annotation.Nullable;

public class ScalingUtils {
    @Deprecated
    public static Matrix getTransform(Matrix transform, Rect parentBounds, int childWidth, int childHeight, float focusX, float focusY, ScaleType scaleType) {
        return scaleType.getTransform(transform, parentBounds, childWidth, childHeight, focusX, focusY);
    }

    public static class InterpolatingScaleType
    implements ScaleType,
    StatefulScaleType {
        private final ScaleType mScaleTypeFrom;
        private final ScaleType mScaleTypeTo;
        @Nullable
        private final Rect mBoundsFrom;
        @Nullable
        private final Rect mBoundsTo;
        private final float[] mMatrixValuesFrom = new float[9];
        private final float[] mMatrixValuesTo = new float[9];
        private final float[] mMatrixValuesInterpolated = new float[9];
        private float mInterpolatingValue;

        public InterpolatingScaleType(ScaleType scaleTypeFrom, ScaleType scaleTypeTo, @Nullable Rect boundsFrom, @Nullable Rect boundsTo) {
            this.mScaleTypeFrom = scaleTypeFrom;
            this.mScaleTypeTo = scaleTypeTo;
            this.mBoundsFrom = boundsFrom;
            this.mBoundsTo = boundsTo;
        }

        public InterpolatingScaleType(ScaleType scaleTypeFrom, ScaleType scaleTypeTo) {
            this(scaleTypeFrom, scaleTypeTo, null, null);
        }

        public ScaleType getScaleTypeFrom() {
            return this.mScaleTypeFrom;
        }

        public ScaleType getScaleTypeTo() {
            return this.mScaleTypeTo;
        }

        @Nullable
        public Rect getBoundsFrom() {
            return this.mBoundsFrom;
        }

        @Nullable
        public Rect getBoundsTo() {
            return this.mBoundsTo;
        }

        public void setValue(float value) {
            this.mInterpolatingValue = value;
        }

        public float getValue() {
            return this.mInterpolatingValue;
        }

        @Override
        public Object getState() {
            return Float.valueOf(this.mInterpolatingValue);
        }

        @Override
        public Matrix getTransform(Matrix transform, Rect parentBounds, int childWidth, int childHeight, float focusX, float focusY) {
            Rect boundsFrom = this.mBoundsFrom != null ? this.mBoundsFrom : parentBounds;
            Rect boundsTo = this.mBoundsTo != null ? this.mBoundsTo : parentBounds;
            this.mScaleTypeFrom.getTransform(transform, boundsFrom, childWidth, childHeight, focusX, focusY);
            transform.getValues(this.mMatrixValuesFrom);
            this.mScaleTypeTo.getTransform(transform, boundsTo, childWidth, childHeight, focusX, focusY);
            transform.getValues(this.mMatrixValuesTo);
            for (int i = 0; i < 9; ++i) {
                this.mMatrixValuesInterpolated[i] = this.mMatrixValuesFrom[i] * (1.0f - this.mInterpolatingValue) + this.mMatrixValuesTo[i] * this.mInterpolatingValue;
            }
            transform.setValues(this.mMatrixValuesInterpolated);
            return transform;
        }
    }

    public static interface StatefulScaleType {
        public Object getState();
    }

    private static class ScaleTypeFocusCrop
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFocusCrop();

        private ScaleTypeFocusCrop() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dy;
            float dx;
            float scale;
            if (scaleY > scaleX) {
                scale = scaleY;
                dx = (float)parentRect.width() * 0.5f - (float)childWidth * scale * focusX;
                dx = (float)parentRect.left + Math.max(Math.min(dx, 0.0f), (float)parentRect.width() - (float)childWidth * scale);
                dy = parentRect.top;
            } else {
                scale = scaleX;
                dx = parentRect.left;
                dy = (float)parentRect.height() * 0.5f - (float)childHeight * scale * focusY;
                dy = (float)parentRect.top + Math.max(Math.min(dy, 0.0f), (float)parentRect.height() - (float)childHeight * scale);
            }
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeCenterCrop
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeCenterCrop();

        private ScaleTypeCenterCrop() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dy;
            float dx;
            float scale;
            if (scaleY > scaleX) {
                scale = scaleY;
                dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
                dy = parentRect.top;
            } else {
                scale = scaleX;
                dx = parentRect.left;
                dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            }
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeCenterInside
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeCenterInside();

        private ScaleTypeCenterInside() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(Math.min(scaleX, scaleY), 1.0f);
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeCenter
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeCenter();

        private ScaleTypeCenter() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dx = (float)parentRect.left + (float)(parentRect.width() - childWidth) * 0.5f;
            float dy = (float)parentRect.top + (float)(parentRect.height() - childHeight) * 0.5f;
            outTransform.setTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeFitEnd
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitEnd();

        private ScaleTypeFitEnd() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale);
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale);
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeFitCenter
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitCenter();

        private ScaleTypeFitCenter() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeFitStart
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitStart();

        private ScaleTypeFitStart() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = parentRect.left;
            float dy = parentRect.top;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    private static class ScaleTypeFitXY
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitXY();

        private ScaleTypeFitXY() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dx = parentRect.left;
            float dy = parentRect.top;
            outTransform.setScale(scaleX, scaleY);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }
    }

    public static abstract class AbstractScaleType
    implements ScaleType {
        @Override
        public Matrix getTransform(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY) {
            float sX = (float)parentRect.width() / (float)childWidth;
            float sY = (float)parentRect.height() / (float)childHeight;
            this.getTransformImpl(outTransform, parentRect, childWidth, childHeight, focusX, focusY, sX, sY);
            return outTransform;
        }

        public abstract void getTransformImpl(Matrix var1, Rect var2, int var3, int var4, float var5, float var6, float var7, float var8);
    }

    public static interface ScaleType {
        public static final ScaleType FIT_XY = ScaleTypeFitXY.INSTANCE;
        public static final ScaleType FIT_START = ScaleTypeFitStart.INSTANCE;
        public static final ScaleType FIT_CENTER = ScaleTypeFitCenter.INSTANCE;
        public static final ScaleType FIT_END = ScaleTypeFitEnd.INSTANCE;
        public static final ScaleType CENTER = ScaleTypeCenter.INSTANCE;
        public static final ScaleType CENTER_INSIDE = ScaleTypeCenterInside.INSTANCE;
        public static final ScaleType CENTER_CROP = ScaleTypeCenterCrop.INSTANCE;
        public static final ScaleType FOCUS_CROP = ScaleTypeFocusCrop.INSTANCE;

        public Matrix getTransform(Matrix var1, Rect var2, int var3, int var4, float var5, float var6);
    }
}

