/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.view;

import android.view.View;
import android.view.ViewGroup;
import javax.annotation.Nullable;

public class AspectRatioMeasure {
    public static void updateMeasureSpec(Spec spec, float aspectRatio, @Nullable ViewGroup.LayoutParams layoutParams, int widthPadding, int heightPadding) {
        if (aspectRatio <= 0.0f || layoutParams == null) {
            return;
        }
        if (AspectRatioMeasure.shouldAdjust(layoutParams.height)) {
            int widthSpecSize = View.MeasureSpec.getSize((int)spec.width);
            int desiredHeight = (int)((float)(widthSpecSize - widthPadding) / aspectRatio + (float)heightPadding);
            int resolvedHeight = View.resolveSize((int)desiredHeight, (int)spec.height);
            spec.height = View.MeasureSpec.makeMeasureSpec((int)resolvedHeight, (int)0x40000000);
        } else if (AspectRatioMeasure.shouldAdjust(layoutParams.width)) {
            int heightSpecSize = View.MeasureSpec.getSize((int)spec.height);
            int desiredWidth = (int)((float)(heightSpecSize - heightPadding) * aspectRatio + (float)widthPadding);
            int resolvedWidth = View.resolveSize((int)desiredWidth, (int)spec.width);
            spec.width = View.MeasureSpec.makeMeasureSpec((int)resolvedWidth, (int)0x40000000);
        }
    }

    private static boolean shouldAdjust(int layoutDimension) {
        return layoutDimension == 0 || layoutDimension == -2;
    }

    public static class Spec {
        public int width;
        public int height;
    }
}

