/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;

public class ForwardingDrawable
extends Drawable
implements Drawable.Callback,
TransformCallback,
TransformAwareDrawable,
DrawableParent {
    private Drawable mCurrentDelegate;
    private final DrawableProperties mDrawableProperties = new DrawableProperties();
    protected TransformCallback mTransformCallback;
    private static final Matrix sTempTransform = new Matrix();

    public ForwardingDrawable(Drawable drawable) {
        this.mCurrentDelegate = drawable;
        DrawableUtils.setCallbacks(this.mCurrentDelegate, this, this);
    }

    public Drawable setCurrent(Drawable newDelegate) {
        Drawable previousDelegate = this.setCurrentWithoutInvalidate(newDelegate);
        this.invalidateSelf();
        return previousDelegate;
    }

    protected Drawable setCurrentWithoutInvalidate(Drawable newDelegate) {
        Drawable previousDelegate = this.mCurrentDelegate;
        DrawableUtils.setCallbacks(previousDelegate, null, null);
        DrawableUtils.setCallbacks(newDelegate, null, null);
        DrawableUtils.setDrawableProperties(newDelegate, this.mDrawableProperties);
        DrawableUtils.copyProperties(newDelegate, this);
        DrawableUtils.setCallbacks(newDelegate, this, this);
        this.mCurrentDelegate = newDelegate;
        return previousDelegate;
    }

    public int getOpacity() {
        return this.mCurrentDelegate.getOpacity();
    }

    public void setAlpha(int alpha) {
        this.mDrawableProperties.setAlpha(alpha);
        this.mCurrentDelegate.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mDrawableProperties.setColorFilter(colorFilter);
        this.mCurrentDelegate.setColorFilter(colorFilter);
    }

    public void setDither(boolean dither) {
        this.mDrawableProperties.setDither(dither);
        this.mCurrentDelegate.setDither(dither);
    }

    public void setFilterBitmap(boolean filterBitmap) {
        this.mDrawableProperties.setFilterBitmap(filterBitmap);
        this.mCurrentDelegate.setFilterBitmap(filterBitmap);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        super.setVisible(visible, restart);
        return this.mCurrentDelegate.setVisible(visible, restart);
    }

    protected void onBoundsChange(Rect bounds) {
        this.mCurrentDelegate.setBounds(bounds);
    }

    public boolean isStateful() {
        return this.mCurrentDelegate.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        return this.mCurrentDelegate.setState(state);
    }

    protected boolean onLevelChange(int level) {
        return this.mCurrentDelegate.setLevel(level);
    }

    public void draw(Canvas canvas) {
        this.mCurrentDelegate.draw(canvas);
    }

    public int getIntrinsicWidth() {
        return this.mCurrentDelegate.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mCurrentDelegate.getIntrinsicHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.mCurrentDelegate.getPadding(padding);
    }

    public Drawable mutate() {
        this.mCurrentDelegate.mutate();
        return this;
    }

    public Drawable getCurrent() {
        return this.mCurrentDelegate;
    }

    @Override
    public Drawable setDrawable(Drawable newDrawable) {
        return this.setCurrent(newDrawable);
    }

    @Override
    public Drawable getDrawable() {
        return this.getCurrent();
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    public void setTransformCallback(TransformCallback transformCallback) {
        this.mTransformCallback = transformCallback;
    }

    protected void getParentTransform(Matrix transform) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getTransform(transform);
        } else {
            transform.reset();
        }
    }

    @Override
    public void getTransform(Matrix transform) {
        this.getParentTransform(transform);
    }

    @Override
    public void getRootBounds(RectF bounds) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getRootBounds(bounds);
        } else {
            bounds.set(this.getBounds());
        }
    }

    public void getTransformedBounds(RectF outBounds) {
        this.getParentTransform(sTempTransform);
        outBounds.set(this.getBounds());
        sTempTransform.mapRect(outBounds);
    }
}

