/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.javadoc;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;
import com.facebook.drift.javadoc.ThriftAnnotations;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.facebook.drift.annotations.ThriftEnum", "com.facebook.drift.annotations.ThriftService", "com.facebook.drift.annotations.ThriftStruct"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class JavadocProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        for (TypeElement typeElement : annotations) {
            for (Element element : round.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                this.log(Diagnostic.Kind.NOTE, "Extracting Javadoc metadata for " + element);
                this.extract((TypeElement)element);
            }
        }
        return false;
    }

    private void extract(TypeElement typeElement) {
        if (typeElement.getQualifiedName().toString().endsWith("$DriftMeta")) {
            return;
        }
        switch (typeElement.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                break;
            }
            default: {
                this.log(Diagnostic.Kind.WARNING, String.format("Non-class was annotated: %s %s", new Object[]{typeElement.getKind(), typeElement}));
                return;
            }
        }
        List<String> serviceDocumentation = this.getComment(typeElement);
        String packageName = this.elements().getPackageOf(typeElement).getQualifiedName().toString();
        String className = this.getClassName(typeElement);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)(className + "$DriftMeta")).addAnnotation(JavadocProcessor.documentationAnnotation(serviceDocumentation));
        AtomicInteger nextOrder = new AtomicInteger(10000);
        for (Element element : this.elements().getAllMembers(typeElement)) {
            String name = element.getSimpleName().toString();
            List<String> comment = this.getComment(element);
            if (element instanceof ExecutableElement && (JavadocProcessor.isAnnotatedWith(element, ThriftAnnotations.THRIFT_METHOD) || JavadocProcessor.isAnnotatedWith(element, ThriftAnnotations.THRIFT_FIELD))) {
                typeSpec.addMethod(MethodSpec.methodBuilder((String)name).addAnnotation(JavadocProcessor.documentationAnnotation(comment)).addAnnotation(JavadocProcessor.orderAnnotation(nextOrder.getAndIncrement())).build());
                continue;
            }
            if ((!(element instanceof VariableElement) || !JavadocProcessor.isAnnotatedWith(element, ThriftAnnotations.THRIFT_FIELD)) && element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            typeSpec.addField(FieldSpec.builder(Integer.TYPE, (String)name, (Modifier[])new Modifier[0]).addAnnotation(JavadocProcessor.documentationAnnotation(comment)).addAnnotation(JavadocProcessor.orderAnnotation(nextOrder.getAndIncrement())).build());
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec.build()).build();
        String string = typeElement.getQualifiedName() + "$DriftMeta";
        try (Writer writer = this.filer().createSourceFile(string, typeElement).openWriter();){
            javaFile.writeTo((Appendable)writer);
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s%s file", typeElement, "$DriftMeta"));
        }
    }

    private static AnnotationSpec documentationAnnotation(List<String> lines) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(ThriftDocumentation.class);
        for (String line : lines) {
            builder.addMember("value", "$S", new Object[]{line});
        }
        return builder.build();
    }

    private static AnnotationSpec orderAnnotation(int value) {
        return AnnotationSpec.builder(ThriftOrder.class).addMember("value", "$L", new Object[]{value}).build();
    }

    private String getClassName(TypeElement typeElement) {
        String binaryName = this.elements().getBinaryName(typeElement).toString();
        return binaryName.substring(binaryName.lastIndexOf(46) + 1);
    }

    private static boolean isAnnotatedWith(Element element, String annotation) {
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(TypeMirror::toString).anyMatch(annotation::equals);
    }

    private List<String> getComment(Element element) {
        String comment = this.elements().getDocComment(element);
        if (comment == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(comment.split("\n")).map(String::trim).collect(Collectors.toList());
    }

    private Elements elements() {
        return this.processingEnv.getElementUtils();
    }

    private Filer filer() {
        return this.processingEnv.getFiler();
    }

    private void log(Diagnostic.Kind kind, String message) {
        this.processingEnv.getMessager().printMessage(kind, message);
    }
}

