/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.RecoverableOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public abstract class ServerCommunication {
    protected ByteArrayOutputStream outData;
    protected EXAOutputStream outStream;
    protected byte[] tmpBytes;
    protected byte[] tmpBytes2;
    protected InMessage tmpInMessage;
    protected OutMessage tmpOutMessage;
    protected EXAResult[] tmpEXAResults;
    protected DebugLog debug;
    protected static boolean trace_exception = false;
    protected String className;
    protected EXAConnection connection;
    private int reconnectWatcher = 0;

    public ServerCommunication(DebugLog debugLog, String string, EXAConnection eXAConnection) {
        this.connection = eXAConnection;
        this.className = string;
        this.debug = debugLog;
        this.outData = new ByteArrayOutputStream();
        this.outStream = new EXAOutputStream(this.outData, this.connection);
        this.tmpBytes = null;
        this.tmpBytes2 = null;
        this.tmpInMessage = null;
        this.tmpOutMessage = null;
    }

    protected void log(Object object) {
        if (this.debug != null) {
            this.debug.log(this.className + ": " + object.toString());
        }
    }

    protected void log(Object object, int n) {
        this.log(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(RecoverableOperation recoverableOperation) throws IOException, SQLException {
        int n = 0;
        do {
            ++n;
            try {
                recoverableOperation.op();
                return;
            }
            catch (IOException iOException) {
                this.connection.clearWarnings();
                try {
                    if (this.reconnectWatcher > 0) {
                        this.reconnectWatcher = 0;
                        throw new ConnectionException(iOException.toString() + " Reconnect not possible, check for previous errors.");
                    }
                    ++this.reconnectWatcher;
                    this.connection.reconnect();
                }
                finally {
                    --this.reconnectWatcher;
                }
            }
            catch (ConnectionException connectionException) {
                this.connection.clearWarnings();
                try {
                    if (this.reconnectWatcher > 0) {
                        this.reconnectWatcher = 0;
                        throw new ConnectionException(connectionException.toString() + " Reconnect not possible, check for previous errors.");
                    }
                    ++this.reconnectWatcher;
                    this.connection.reconnect();
                }
                finally {
                    --this.reconnectWatcher;
                }
            }
            SQLWarning sQLWarning = this.connection.getWarnings();
            if (sQLWarning == null) continue;
            this.connection.clearWarnings();
            throw sQLWarning;
        } while (n < 2);
    }
}

