/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class EXARowCount
extends EXAResult {
    private int rowCount = 0;
    private long longRowCount = 0L;

    EXARowCount(EXAInputStream eXAInputStream, DebugLog debugLog) throws IOException, ProtocolException {
        super("EXARowCount", debugLog);
        this.longRowCount = eXAInputStream.readLong();
        if (this.longRowCount <= Integer.MIN_VALUE) {
            throw new ProtocolException(Translator.Rowcount_out_of_bounds() + this.longRowCount);
        }
        this.rowCount = this.longRowCount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.longRowCount;
        if (debugLog != null) {
            debugLog.log("created rowcount: " + this.rowCount);
        }
    }

    public long getLongRowCount() {
        return this.longRowCount;
    }

    public void close() throws SQLException {
    }

    public void checkSum() throws SQLException {
        throw new NotImplemented(this.debug, Translator.not_supported_checksum_on_rowcount());
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public EXAResultSet toResultSet() {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{new BigDecimal(this.rowCount)};
        return this.connection.dialectFactory.createResultSet("RowCount", bigDecimalArray, this.debug);
    }
}

