/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DataException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;

class DoubleColumn
extends Column {
    double[] values;
    DecimalFormat formatter1a;
    DecimalFormat formatter1b;
    DecimalFormat formatter2;
    DecimalFormat expFormat = (DecimalFormat)DecimalFormat.getInstance();

    DoubleColumn(String string, double[] dArray) {
        super(string);
        this.values = dArray;
        this.formatter1a = new DecimalFormat("##############0.##");
        this.formatter1b = new DecimalFormat("#####0.##########");
        this.formatter2 = new DecimalFormat("0.00000000E000");
        this.expFormat.applyPattern("+000;-000");
    }

    DoubleColumn() {
        this.values = new double[initialBatchCapacity];
        this.formatter1a = new DecimalFormat("##############0.##");
        this.formatter1b = new DecimalFormat("#####0.##########");
        this.formatter2 = new DecimalFormat("0.00000000E000");
        this.expFormat.applyPattern("+000;-000");
    }

    int getPrecision() throws SQLException {
        return 0;
    }

    int getScale() throws SQLException {
        return 0;
    }

    String getClassName() {
        return "java.lang.Double";
    }

    int getDisplaySize(EXAConnection eXAConnection) {
        return 16;
    }

    int getType() {
        return 8;
    }

    String getTypeName() {
        return "DOUBLE PRECISION";
    }

    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getObject: " + Translator.Accessed_null_value());
        }
        return new Double(this.values[n]);
    }

    private String reformatExp(String string) {
        int n = string.lastIndexOf(69);
        if (n >= 0) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                Integer n2 = new Integer(string.substring(n + 1));
                stringBuffer.append(string.substring(0, n + 1));
                stringBuffer.append(this.expFormat.format(n2));
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                return string;
            }
        }
        return string;
    }

    static final double abs(double d) {
        if (d < 0.0) {
            return -d;
        }
        return d;
    }

    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getString: " + Translator.Accessed_null_value());
        }
        double d = DoubleColumn.abs(this.values[n]);
        if (d > 0.0 && d <= 1.0E-10) {
            return this.reformatExp(this.formatter2.format(this.values[n]));
        }
        if (d < 10000.0) {
            return this.formatter1b.format(this.values[n]);
        }
        if (d < 1.0E15) {
            return this.formatter1a.format(this.values[n]);
        }
        return this.reformatExp(this.formatter2.format(this.values[n]));
    }

    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getByte: " + Translator.Accessed_null_value());
        }
        double d = this.values[n];
        if (d < -128.0 || d > 127.0) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (byte)d;
    }

    short getShort(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getShort: " + Translator.Accessed_null_value());
        }
        double d = this.values[n];
        if (d < -32768.0 || d > 32767.0) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (short)d;
    }

    int getInt(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getInt: " + Translator.Accessed_null_value());
        }
        double d = this.values[n];
        if (d < -2.147483648E9 || d > 2.147483647E9) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (int)this.values[n];
    }

    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getLong: " + Translator.Accessed_null_value());
        }
        double d = this.values[n];
        if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (long)this.values[n];
    }

    double getDouble(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    float getFloat(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return (float)this.values[n];
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DoubleColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return new BigDecimal(this.values[n]);
    }

    void setString(int n, String string) {
        this.validMask[n] = true;
        this.values[n] = Double.parseDouble(string);
    }

    void setByte(int n, byte by) {
        this.validMask[n] = true;
        this.values[n] = by;
    }

    void setDouble(int n, double d) {
        this.validMask[n] = true;
        this.values[n] = d;
    }

    void setFloat(int n, float f) {
        this.validMask[n] = true;
        this.values[n] = f;
    }

    void setShort(int n, short s) {
        this.validMask[n] = true;
        this.values[n] = s;
    }

    void setInt(int n, int n2) {
        this.validMask[n] = true;
        this.values[n] = n2;
    }

    void setLong(int n, long l) {
        this.validMask[n] = true;
        this.values[n] = l;
    }

    void resize(int n) {
        int n2;
        double[] dArray = new double[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = this.values[n2];
            blArray[n2] = this.validMask[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.values = dArray;
        this.validMask = blArray;
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) {
        return new DoubleColumn();
    }

    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            eXAOutputStream.writeDouble(this.values[n]);
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.validMask[n] = true;
            this.values[n] = eXAInputStream.readDouble();
        }
    }

    int getEXAType() {
        return 8;
    }

    boolean isSigned() throws SQLException {
        return true;
    }
}

