/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DataException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;

class DecimalColumn
extends Column {
    long[] values;
    int prec;
    int scale;
    long factor;
    DecimalFormat formatter;

    DecimalColumn(String string, long[] lArray, int n, int n2) {
        super(string);
        this.values = lArray;
        this.prec = n;
        this.scale = n2;
        if (this.scale > this.prec) {
            this.prec = this.scale;
        }
        this.formatter = new DecimalFormat(this.repeat('#', this.prec - 1 - this.scale) + "0" + (this.scale > 0 ? "." : "") + this.repeat('0', this.scale));
        this.compFactor();
    }

    DecimalColumn(int n, int n2) {
        this.values = new long[initialBatchCapacity];
        this.prec = n;
        this.scale = n2;
        if (this.scale > this.prec) {
            this.prec = this.scale;
        }
        this.formatter = new DecimalFormat(this.repeat('#', this.prec - 1 - this.scale) + "0" + (this.scale > 0 ? "." : "") + this.repeat('0', this.scale));
        this.compFactor();
    }

    public static final int getPrecision(BigDecimal bigDecimal) {
        return 36;
    }

    int getPrecision() throws SQLException {
        return this.prec;
    }

    int getScale() throws SQLException {
        return this.scale;
    }

    String repeat(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    void compFactor() {
        this.factor = 1L;
        for (int i = 0; i < this.scale; ++i) {
            this.factor *= 10L;
        }
    }

    String getClassName() {
        if (0 == this.scale) {
            if (this.prec <= 4) {
                return "java.lang.Short";
            }
            if (this.prec <= 9) {
                return "java.lang.Integer";
            }
            if (this.prec <= 18) {
                return "java.lang.Long";
            }
        }
        return "java.math.BigDecimal";
    }

    int getDisplaySize(EXAConnection eXAConnection) {
        return this.prec + 2;
    }

    int getType() {
        if (0 == this.scale) {
            if (this.prec <= 4) {
                return 5;
            }
            if (this.prec <= 9) {
                return 4;
            }
            if (this.prec <= 18) {
                return -5;
            }
        }
        return 3;
    }

    String getTypeName() {
        if (0 == this.scale) {
            if (this.prec <= 4) {
                return "SMALLINT";
            }
            if (this.prec <= 9) {
                return "INTEGER";
            }
            if (this.prec <= 18) {
                return "BIGINT";
            }
        }
        return "DECIMAL";
    }

    void setString(int n, String string) {
        this.validMask[n] = true;
        this.values[n] = Long.parseLong(string) * this.factor;
    }

    void setByte(int n, byte by) {
        this.validMask[n] = true;
        this.values[n] = (long)by * this.factor;
    }

    void setShort(int n, short s) {
        this.validMask[n] = true;
        this.values[n] = (long)s * this.factor;
    }

    void setInt(int n, int n2) {
        this.validMask[n] = true;
        this.values[n] = (long)n2 * this.factor;
    }

    void setLong(int n, long l) {
        this.validMask[n] = true;
        this.values[n] = l * this.factor;
    }

    void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.prec == 0) {
            this.prec = DecimalColumn.getPrecision(bigDecimal);
            this.scale = bigDecimal.scale();
            if (this.scale > this.prec) {
                this.prec = this.scale;
            }
        } else if (bigDecimal.scale() != this.scale) {
            throw new DataException(Translator.most_specific_type_mismatch(), new String("00G"));
        }
        if (DecimalColumn.getPrecision(bigDecimal) > this.prec) {
            this.prec = DecimalColumn.getPrecision(bigDecimal);
        }
        this.validMask[n] = true;
        this.values[n] = bigDecimal.movePointRight(this.scale).longValue();
    }

    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getObject: " + Translator.Accessed_null_value());
        }
        switch (this.getType()) {
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
        }
        return BigDecimal.valueOf(this.values[n], this.scale);
    }

    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.formatter.format(BigDecimal.valueOf(this.values[n], this.scale));
    }

    boolean getBoolean(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if (l == 0L) {
            return false;
        }
        if (l == 1L) {
            return true;
        }
        throw new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if ((long)((byte)l) != l) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (byte)l;
    }

    short getShort(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getShort: " + Translator.Accessed_null_value());
        }
        long l = this.values[n] / this.factor;
        if ((long)((short)l) != l) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (short)l;
    }

    int getInt(int n) throws SQLException {
        long l = this.values[n] / this.factor;
        if ((long)((int)l) != l) {
            throw new DataException(Translator.numeric_value_out_of_range(), new String("003"));
        }
        return (int)this.values[n];
    }

    double getDouble(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return (double)this.values[n] / (double)this.factor;
    }

    float getFloat(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return (float)this.values[n] / (float)this.factor;
    }

    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[n] / this.factor;
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("DecimalColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return BigDecimal.valueOf(this.values[n], this.scale);
    }

    void resize(int n) {
        int n2;
        long[] lArray = new long[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = this.validMask[n2];
            lArray[n2] = this.values[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.validMask = blArray;
        this.values = lArray;
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) throws IOException {
        int n = eXAInputStream.readInt();
        int n2 = eXAInputStream.readInt();
        return new DecimalColumn(n, n2);
    }

    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            eXAOutputStream.writeLong(this.values[n]);
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.validMask[n] = true;
            this.values[n] = eXAInputStream.readLong();
        }
    }

    int getEXAType() {
        return 6;
    }

    boolean isSigned() throws SQLException {
        return true;
    }
}

