/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.Translator;

public class ClusterNode {
    private String host;
    private int port;
    private boolean isMarked = false;

    ClusterNode(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public boolean HasPort() {
        return this.port != 0;
    }

    public int GetPort() {
        return this.port;
    }

    public String GetHost() {
        return this.host;
    }

    public void SetPort(int n) throws ConnectionException {
        if (n < 0 || n > 65535) {
            throw new ConnectionException(Translator.Illegal_value_for_port_found_in_the_connection_string() + n);
        }
        this.port = n;
    }

    public void Mark() {
        this.isMarked = true;
    }

    public void UnMark() {
        this.isMarked = false;
    }

    public boolean IsMarked() {
        return this.isMarked;
    }

    public boolean isValid() {
        int n;
        byte[] byArray = this.host.getBytes();
        for (n = 0; n < this.host.length(); ++n) {
            if (byArray[n] == 46 || byArray[n] >= 48 && byArray[n] <= 57) continue;
            return true;
        }
        n = 0;
        int n2 = 0;
        block1: for (int i = 0; i < 4; ++i) {
            while (n < byArray.length) {
                if (byArray[n] == 46) {
                    ++n2;
                    ++n;
                    continue block1;
                }
                ++n;
            }
        }
        return n2 == 3;
    }
}

