/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public abstract class AbstractEXAStatement
extends ServerCommunication
implements Statement {
    protected Vector commands;
    protected int fetchSize;
    protected int fetchDirection;
    protected int maxFieldSize;
    protected int queryTimeout;
    protected int resultSetConcurrency;
    protected int resultSetType;
    protected int maxRows;
    private int activeProtocolVersion;
    SQLWarning warning;
    protected ExecutionStatus execStatus = null;
    private static int StatementID = 0;
    protected int MyStatementID = 0;
    protected EXAResult[] results;
    protected int current_result;
    private int metadataSQL = 0;

    private static synchronized int GetStatementID() {
        return StatementID++;
    }

    AbstractEXAStatement(EXAConnection eXAConnection) {
        super(eXAConnection.getDebug(), "EXAStatement", eXAConnection);
        this.log("EXAStatement() created, statement ID: " + this.MyStatementID);
        this.MyStatementID = AbstractEXAStatement.GetStatementID();
        this.commands = new Vector();
        this.fetchSize = eXAConnection.getDefaultFetchSize();
        this.maxFieldSize = 1000;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.resultSetConcurrency = 10;
        this.results = null;
        this.activeProtocolVersion = eXAConnection.getActiveProtocolVersion();
        try {
            this.metadataSQL = Integer.parseInt(this.connection.getParameter("metadataSQL"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.metadataSQL != 0) {
            this.metadataSQL = 1;
        }
    }

    AbstractEXAStatement(EXAConnection eXAConnection, int n, int n2) {
        this(eXAConnection);
        this.MyStatementID = AbstractEXAStatement.GetStatementID();
        this.resultSetConcurrency = n2;
        this.resultSetType = n;
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public ResultSet GetKeywords() throws SQLException {
        if (0 != this.metadataSQL) {
            return this.executeQuery("select KEYWORD from EXA_SQL_KEYWORDS /*Keywords from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)120, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public ResultSet GetCommands() throws SQLException {
        if (0 != this.metadataSQL) {
            return this.executeQuery("select \"COMMAND\",\"IS_PLSQL\" from \"$ODBCJDBC\".\"SQL_COMMANDS\" order by \"COMMAND\" /*Commands from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)121, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public ResultSet GetDbMetadata(String[] stringArray, String string) throws SQLException {
        if (0 != this.metadataSQL) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (stringArray != null) {
                string2 = " \"NAME\" in (";
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + "'" + stringArray[i] + "'";
                    if (i >= stringArray.length - 1) continue;
                    string2 = string2 + ", ";
                }
                string2 = string2 + ") ";
            }
            if (string != null) {
                string3 = " \"STATIC\"=" + string;
            }
            if (string2.length() > 0 || string3.length() > 0) {
                string4 = " WHERE ";
            }
            if (string2.length() > 0 && string3.length() > 0) {
                string5 = " AND ";
            }
            String string6 = "select \"NAME\",\"VALUE\",\"STATIC\" from \"$ODBCJDBC\".\"DB_METADATA\" " + string4 + string2 + string5 + string3 + " order by 1";
            return this.executeQuery(string6 + " /*DbMetadata from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        int n = -1;
        if (null != string && string.equals("true")) {
            n = 1;
        }
        if (null != string && string.equals("false")) {
            n = 0;
        }
        try {
            if (null == stringArray) {
                eXAOutputStream.writeInt(-1);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    eXAOutputStream.writeInt(stringArray[i].getBytes(this.connection.getEncoding()).length);
                    eXAOutputStream.write(stringArray[i].getBytes(this.connection.getEncoding()));
                }
                eXAOutputStream.writeInt(-1);
            }
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(n);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)122, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public ResultSet GetAllObjects() throws SQLException {
        if (0 != this.metadataSQL) {
            return this.executeQuery("select \"OBJECT_NAME\", \"OBJECT_TYPE\", \"OBJECT_ID\", \"ROOT_ID\", \"LAST_COMMIT\", \"CREATED\", \"OWNER\", \"OBJECT_COMMENT\", \"OBJECT_IS_VIRTUAL\"  from \"SYS\".\"EXA_ALL_OBJECTS\" where \"ROOT_ID\" IS NULL order by \"OBJECT_ID\" /*AllObjects from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)123, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public ResultSet GetAllUsers() throws SQLException {
        if (0 != this.metadataSQL) {
            return this.executeQuery("select USER_NAME, 0 as USER_ID, CREATED, USER_COMMENT from SYS.EXA_ALL_USERS /*AllUsers from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)124, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public ResultSet GetDbaRoles() throws SQLException {
        if (0 != this.metadataSQL) {
            return this.executeQuery("select ROLE_NAME as ROLE, -1 as ROLE_ID, ROLE_COMMENT, CREATED from SYS.EXA_DBA_ROLES /*DbaRoles from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)125, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public ResultSet GetDbaConnections() throws SQLException {
        if (0 != this.metadataSQL) {
            return this.executeQuery("select CONNECTION_NAME, CONNECTION_STRING, USER_NAME, CREATED,CONNECTION_COMMENT from SYS.EXA_DBA_CONNECTIONS /*DbaConnections from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)126, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public int GetEXAJDBCStatementID() {
        return this.MyStatementID;
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.log("addBatch(" + string + ")");
        this.commands.add(string);
    }

    public void cancel() throws SQLException {
        this.log("cancel");
        if (null != this.execStatus) {
            this.execStatus.cancel();
        } else {
            this.log("nothing to cancel");
        }
    }

    public synchronized void clearBatch() throws SQLException {
        this.log("clearBatch");
        this.commands.clear();
    }

    public void clearWarnings() {
        this.log("clearWarnings");
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            this.log("Exception caught automaticaly closing statement: " + exception.toString() + "\nYour application should call close() for statements when they are not needed anymore.");
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            this.log(throwable.toString());
        }
    }

    public void close() throws SQLException {
        this.log("EXAStatement.close() for statement ID: " + this.MyStatementID);
        try {
            if (this.results != null) {
                this.closeResultSets(this.results);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.log("execute(" + string + ")", 3);
        this.connection.setSchemaMayHaveChanged();
        this.execStatus = new ExecutionStatus();
        try {
            this.results = this.connection.communication_resultset(string.getBytes(this.connection.getEncoding()), (byte)12, this.execStatus);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.current_result = 0;
        if (this.results != null && this.results.length > 0) {
            if (this.results[0] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[0]).getSQLExceptionIntern(this.connection);
            }
            return this.results[0] instanceof EXAResultSet;
        }
        return false;
    }

    public synchronized int[] executeBatch() throws SQLException {
        this.log("executeBatch()", 3);
        this.connection.setSchemaMayHaveChanged();
        this.execStatus = new ExecutionStatus();
        this.results = this.connection.communication_vector(this.commands, (byte)17, this.execStatus);
        if (this.results.length > 0) {
            int[] nArray = new int[this.results.length];
            for (int i = 0; i < this.results.length; ++i) {
                nArray[i] = this.results[i] instanceof EXARowCount ? ((EXARowCount)this.results[i]).getRowCount() : (this.results[i] instanceof EXASQLException ? -3 : -2);
            }
            return nArray;
        }
        return null;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.log("executeQuery(" + string + ")", 3);
        this.connection.setSchemaMayHaveChanged();
        if (this.execute(string)) {
            if (this.results.length == 0) {
                throw new SQLException(Translator.Query_did_not_return_a_result());
            }
            if (this.results.length > 1) {
                throw new SQLException(Translator.Query_returned_more_than_one_result());
            }
            ResultSet resultSet = this.getResultSet();
            resultSet.setFetchSize(this.getFetchSize());
            return resultSet;
        }
        throw new SQLException(Translator.Query_returned_update_count());
    }

    public int executeUpdate(String string) throws SQLException {
        this.log("executeUpdate(" + string + ")");
        this.connection.setSchemaMayHaveChanged();
        if (this.execute(string)) {
            throw new SQLException(Translator.Statement_returned_resultset());
        }
        int n = this.getUpdateCount();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public int getFetchSize() {
        if (this.debug != null) {
            this.log("EXAStatement:getFetchSize(): " + this.fetchSize);
        }
        if (this.fetchSize <= 0) {
            if (this.debug != null) {
                this.log("Ignoring invalid fetch size: " + this.fetchSize + ". Fetch size will be set to connection default: " + this.connection.getDefaultFetchSize());
            }
            this.fetchSize = this.connection.getDefaultFetchSize();
        }
        return this.fetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.debug != null) {
            this.debug.log("getGeneratedKys()");
        }
        throw new NotImplemented(this.debug, "getGeneratedKeys");
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getMoreResults()");
            if (this.results == null || this.current_result >= this.results.length) {
                return false;
            }
            if (this.current_result > 0 && this.results[this.current_result] instanceof EXAResultSet) {
                EXAResultSet eXAResultSet = (EXAResultSet)this.results[this.current_result];
                eXAResultSet.close();
            }
            ++this.current_result;
            if (this.current_result >= this.results.length) {
                return false;
            }
            if (this.results[this.current_result] instanceof EXASQLException) {
                return false;
            }
            return this.results[this.current_result] instanceof EXAResultSet;
        }
    }

    public int getQueryTimeout() {
        if (this.debug != null) {
            this.log("EXAStatement::getQueryTimeout(): " + this.queryTimeout);
        }
        return this.queryTimeout;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        if (this.debug != null) {
            this.log("EXAStatement::getResultSet()");
        }
        if (this.results == null || this.current_result >= this.results.length) {
            throw new NoResultException();
        }
        if (this.results[this.current_result] instanceof EXAResultSet) {
            ((EXAResultSet)this.results[this.current_result]).setMaxRows(this.maxRows);
            EXAResultSet eXAResultSet = (EXAResultSet)this.results[this.current_result];
            eXAResultSet.setStatement((EXAStatement)this);
            eXAResultSet.setFetchSize(this.getFetchSize());
            return eXAResultSet;
        }
        if (this.results[this.current_result] instanceof EXAHandle && this.current_result < this.results.length - 1 && this.results[this.current_result + 1] instanceof EXASQLException) {
            ++this.current_result;
        }
        if (this.results[this.current_result] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
        }
        return null;
    }

    public int getResultSetConcurrency() {
        if (this.debug != null) {
            this.log("EXAStatement:getResultSetConcurrency(): " + this.resultSetConcurrency);
        }
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        if (this.debug != null) {
            this.debug.log("getGetResultSetHoldability()");
        }
        throw new NotImplemented(this.debug, "getGetResultSetHoldability");
    }

    public int getResultSetType() throws SQLException {
        throw new NotImplemented(this.debug, "getResultSetType()");
    }

    public synchronized int getUpdateCount() throws SQLException {
        int n = -1;
        if (this.results != null && this.current_result < this.results.length) {
            if (this.results[this.current_result] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
            }
            if (this.results[this.current_result] instanceof EXARowCount) {
                n = ((EXARowCount)this.results[this.current_result]).getRowCount();
            }
        }
        if (this.debug != null) {
            this.log("EXAStatement:getUpdateCount(): " + n);
        }
        return n;
    }

    public synchronized long getLongUpdateCount() throws SQLException {
        long l = -1L;
        if (this.results != null && this.current_result < this.results.length) {
            if (this.results[this.current_result] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
            }
            if (this.results[this.current_result] instanceof EXARowCount) {
                l = ((EXARowCount)this.results[this.current_result]).getLongRowCount();
            }
        }
        this.log("getUpdateCountLong()=" + l);
        return l;
    }

    public SQLWarning getWarnings() {
        return this.warning;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.debug != null) {
            this.log("EXAStatement:setCursorName(): " + string);
        }
        throw new NotImplemented(this.debug, "setCursorName(String name)");
    }

    public void setEscapeProcessing(boolean bl) {
        if (this.debug != null) {
            this.log("EXAStatement:setEscapeProcessing(): " + bl);
        }
    }

    public void setFetchDirection(int n) {
        if (this.debug != null) {
            this.log("EXAStatement:setFetchDirection(): " + n);
        }
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) {
        if (this.debug != null) {
            this.log("EXAStatement::setFetchSize(): " + n);
        }
        if (n <= 0) {
            if (this.debug != null) {
                this.log("Ignoring invalid fetch size: " + n + ". Fetch size remains: " + this.fetchSize);
            }
            return;
        }
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) {
        if (this.debug != null) {
            this.log("EXAStatement:setMaxFieldSize(): " + n);
        }
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) {
        if (this.debug != null) {
            this.log("EXAStatement:setMaxRows(): " + n);
        }
        this.maxRows = n < 0 ? 0 : n;
    }

    public void setQueryTimeout(int n) {
        if (this.debug != null) {
            this.log("EXAStatement:setQueryTimeout(): " + n);
        }
        this.queryTimeout = n;
    }

    public void closeResultSets(EXAResult[] eXAResultArray) throws SQLException {
        if (null == eXAResultArray) {
            return;
        }
        this.execStatus = new ExecutionStatus();
        int n = 0;
        for (int i = 0; i < eXAResultArray.length; ++i) {
            if (!(eXAResultArray[i] instanceof EXAResultSet) || ((EXAResultSet)eXAResultArray[i]).getHandle() < 0) continue;
            ++n;
        }
        if (n > 0) {
            byte[] byArray = new byte[4 * n];
            int n2 = 0;
            int n3 = 0;
            do {
                if (!(eXAResultArray[n3] instanceof EXAResultSet) || ((EXAResultSet)eXAResultArray[n3]).getHandle() < 0) continue;
                byArray[4 * n2 + 0] = (byte)((EXAResultSet)eXAResultArray[n3]).getHandle();
                byArray[4 * n2 + 1] = (byte)(((EXAResultSet)eXAResultArray[n3]).getHandle() >> 8);
                byArray[4 * n2 + 2] = (byte)(((EXAResultSet)eXAResultArray[n3]).getHandle() >> 16);
                byArray[4 * n2 + 3] = (byte)(((EXAResultSet)eXAResultArray[n3]).getHandle() >> 24);
                this.log("Closing result with handle: " + ((EXAResultSet)eXAResultArray[n3]).getHandle());
                ((EXAResultSet)eXAResultArray[n2]).setHandle(-1);
                ++n2;
            } while (n2 < n && ++n3 < eXAResultArray.length);
            if (n2 != n) {
                throw new SQLException("something is wrong");
            }
            this.connection.communication(byArray, (byte)13, this.execStatus);
        }
    }

    public String getSQLTypeName(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN TYPE";
    }

    public int getNumberOfResults() {
        if (this.results != null) {
            return this.results.length;
        }
        return 0;
    }
}

