/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ChaCha20_encoder;
import com.exasol.jdbc.ClusterEntryUtil;
import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectFailed;
import com.exasol.jdbc.ConnectRefused;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DialectFactory;
import com.exasol.jdbc.DialectGeneric;
import com.exasol.jdbc.DialectHibernate;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADatabaseMetaData;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStillExecuting;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.EncryptedOutputStream;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.Header;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.LoaderException;
import com.exasol.jdbc.LoginRefused;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.Protocol;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.RC4_encoder;
import com.exasol.jdbc.RSA_encoder;
import com.exasol.jdbc.RecoverableOperation;
import com.exasol.jdbc.RollbackException;
import com.exasol.jdbc.SchemaEvent;
import com.exasol.jdbc.SchemaListener;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.StreamEncoder;
import com.exasol.jdbc.TimeoutException;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.WrongHostException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public abstract class AbstractEXAConnection
extends ServerCommunication
implements Connection,
Protocol {
    public static final String AUTOCOMMIT = "autocommit";
    public static final String FETCHSIZE = "fetchsize";
    public static final String INITIAL_SCHEMA = "schema";
    public static final String CLIENT_NAME = "clientname";
    public static final String CLIENT_VERSION = "clientversion";
    public static final String LOGINTIMEOUT = "logintimeout";
    public static final String CONNECTTIMEOUT = "connecttimeout";
    public static final String ENCRYPTION = "encryption";
    public static final String QUERYTIMEOUT = "querytimeout";
    public static final String SUPERCONNECTION = "superconnection";
    public static final String FEEDBACKINTERVAL = "feedbackinterval";
    public static final String SNAPSHOTTRANSACTIONS = "snapshottransactions";
    public static final String DEFAULT_DATEFORMAT = "YYYY-MM-DD";
    public static final String DEFAULT_TIMESTAMPFORMAT = "YYYY-MM-DD HH:MI:SS.FF3";
    public static final String DEFAULT_NUMERIC_CHARACTERS = ".,";
    public static final String TESTCONNECTIONSTRINGONLY = "TestConnectionStringOnly";
    public static final String HIBERNATE = "hibernate";
    private static final String SYSSCHEMA_NEW = "\"$ODBCJDBC\"";
    protected static final String DEBUG = "debug";
    private static final boolean AUTOCOMMIT_DEFAULT = true;
    private static final boolean SUPERCONNECTION_DEFAULT = false;
    private static final String CLIENT_NAME_DEFAULT = "Generic JDBC client";
    private int lastSerialNumber = 0;
    private static final int MAX_ATTRIBS = 1000;
    private int connectTimeout = 2000;
    private int feedbackInterval = -1;
    private boolean snapshotTransactions = false;
    private String encoding = "utf-8";
    private int executionMode = 0;
    private DatabaseMetaData metadata;
    protected String exaServer;
    protected int exaPort;
    protected Vector clusterNodes;
    private String user;
    private String password;
    private Header lastHeader;
    private String currentCatalog = null;
    private int transactionIsolation;
    protected Socket csocket;
    protected InputStream from_database;
    protected EXAOutputStream to_database;
    private boolean vmuMode = false;
    private Properties connectionParam;
    boolean connected = false;
    boolean wasDisconnected = false;
    private int responseTimeout = 0;
    private int queryTimeout = 0;
    private boolean encryptionEnabled = true;
    private StreamEncoder encryptor = null;
    private boolean encryptionRequired = false;
    public static int defaultDriverProtocollVersion = 14;
    private long maxMessageSize = 0x4000000L;
    private String connectionStatus = null;
    protected static boolean schemaChanged = false;
    private int activeProtocolVersion = defaultDriverProtocollVersion;
    private String dateFormat;
    private String timestampFormat;
    private String dateLanguage;
    private String currentSchema;
    private String databaseName;
    private String databaseProductName;
    private String databaseProductVersion;
    private String numericCharacters;
    private long sessionID = -1L;
    private byte[] publicKey;
    private byte[] randomPhrase;
    private byte[] encodedPwd;
    static final int _defaultFetchSize = 2000;
    private int defaultFetchSize = 2000;
    private Map typeMap = null;
    private SQLWarning warnings;
    private HashMap attributes;
    private String sysSchema;
    private int reconnectCount = 0;
    private static final int maxReconnects = 1;
    static final int exa_so_timeout = 10000;
    private List schemaListeners = null;
    public boolean hibernate = false;
    DialectFactory dialectFactory = new DialectGeneric();

    protected long GetMaxMessageSize() {
        return this.maxMessageSize;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public synchronized boolean getSchemaMayHaveChanged() {
        return schemaChanged;
    }

    public synchronized void setSchemaMayHaveChanged() {
        schemaChanged = true;
    }

    public synchronized void metadataAcquired() {
        schemaChanged = false;
    }

    public Vector getNodes() {
        return this.clusterNodes;
    }

    public boolean IsEncrypted() {
        return this.encryptionEnabled;
    }

    public boolean isValid(int n) throws SQLException {
        block10: {
            int n2 = this.responseTimeout;
            if (0 != n) {
                this.responseTimeout = n;
            }
            try {
                if (this.activeProtocolVersion < 14) {
                    Statement statement = this.createStatement();
                    statement.executeUpdate("/*EXAConnection.isValid(" + n + ")*/");
                    statement.close();
                    break block10;
                }
                EXAResult[] eXAResultArray = this.communication_resultset(new byte[0], (byte)70, new ExecutionStatus());
                if (eXAResultArray != null && eXAResultArray.length > 0) {
                    if (eXAResultArray[0] instanceof EXASQLException) {
                        throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern((EXAConnection)this);
                    }
                    break block10;
                }
                throw new IOException("No vaild response from server, connection is not open");
            }
            catch (Exception exception) {
                this.connected = false;
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw new SQLException(exception.getMessage());
            }
            finally {
                this.responseTimeout = n2;
            }
        }
        return this.connected;
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties) throws SQLException {
        this(string, n, string2, string3, debugLog, properties, null);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3) throws SQLException {
        this(string, n, string2, string3, null, new Properties(), null);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog) throws SQLException {
        this(string, n, string2, string3, debugLog, new Properties(), null);
    }

    public AbstractEXAConnection(Vector vector, String string, String string2, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        super(debugLog, "EXAConnection", null);
        this.Connect(vector, string, string2, debugLog, properties, hashMap);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        super(debugLog, "EXAConnection", null);
        Vector<ClusterNode> vector = new Vector<ClusterNode>();
        vector.add(new ClusterNode(string, n));
        this.Connect(vector, string2, string3, debugLog, properties, hashMap);
    }

    public void clearWarnings() {
        this.log("clearWarnings");
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            this.log("EXAConnection.close()", 0);
            if (this.wasDisconnected) {
                this.log(" Info: this connection was allready disconnected, exiting close()");
                return;
            }
            boolean bl = trace_exception;
            trace_exception = false;
            try {
                this.communication(null, 0, (byte)32, 30, new ExecutionStatus());
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            try {
                this.csocket.close();
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            trace_exception = bl;
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            this.connected = false;
            this.wasDisconnected = true;
            this.reconnectCount = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAbort(boolean bl) throws SQLException {
        try {
            this.log("closing socket ...", 0);
            if (this.wasDisconnected) {
                this.log(" Info: this connection was allready disconnected, exiting closeAbort()");
                return;
            }
            boolean bl2 = trace_exception;
            trace_exception = false;
            try {
                this.csocket.close();
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            trace_exception = bl2;
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            if (!bl) {
                this.connected = false;
            }
        }
    }

    public void commit() throws SQLException {
        this.log("commit", 1);
        this.log("createStatement to execute commit");
        Statement statement = this.createStatement();
        statement.executeUpdate("/*EXAConnection.commit()*/ commit;");
        statement.close();
    }

    public Statement createStatement() throws SQLException {
        this.log("createStatement()", 1);
        return this.dialectFactory.createStatement((EXAConnection)this);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.log("createStatement()", 1);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.log("createStatement()", 1);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, n, n2);
    }

    public boolean getAutoCommit() {
        boolean bl = this.getBooleanParameter(AUTOCOMMIT, true);
        this.log("EXAConnection.getAutoCommit(): " + bl);
        return bl;
    }

    public boolean isSuperConnection() {
        boolean bl = this.getBooleanParameter(SUPERCONNECTION, false);
        this.log("EXAConnection.SUPERCONNECTION_DEFAULT(): " + bl);
        return bl;
    }

    public String getCatalog() throws SQLException {
        this.log("getCatalog(): " + this.currentCatalog, 1);
        return this.currentCatalog;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.log("getMetaData() - connection meta data");
        if (this.metadata == null) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
        }
        return this.metadata;
    }

    public DatabaseMetaData recreateMetaData() throws SQLException {
        this.metadata = this.IsConnected() ? new EXADatabaseMetaData((EXAConnection)this, this.debug) : null;
        return this.metadata;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public Map getTypeMap() throws SQLException {
        this.log("getTypeMap()", 0);
        return this.typeMap;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public boolean isClosed() {
        this.log("isClosed:" + (this.csocket == null), 3);
        return this.csocket == null;
    }

    public boolean isReadOnly() throws SQLException {
        this.log("isReadOnly()", 0);
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.log("prepareCall(" + string + ")", 0);
        throw new NotImplemented(this.debug, "prepareCall(String)");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.log("prepareCall(" + string + "," + n + "," + n2 + ")", 0);
        throw new NotImplemented(this.debug, "prepareCall(String,int,int)");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.log("prepareCall(" + string + "," + n + "," + n2 + "," + n3 + ")", 0);
        throw new NotImplemented(this.debug, "prepareCall(String,int,int,int)");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.log("prepareStatement(" + string + ")", 0);
        return this.dialectFactory.createPreparedStatement(string, (EXAConnection)this);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + "," + n2 + ")", 0);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.log("prepareStatement(" + string + "," + nArray + ")", 0);
        throw new NotImplemented(this.debug, "prepareStatement(sql,int[]");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.log("prepareStatement(" + string + "," + stringArray + ")", 0);
        throw new NotImplemented(this.debug, "prepareStatement(String,String[])");
    }

    public String getHostsList() {
        String string = "";
        for (int i = 0; i < this.clusterNodes.size(); ++i) {
            string = string + ((ClusterNode)this.clusterNodes.get(i)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(i)).GetPort();
            if (i >= this.clusterNodes.size() - 1) continue;
            string = string + ",";
        }
        return string;
    }

    private void Connect(Vector vector, String string, String string2, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        int n;
        this.log("Connect()");
        this.warnings = null;
        this.connection = (EXAConnection)this;
        this.clusterNodes = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            ClusterNode clusterNode = new ClusterNode(((ClusterNode)vector.get(n)).GetHost(), ((ClusterNode)vector.get(n)).GetPort());
            clusterNode.UnMark();
            this.clusterNodes.add(clusterNode);
        }
        n = this.clusterNodes.size();
        this.connectionParam = (Properties)properties.clone();
        if (this.getParameter(TESTCONNECTIONSTRINGONLY) != null && this.getParameter(TESTCONNECTIONSTRINGONLY).equals("1")) {
            return;
        }
        Random random = new Random(System.currentTimeMillis());
        SQLException sQLException = new ConnectRefused(Translator.Connection_refused());
        while (true) {
            int n2;
            try {
                n2 = random.nextInt(this.clusterNodes.size());
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
            if (((ClusterNode)this.clusterNodes.get(n2)).IsMarked()) continue;
            --n;
            ((ClusterNode)this.clusterNodes.get(n2)).Mark();
            this.exaServer = ((ClusterNode)this.clusterNodes.get(n2)).GetHost();
            this.exaPort = ((ClusterNode)this.clusterNodes.get(n2)).GetPort();
            this.log("new EXAConnection: " + this.exaServer + ":" + this.exaPort + " User: " + string);
            this.user = string;
            this.password = string2;
            this.connectionParam = (Properties)properties.clone();
            if (this.getParameter(TESTCONNECTIONSTRINGONLY) != null && this.getParameter(TESTCONNECTIONSTRINGONLY).equals("1")) {
                return;
            }
            this.currentSchema = this.getParameter(INITIAL_SCHEMA);
            this.transactionIsolation = 8;
            this.defaultFetchSize = this.getIntParameter(FETCHSIZE, 2000);
            if (this.defaultFetchSize <= 0) {
                this.log("EXAConnection::Connect(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size remains: " + 2000);
                this.defaultFetchSize = 2000;
            }
            this.connectTimeout = this.getIntParameter(CONNECTTIMEOUT, 2000);
            if (this.connectTimeout < 0 || this.connectTimeout >= 2147483) {
                this.connectTimeout = 0;
            }
            this.responseTimeout = this.getIntParameter(LOGINTIMEOUT, 0);
            this.responseTimeout = this.responseTimeout < 0 || this.responseTimeout >= 2147483 ? 0 : (this.responseTimeout *= 1000);
            this.encryptionEnabled = this.getBooleanParameter(ENCRYPTION, true);
            this.queryTimeout = this.getIntParameter(QUERYTIMEOUT, 0);
            this.hibernate = this.getBooleanParameter(HIBERNATE, false);
            if (this.hibernate) {
                this.dialectFactory = new DialectHibernate();
            }
            try {
                this.setupConnection(false, hashMap);
            }
            catch (ConnectRefused connectRefused) {
                sQLException = connectRefused;
                this.log("Connection refused to " + this.exaServer + ":" + this.exaPort + " - " + connectRefused.toString());
            }
            catch (ConnectFailed connectFailed) {
                sQLException = connectFailed;
                this.closeSocket();
                this.log("Connection failed to " + this.exaServer + ":" + this.exaPort + " - " + connectFailed.toString());
            }
            catch (SQLException sQLException2) {
                this.closeSocket();
                sQLException = sQLException2;
                this.log("Connection exception from " + this.exaServer + ":" + this.exaPort + " - " + sQLException2.toString());
                throw sQLException2;
            }
            if (this.IsConnected()) {
                try {
                    this.schemaListeners = (List)Class.forName("ArrayList").newInstance();
                }
                catch (Exception exception) {
                    this.schemaListeners = new Vector();
                }
            }
            if (0 >= n || this.IsConnected()) break;
        }
        if (0 == n && !this.IsConnected()) {
            this.closeSocket();
            throw sQLException;
        }
        this.wasDisconnected = false;
    }

    private boolean IsConnected() {
        return this.connected;
    }

    public void addSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.add(schemaListener);
        }
    }

    public void removeSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.remove(schemaListener);
        }
    }

    public void fireSchemaChanged(String string, String string2) {
        if (null == this.schemaListeners) {
            return;
        }
        if (this.schemaListeners.isEmpty()) {
            return;
        }
        SchemaEvent schemaEvent = new SchemaEvent((EXAConnection)this, string, string2);
        for (int i = 0; i < this.schemaListeners.size(); ++i) {
            ((SchemaListener)this.schemaListeners.get(i)).schemaChanged(schemaEvent);
        }
    }

    private void setupConnection(boolean bl, HashMap hashMap) throws SQLException {
        this.attributes = this.setDefaultAttributes(bl, hashMap);
        this.connected = false;
        do {
            try {
                this.activeProtocolVersion = defaultDriverProtocollVersion;
                this.connectAndLogin(bl, this.exaServer, this.exaPort);
                this.connected = true;
            }
            catch (ConnectionLost connectionLost) {
                this.closeSocket();
                throw connectionLost;
            }
            catch (IOException iOException) {
                if (trace_exception) {
                    iOException.printStackTrace();
                }
                this.log("EXAConnection.setupConnection(): " + iOException.toString(), 0);
                if (iOException instanceof UnknownHostException) {
                    this.closeSocket();
                    throw new ConnectFailed(Translator.Unknown_host_name() + iOException.getMessage());
                }
                this.closeSocket();
                throw new ConnectFailed(iOException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.connected = false;
                this.log("Connection exception from " + this.exaServer + ":" + this.exaPort + " - " + protocolException.getMessage());
                if (0 == protocolException.getMessage().compareTo(Translator.To_create_an_encrypted_connection_the_server_must_be_at_least_5_0())) {
                    throw protocolException;
                }
                throw new ProtocolException(Translator.Connection_refused());
            }
            catch (SQLException sQLException) {
                if (trace_exception) {
                    sQLException.printStackTrace();
                }
                this.log("EXAConnection.setupConnection(): " + sQLException.toString(), 0);
                if (this.csocket != null && (sQLException instanceof LoginRefused || sQLException instanceof ConnectRefused || sQLException instanceof ConnectionLost || sQLException instanceof TimeoutException)) {
                    this.closeSocket();
                    throw sQLException;
                }
                this.addWarning(sQLException);
                this.connected = true;
            }
            catch (WrongHostException wrongHostException) {
                if (ClusterEntryUtil.hostEquals(this.exaServer, wrongHostException.getServerNode())) continue;
                this.exaServer = wrongHostException.getServerNode();
                this.activeProtocolVersion = defaultDriverProtocollVersion;
            }
        } while (!this.connected);
        if (!bl) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
            if (this.getActiveProtocolVersion() < 14) {
                try {
                    if (this.currentSchema != null && this.currentSchema.length() > 0) {
                        this.setSchema(this.currentSchema);
                    }
                }
                catch (SQLException sQLException) {
                    this.log("Error in EXAConnection - failed to open default schema, aborting. " + sQLException.toString(), 0);
                    this.close();
                    throw sQLException;
                }
            }
        }
    }

    private void addWarning(SQLException sQLException) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(sQLException.getMessage() + "SessionID: " + this.getSessionID(), sQLException.getSQLState());
        } else {
            this.warnings.setNextWarning(new SQLWarning(sQLException.getMessage(), sQLException.getSQLState()));
        }
    }

    protected int getDefaultFetchSize() {
        if (this.defaultFetchSize <= 0) {
            if (this.debug != null) {
                this.log("EXAConnection::getDefaultFetchSize(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size will be set to connection default: " + 2000);
            }
            this.defaultFetchSize = 2000;
        }
        return this.defaultFetchSize;
    }

    protected String getParameter(String string) {
        Object object;
        String string2 = null;
        if (this.connectionParam != null && (object = this.connectionParam.get(string)) != null) {
            string2 = object.toString();
        }
        return string2;
    }

    private boolean getBooleanParameter(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        return !"0".equals(string2) && !"false".equalsIgnoreCase(string2);
    }

    private int getIntParameter(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + string + "\"");
            }
        }
        return n;
    }

    private long getLongParameter(String string, long l) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + string + "\"");
            }
        }
        return l;
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute, Object object) {
        ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(protocolAttribute.id);
        protocolAttribute2.value = object;
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute2);
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute, Object object, int n) {
        ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(protocolAttribute.id);
        protocolAttribute2.value = object;
        protocolAttribute2.binaryLength = n;
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute2);
    }

    private HashMap setDefaultAttributes(boolean bl, HashMap hashMap) throws SQLException {
        HashMap<Short, ProtocolAttribute> hashMap2 = new HashMap<Short, ProtocolAttribute>();
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_USERNAME, this.user);
        if (this.getActiveProtocolVersion() >= 14 && null != this.currentSchema && !bl) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CURRENT_SCHEMA, this.currentSchema);
        }
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_DRIVERNAME, EXADriver.getEXADriverName());
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_LANGUAGE, Locale.getDefault().getLanguage());
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_RELEASE_VERSION, EXADriver.getVersionInfo());
        String string = this.connectionParam.getProperty(CLIENT_NAME, CLIENT_NAME_DEFAULT);
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTNAME, string);
        string = this.connectionParam.getProperty(CLIENT_VERSION, "unknown");
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTVERSION, string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("os.name", "unknown os"));
        stringBuffer.append(" - ");
        stringBuffer.append(System.getProperty("os.version", "unknown version"));
        stringBuffer.append(" - ");
        stringBuffer.append(System.getProperty("os.arch", "unknown arch"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTOS, stringBuffer.toString());
        string = System.getProperty("user.name");
        if (string != null) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTOS_USERNAME, string);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(System.getProperty("java.vendor"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.version"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.vm.name"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.vm.info"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTRUNTIME, stringBuffer2.toString());
        if (bl) {
            if (-1L == this.sessionID) {
                throw new SQLException(Translator.Connection_was_lost_and_reconnect_could_not_restore_the_session());
            }
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_SESSIONID, new Long(this.sessionID));
        } else {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
            protocolAttribute.value = new Boolean(this.getAutoCommit());
            hashMap2.put(new Short(protocolAttribute.id), protocolAttribute);
        }
        if (this.isSuperConnection()) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_SUPER_CONNECTION, new Boolean(true));
        }
        this.feedbackInterval = this.getIntParameter(FEEDBACKINTERVAL, -1);
        if (-1 != this.feedbackInterval) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_FEEDBACK_INTERVAL, new Integer(this.feedbackInterval));
        }
        this.queryTimeout = this.getIntParameter(QUERYTIMEOUT, -1);
        if (-1 != this.queryTimeout) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_QUERY_TIMEOUT, new Integer(this.queryTimeout));
        } else {
            this.queryTimeout = 0;
        }
        if (hashMap != null) {
            hashMap2.putAll(hashMap);
        }
        return hashMap2;
    }

    protected abstract Socket createSocket(String var1, int var2, int var3) throws IOException;

    private void connectAndLogin(boolean bl, String string, int n) throws IOException, SQLException, WrongHostException {
        EXAResult[] eXAResultArray;
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        Object object42;
        boolean bl2 = true;
        this.log("connectAndLogin(" + bl + ", " + string + ", " + n + ")");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
        eXAOutputStream.writeInt(this.getActiveProtocolVersion());
        SimpleDate simpleDate = new SimpleDate();
        simpleDate.fromCalendar(Calendar.getInstance());
        eXAOutputStream.writeInt(simpleDate.toInt());
        for (Object object42 : this.attributes.values()) {
            eXAOutputStream.writeAttribute((ProtocolAttribute)object42);
        }
        eXAOutputStream.flush();
        if (null == this.password) {
            throw new IOException(Translator.Password_is_null_connect_aborted());
        }
        do {
            bl2 = true;
            try {
                this.csocket = this.createSocket(string, n, this.connectTimeout);
                this.csocket.setKeepAlive(true);
                this.csocket.setSoTimeout(10000);
            }
            catch (IOException iOException) {
                bl2 = false;
                throw iOException;
            }
        } while (!bl2);
        this.from_database = new EncryptedInputStream(new BufferedInputStream(this.csocket.getInputStream()));
        this.to_database = new EXAOutputStream(new EncryptedOutputStream(this.csocket.getOutputStream()), (EXAConnection)this);
        this.to_database.writeInt(0x1121201);
        this.to_database.writeInt(byteArrayOutputStream.size());
        this.to_database.write(byteArrayOutputStream.toByteArray());
        this.to_database.flush();
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, this.responseTimeout));
        object42 = this.lastHeader.getAttributes();
        this.updateSessionAttributes((Vector)object42);
        if (this.encryptionEnabled && this.getActiveProtocolVersion() < 12) {
            throw new ProtocolException(Translator.To_create_an_encrypted_connection_the_server_must_be_at_least_5_0());
        }
        if (this.encryptionRequired) {
            this.encryptionEnabled = true;
        }
        if (this.lastHeader.getSize() > 0) {
            object3 = new byte[this.lastHeader.getSize()];
            this.from_database.read((byte[])object3);
            objectArray = this.processMessageBody((byte[])object3);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof EXASQLException)) continue;
                    throw ExceptionFactory.createSQLException((EXASQLException)objectArray[i], (EXAConnection)this);
                }
            }
        }
        object3 = new RSA_encoder();
        if (null == this.publicKey || null == this.randomPhrase) {
            throw new WrongHostException(this.getClusterNodes()[0]);
        }
        ((RSA_encoder)object3).SetPublicKey(this.publicKey);
        objectArray = this.password.getBytes(this.encoding);
        this.encodedPwd = ((RSA_encoder)object3).EncodePwd((byte[])objectArray, this.randomPhrase);
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_ENCODED_PASSWORD.id);
        protocolAttribute.value = this.encodedPwd;
        protocolAttribute.binaryLength = this.encodedPwd.length;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.getActiveProtocolVersion() >= 12 && this.encryptionEnabled) {
            object2 = null;
            object = null;
            if (this.getActiveProtocolVersion() >= 14) {
                this.encryptor = new ChaCha20_encoder();
                object2 = this.encryptor.getRandomKey("xewd9j439cnr4urdu4ru3".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
                object = this.encryptor.getRandomKey("yrke9ek4yy9kd44dk88".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else {
                this.encryptor = new RC4_encoder();
                object2 = this.encryptor.getRandomKey("kmewd9j43239cnre3e324dkurdu4ru3".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
                object = this.encryptor.getRandomKey("ke32rke9ek4yy9kdxefwfef234d44dk88".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
            }
            this.encryptor.SetKeys((byte[])object2, (byte[])object);
            byArray = ((RSA_encoder)object3).EncodePwd((byte[])object2, this.randomPhrase);
            byArray2 = ((RSA_encoder)object3).EncodePwd((byte[])object, this.randomPhrase);
        }
        this.snapshotTransactions = this.getBooleanParameter(SNAPSHOTTRANSACTIONS, false);
        object2 = null;
        if (this.snapshotTransactions && this.getActiveProtocolVersion() >= 14) {
            object2 = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            ((ProtocolAttribute)object2).value = new Boolean(this.snapshotTransactions);
            ((ProtocolAttribute)object2).binaryLength = 1;
        }
        if (this.getActiveProtocolVersion() >= 12 && this.encryptionEnabled) {
            object = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_SEND_KEY.id);
            ((ProtocolAttribute)object).value = byArray;
            ((ProtocolAttribute)object).binaryLength = byArray.length;
            eXAResultArray = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_RECEIVE_KEY.id);
            eXAResultArray.value = byArray2;
            eXAResultArray.binaryLength = byArray2.length;
            ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_KEYS_LEN.id);
            if (this.encryptor instanceof ChaCha20_encoder) {
                protocolAttribute2.value = new Integer(ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else if (this.encryptor instanceof RC4_encoder) {
                protocolAttribute2.value = new Integer(RC4_encoder.ENCRYPTION_KEY_LEN);
            } else {
                throw new IOException("Unknown encryption class");
            }
            Integer cfr_ignored_0 = (Integer)protocolAttribute2.value;
            protocolAttribute2.binaryLength = 32 / 8;
            this.to_database.writeInt(6 + protocolAttribute.binaryLength + 6 + ((ProtocolAttribute)object).binaryLength + 6 + eXAResultArray.binaryLength + 2 + protocolAttribute2.binaryLength + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(4 + (null != object2 ? 1 : 0));
            this.to_database.writeInt(6 + protocolAttribute.binaryLength + 6 + ((ProtocolAttribute)object).binaryLength + 6 + eXAResultArray.binaryLength + 2 + protocolAttribute2.binaryLength + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != object2) {
                this.to_database.writeAttribute((ProtocolAttribute)object2);
            }
            this.to_database.writeAttribute(protocolAttribute);
            this.to_database.writeAttribute((ProtocolAttribute)object);
            this.to_database.writeAttribute((ProtocolAttribute)eXAResultArray);
            this.to_database.writeAttribute(protocolAttribute2);
        } else {
            this.to_database.writeInt(6 + protocolAttribute.binaryLength + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(1 + (null != object2 ? 1 : 0));
            this.to_database.writeInt(6 + protocolAttribute.binaryLength + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != object2) {
                this.to_database.writeAttribute((ProtocolAttribute)object2);
            }
            this.to_database.writeAttribute(protocolAttribute);
        }
        this.to_database.flush();
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, 0));
        if (!bl) {
            this.dateFormat = DEFAULT_DATEFORMAT;
            this.timestampFormat = DEFAULT_TIMESTAMPFORMAT;
            this.numericCharacters = DEFAULT_NUMERIC_CHARACTERS;
        }
        object42 = this.lastHeader.getAttributes();
        this.updateSessionAttributes((Vector)object42);
        this.sysSchema = SYSSCHEMA_NEW;
        try {
            if (this.lastHeader.getSize() > 0) {
                object = new byte[this.lastHeader.getSize()];
                this.from_database.read((byte[])object);
                eXAResultArray = this.processMessageBody((byte[])object);
                if (eXAResultArray != null) {
                    for (int i = 0; i < eXAResultArray.length; ++i) {
                        if (!(eXAResultArray[i] instanceof EXASQLException)) continue;
                        throw ExceptionFactory.createSQLException((EXASQLException)eXAResultArray[i], (EXAConnection)this);
                    }
                }
            }
        }
        catch (RollbackException rollbackException) {
            if (this.getActiveProtocolVersion() >= 12) {
                if (this.encryptionEnabled) {
                    this.to_database.SetEncryptor(this.encryptor);
                    ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
                }
                this.getAttributes();
                this.updateSessionAttributes((Vector)object42);
            }
            throw rollbackException;
        }
        if (this.getActiveProtocolVersion() >= 12) {
            if (this.encryptionEnabled) {
                this.to_database.SetEncryptor(this.encryptor);
                ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
            }
            this.getAttributes();
            this.updateSessionAttributes((Vector)object42);
            if (this.snapshotTransactions && this.getActiveProtocolVersion() < 14) {
                this.SetSnapshotTransactions(this.snapshotTransactions);
            }
        }
    }

    private String toHexStr(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public void setSchema(String string) throws SQLException {
        this.log("EXAConnection.setSchema(" + string + ") protocolVersion=" + this.getActiveProtocolVersion());
        if (string == null) {
            throw new SQLException("Schema name cannot be null");
        }
        if (this.getActiveProtocolVersion() < 14) {
            String string2 = "open schema " + string;
            EXAResult[] eXAResultArray = null;
            ExecutionStatus executionStatus = new ExecutionStatus();
            try {
                eXAResultArray = this.connection.communication_resultset(string2.getBytes(this.connection.getEncoding()), (byte)12, executionStatus);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            if (eXAResultArray != null && eXAResultArray.length > 0 && eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
        } else {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CURRENT_SCHEMA.id);
            protocolAttribute.value = string;
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            try {
                this.setAttributes(protocolAttributeArray);
            }
            catch (IOException iOException) {
                this.log("EXAConnection.setSchema(): caught IOException: " + iOException);
                throw new ConnectionLost(iOException.toString(), this.getSessionID());
            }
            catch (SQLException sQLException) {
                this.log("EXAConnection.setSchema(): caught SQLException: " + sQLException);
                throw sQLException;
            }
        }
        this.getSchema();
    }

    public String getSchema() throws SQLException {
        this.log("EXAConnection.getSchema()");
        try {
            this.getAttributes();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage(), "HY000");
        }
        this.log("EXAConnection.getSchema() returns " + this.getCurrentSchema());
        return this.getCurrentSchema();
    }

    protected int getNextSerialNumber() {
        return this.lastSerialNumber++;
    }

    final synchronized byte[] communication(byte[] byArray, byte by, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        byte[] byArray2 = this.communication(byArray, byArray == null ? -1 : byArray.length, by, 0, executionStatus);
        if (executionStatus.cancelInitiated()) {
            byArray2 = this.communication(null, 0, (byte)37, 0, executionStatus);
        }
        return byArray2;
    }

    final synchronized InMessage _communication(OutMessage outMessage) throws IOException, SQLException {
        outMessage.write_to_and_no_clean(this.to_database, (EXAConnection)this);
        return new InMessage(this.debug, this.from_database, (EXAConnection)this);
    }

    final InMessage communication(OutMessage outMessage) throws IOException, SQLException {
        this.tmpOutMessage = outMessage;
        this.tmpOutMessage.flush();
        this.handle(new RecoverableOperation(){

            public void op() throws IOException, SQLException {
                AbstractEXAConnection.this.tmpInMessage = AbstractEXAConnection.this._communication(AbstractEXAConnection.this.tmpOutMessage);
            }
        });
        return this.tmpInMessage;
    }

    final EXAResult[] communication_resultset(byte[] byArray, byte by, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        try {
            byte[] byArray2 = this.communication(byArray, byArray != null ? byArray.length : 0, by, 0, executionStatus);
            if (executionStatus.cancelInitiated()) {
                byArray2 = this.communication(null, 0, (byte)37, 0, executionStatus);
            }
            return this.readResults(byArray2, this.lastHeader.getNumberOfResults());
        }
        catch (IOException iOException) {
            if (trace_exception) {
                iOException.printStackTrace();
            }
            this.log(iOException);
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
    }

    private EXAResult[] processMessageBody(byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            return null;
        }
        EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
        int n = this.lastHeader.getNumberOfResults();
        EXAResult[] eXAResultArray = new EXAResult[n];
        block5: for (int i = 0; i < n; ++i) {
            byte by = eXAInputStream.readByte();
            switch (by) {
                case 0: {
                    eXAResultArray[i] = new EXARowCount(eXAInputStream, this.debug);
                    continue block5;
                }
                case 1: {
                    eXAResultArray[i] = this.dialectFactory.createResultSet(eXAInputStream, (EXAConnection)this, this.debug);
                    continue block5;
                }
                case -1: {
                    eXAResultArray[i] = new EXASQLException(eXAInputStream, this.debug);
                    continue block5;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return eXAResultArray;
    }

    final EXAResult[] communication_vector(Vector vector, byte by, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        EXAResult[] eXAResultArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
            eXAOutputStream.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                eXAOutputStream.writeString((String)vector.elementAt(i));
            }
            eXAOutputStream.flush();
            eXAResultArray = vector.size() > 0 ? this.communication_resultset(byteArrayOutputStream.toByteArray(), by, executionStatus) : this.communication_resultset(null, by, executionStatus);
        }
        catch (IOException iOException) {
            if (trace_exception) {
                iOException.printStackTrace();
            }
            this.log(iOException);
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
        return eXAResultArray;
    }

    private EXAResult readSingleResult(EXAInputStream eXAInputStream) throws IOException, SQLException {
        EXAResult eXAResult = null;
        byte by = eXAInputStream.readByte();
        switch (by) {
            case 0: {
                eXAResult = new EXARowCount(eXAInputStream, this.debug);
                break;
            }
            case 1: {
                eXAResult = this.dialectFactory.createResultSet(eXAInputStream, (EXAConnection)this, this.debug);
                if (-4 != ((EXAResultSet)eXAResult).getHandle()) break;
                eXAResult = new EXASQLException(new String("HY000"), new String(Translator.Query_did_not_return_a_result_set()), this.debug);
                break;
            }
            case -1: {
                eXAResult = new EXASQLException(eXAInputStream, this.debug);
                break;
            }
            case 2: {
                eXAResult = new EXAHandle(eXAInputStream, this.debug);
                break;
            }
            case 5: {
                eXAResult = new EXAStillExecuting(eXAInputStream, this.debug);
                break;
            }
            default: {
                throw new ProtocolException(Translator.Server_returned_unknow_type_of_result() + " (Type: " + by + ", SessionID: " + this.getSessionID() + ")");
            }
        }
        return eXAResult;
    }

    private EXAResult[] readResults(byte[] byArray, int n) throws IOException, SQLException, ProtocolException {
        if (byArray == null) {
            return null;
        }
        return this.readResults(new EXAInputStream(byArray, (EXAConnection)this), n);
    }

    private EXAResult[] readResults(EXAInputStream eXAInputStream, int n) throws IOException, SQLException, ProtocolException {
        EXAResult[] eXAResultArray = null;
        int n2 = n;
        this.log(n2 + " results in message");
        if (n2 > 0) {
            eXAResultArray = new EXAResult[n2];
            for (int i = 0; i < n2; ++i) {
                eXAResultArray[i] = this.readSingleResult(eXAInputStream);
            }
        }
        return eXAResultArray;
    }

    private void checkResults(InMessage inMessage) throws ProtocolException, IOException, SQLException {
        EXAResult[] eXAResultArray = this.readResults(inMessage.getStream(), inMessage.getHeader().getNumberOfResults());
        if (eXAResultArray != null) {
            for (int i = 0; i < eXAResultArray.length; ++i) {
                if (!(eXAResultArray[i] instanceof EXASQLException)) continue;
                throw ((EXASQLException)eXAResultArray[i]).getSQLExceptionIntern(this.connection);
            }
        }
    }

    synchronized byte[] communication(byte[] byArray, int n, byte by, int n2, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        try {
            CommOp commOp = new CommOp();
            commOp.execStatus = executionStatus;
            commOp.responseTimeout = n2;
            if (n >= 0) {
                commOp.header = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
                commOp.header.setSize(n);
                commOp.header.setMode(by);
                commOp.header.setNumberOfResults(0);
            }
            commOp.outBytes = byArray;
            this.handle(commOp);
            this.lastHeader = commOp.header;
            return commOp.inBytes;
        }
        catch (IOException iOException) {
            if (trace_exception) {
                iOException.printStackTrace();
            }
            this.log(iOException.toString());
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
    }

    private byte[] readMessageBody(Header header) throws ConnectionException, IOException, ConnectionLost {
        int n;
        int n2 = 0;
        byte[] byArray = null;
        if (n > 0) {
            int n3;
            byArray = new byte[header.getSize()];
            for (n = header.getSize(); n > 0; n -= n3) {
                n3 = 0;
                try {
                    n3 = this.from_database.read(byArray, n2, n);
                    if (n3 < 0) {
                        throw new ConnectionLost(Translator.Failed_to_read_from_server(), this.getSessionID());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    n3 = interruptedIOException.bytesTransferred;
                }
                n2 += n3;
            }
        }
        return byArray;
    }

    protected synchronized void closeSocket() throws SQLException {
        boolean bl = trace_exception;
        trace_exception = false;
        if (this.csocket == null) {
            return;
        }
        try {
            this.csocket.close();
        }
        catch (Exception exception) {
            this.log(exception.toString(), 0);
        }
        trace_exception = bl;
        this.csocket = null;
        this.connected = false;
    }

    public void rollback() throws SQLException {
        this.log("rollback", 1);
        this.log("createStatement to execute rollback");
        Statement statement = this.createStatement();
        statement.executeUpdate("/*EXAConnection.rollback()*/ rollback;");
        statement.close();
    }

    public void changeAutoCommit(Byte by) {
        boolean bl = by != 0;
        this.connectionParam.put(AUTOCOMMIT, bl ? "1" : "0");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.log("EXAConnection.setAutoCommit(" + bl + ")");
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
        protocolAttribute.value = new Boolean(bl);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
            this.connectionParam.put(AUTOCOMMIT, bl ? "1" : "0");
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setAutoCommit(): caught exception: " + iOException);
            throw new ConnectionLost(Translator.Failed_to_set_autocommit_mode_to() + iOException.toString(), this.getSessionID());
        }
    }

    public void SetSnapshotTransactions(boolean bl) throws SQLException {
        this.log("EXAConnection.useSnpashotTransaction(" + bl + ")");
        if (this.getActiveProtocolVersion() >= 12) {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            protocolAttribute.value = new Boolean(bl);
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            try {
                this.setAttributes(protocolAttributeArray);
            }
            catch (IOException iOException) {
                this.log("EXAConnection.useSnpashotTransaction(): caught exception: " + iOException);
                throw new ConnectionLost(Translator.Failed_to_set_use_snapshot_transactions_to() + iOException.toString(), this.getSessionID());
            }
        } else {
            this.log("Attribute ATTR_SNAPSHOT_TRANSACTIONS_ENABLED not implemented for protocol V" + this.getActiveProtocolVersion());
        }
    }

    public void setFeedbackInterval(int n) throws SQLException {
        this.log("EXAConnection.setFeedbackInterval(" + n + ")");
        if (this.getActiveProtocolVersion() < 9) {
            throw new SQLException(Translator.Failed_to_set_feedback_interval_to() + n + ". Active protocol version: " + this.getActiveProtocolVersion());
        }
        this.feedbackInterval = n;
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id);
        protocolAttribute.value = new Integer(n);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setFeedbackInterval(): caught exception: " + iOException);
            throw new ConnectionLost(Translator.Failed_to_set_feedback_interval_to() + n + ". " + iOException.toString(), this.getSessionID());
        }
    }

    public int getFeedbackInterval() {
        if (-1 == this.feedbackInterval) {
            return 30;
        }
        return this.feedbackInterval;
    }

    public boolean getSnapshotTransactionsEnabled() {
        return this.snapshotTransactions;
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    public void setCatalog(String string) throws SQLException {
        this.log("setCatalog(" + string + ")", 1);
        if (!this.currentCatalog.equalsIgnoreCase(string)) {
            throw new SQLException(Translator.No_such_catalog() + string);
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.log("setReadOnly(" + bl + ")", 0);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.log("setTypeMap()", 0);
        this.typeMap = map;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.log("EXAConnection.setQueryTimeout(" + n + ")");
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_QUERY_TIMEOUT.id);
        protocolAttribute.value = new Integer(n);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setQueryTimeout(" + n + "): caught IOException: " + iOException.toString());
            throw new SQLException(iOException.toString());
        }
        catch (SQLException sQLException) {
            this.log("EXAConnection.setQueryTimeout(" + n + "): caught SQLException: " + sQLException.toString());
            throw sQLException;
        }
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public String[] getClusterNodes() throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
        String string = InetAddress.getByName(this.exaServer).getHostAddress();
        eXAOutputStream.writeString(string);
        eXAOutputStream.flush();
        this.log("getClusterNodes(), sending ip: " + string, 0);
        byte[] byArray = this.communication(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), (byte)16, 0, new ExecutionStatus());
        EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
        int n = eXAInputStream.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = eXAInputStream.readString();
            this.log("EXA reports ip " + i + " of " + n + ": " + stringArray[i]);
        }
        return stringArray;
    }

    public Vector getClusterNodesVector() {
        return this.clusterNodes;
    }

    protected void startParallel(int n) {
        try {
            int n2;
            Header header = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
            header.setMode((byte)30);
            header.setSize(4);
            header.write_to(this.to_database);
            this.to_database.writeInt(n);
            this.to_database.flush();
            byte[] byArray = this.communication(null, -1, header.getMode(), 0, new ExecutionStatus());
            EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
            System.out.println("Number of Ports: " + n2);
            long l = eXAInputStream.readLong();
            System.out.println("Token: " + l);
            for (n2 = header.getNumberOfResults(); n2 > 0; --n2) {
                int n3 = eXAInputStream.readInt();
                String string = eXAInputStream.readString();
                System.out.println(string + ":" + n3);
            }
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected DebugLog getDebug() {
        return this.debug;
    }

    protected int uploadJob(String string, byte by, Vector vector, Vector vector2, String string2) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    protected int uploadJob(String string, byte by, Vector vector, Vector vector2) throws SQLException, IOException {
        return this.uploadJob(string, by, vector, vector2, this.user);
    }

    protected void setQueuePolicy(int n) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    public void killSession(long l) throws SQLException, ConnectionException {
        this.log("killSession(" + l + ")", 0);
        if (l < 0L) {
            throw ExceptionFactory.createSQLException(Translator.Invalid_process_number(), "08003", (EXAConnection)this);
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        EXAResult[] eXAResultArray = null;
        byte[] byArray = null;
        if (this.getActiveProtocolVersion() >= 8) {
            byArray = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray[i] = (byte)(l >>> i * 8);
            }
        } else {
            byArray = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)(l >>> i * 8);
            }
        }
        if ((eXAResultArray = this.connection.communication_resultset(byArray, (byte)27, executionStatus)) != null && eXAResultArray.length > 0 && eXAResultArray[0] instanceof EXASQLException) {
            throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
        }
    }

    protected boolean isInVMUMode() {
        return this.vmuMode;
    }

    private String[] ColSplitter(String string) throws LoaderException {
        if (null == string || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 1;
        String[] stringArray = null;
        int n4 = 0;
        string = string + ",";
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '(': {
                    if (bl) continue block6;
                    ++n2;
                    continue block6;
                }
                case ')': {
                    if (bl) continue block6;
                    --n2;
                    continue block6;
                }
                case '\"': {
                    if (!bl) {
                        bl = true;
                        continue block6;
                    }
                    bl = false;
                    continue block6;
                }
                case ',': {
                    if (false != n2 || bl) continue block6;
                    if (i - n < 3) {
                        throw new LoaderException(Translator.Sytax_error_missing_column_description_for_col() + n3);
                    }
                    ++n3;
                    if (0 == n4) {
                        stringArray = new String[1];
                    } else {
                        String[] stringArray2 = new String[n4 + 1];
                        for (int j = 0; j < n4; ++j) {
                            stringArray2[j] = stringArray[j];
                        }
                        stringArray = stringArray2;
                    }
                    stringArray[n4] = new String(cArray, n, i - n);
                    n = i + 1;
                    ++n4;
                }
            }
        }
        if (0 == n4) {
            stringArray = new String[]{new String(cArray)};
        }
        return stringArray;
    }

    private void GetCollsAndTypes(String[] stringArray, String[] stringArray2, String[] stringArray3) throws LoaderException {
        for (int i = 0; i < stringArray3.length; ++i) {
            int n;
            char[] cArray = new char[stringArray3[i].length()];
            stringArray3[i].getChars(0, stringArray3[i].length(), cArray, 0);
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            boolean bl2 = false;
            block13: for (n = 0; n < cArray.length && null == stringArray[i]; ++n) {
                switch (cArray[n]) {
                    case '\"': {
                        if (!bl) {
                            bl = true;
                            continue block13;
                        }
                        bl = false;
                        continue block13;
                    }
                    case ' ': {
                        if (!bl && bl2) {
                            stringArray[i] = new String(cArray, n2, n - n2);
                            n2 = n + 1;
                            continue block13;
                        }
                        if (bl2) continue block13;
                        ++n2;
                        continue block13;
                    }
                    default: {
                        bl2 = true;
                    }
                }
            }
            if (null == stringArray[i]) {
                throw new LoaderException(Translator.No_column_name_found_for_column() + (i + 1));
            }
            bl2 = false;
            boolean bl3 = false;
            while (n < cArray.length && null == stringArray2[i]) {
                switch (cArray[n]) {
                    case '(': {
                        ++n3;
                        if (bl3) {
                            throw new LoaderException(Translator.To_many_parantheses_describing_datatype_for_col() + (i + 1));
                        }
                        bl3 = true;
                        break;
                    }
                    case ')': {
                        --n3;
                        break;
                    }
                    case ' ': {
                        if (0 == n3 && bl2) {
                            boolean bl4 = true;
                            if (!bl3) {
                                bl4 = false;
                                int n4 = 0;
                                while (n + n4 < cArray.length && cArray[n + n4] == ' ') {
                                    ++n4;
                                }
                                if (n + n4 == cArray.length) {
                                    bl4 = true;
                                } else if ('(' != cArray[n + n4]) {
                                    bl4 = true;
                                }
                            }
                            if (!bl4) break;
                            stringArray2[i] = new String(cArray, n2, n - n2);
                            break;
                        }
                        if (bl2) break;
                        ++n2;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                ++n;
            }
            if (0 != n3) {
                throw new LoaderException(Translator.Error_found_counting_parantheses_in_datatype_description_for_col() + (i + 1));
            }
            if (n2 + 1 < n && null == stringArray2[i]) {
                stringArray2[i] = new String(cArray, n2, n - n2);
            }
            if (null == stringArray2[i]) {
                throw new LoaderException(Translator.No_datataype_found_for_column() + (i + 1));
            }
            while (n < cArray.length) {
                switch (cArray[n]) {
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new LoaderException(i + 1 + Translator.Too_many_words_found());
                    }
                }
                ++n;
            }
        }
    }

    protected static String sqlQuote(String string, char c) {
        char[] cArray = new char[(string.length() << 1) + 2];
        int n = 0;
        cArray[n++] = c;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                cArray[n++] = c2;
            }
            cArray[n++] = c2;
        }
        cArray[n++] = c;
        return new String(cArray, 0, n);
    }

    protected int compiledDriverVersion() {
        return defaultDriverProtocollVersion;
    }

    public int getEXAPort() {
        return this.exaPort;
    }

    public String getEXAServer() {
        return this.exaServer;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getURL() {
        return this.connectionParam.getProperty("url");
    }

    protected static DriverPropertyInfo[] getDefaultProperties() {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[4];
        driverPropertyInfoArray[0] = new DriverPropertyInfo(INITIAL_SCHEMA, null);
        driverPropertyInfoArray[0].description = Translator.Name_of_initially_opened_schema();
        driverPropertyInfoArray[0].required = false;
        driverPropertyInfoArray[1] = new DriverPropertyInfo(DEBUG, "0");
        driverPropertyInfoArray[1].description = Translator.Set_to_1_to_activate_logging();
        driverPropertyInfoArray[1].required = false;
        driverPropertyInfoArray[2] = new DriverPropertyInfo(FETCHSIZE, Integer.toString(2000));
        driverPropertyInfoArray[2].description = Translator.Default_fetch_size();
        driverPropertyInfoArray[2].required = false;
        driverPropertyInfoArray[3] = new DriverPropertyInfo(AUTOCOMMIT, "1");
        driverPropertyInfoArray[3].description = Translator.Auto_commit_0_disabled_1_enabled();
        driverPropertyInfoArray[3].required = false;
        return driverPropertyInfoArray;
    }

    protected void setAttributes(ProtocolAttribute[] protocolAttributeArray) throws IOException, SQLException {
        this.log("EXAConnection.setAttributes(), setting " + protocolAttributeArray.length + " attributes.");
        this.tmpOutMessage = new OutMessage(this.debug, (EXAConnection)this);
        this.tmpOutMessage.getHeader().setMode((byte)35);
        for (int i = 0; i < protocolAttributeArray.length; ++i) {
            this.tmpOutMessage.getHeader().addAttribute(protocolAttributeArray[i]);
        }
        this.tmpInMessage = this.communication(this.tmpOutMessage);
        this.checkResults(this.tmpInMessage);
    }

    protected void getAttributes() throws SQLException, IOException {
        this.log("EXAConnection.getAttributes()");
        byte[] byArray = this.communication(null, 0, (byte)34, 0, new ExecutionStatus());
        this.log("EXAConnection.getAttributes() numeric_characters=" + this.numericCharacters);
    }

    protected void reconnect() throws SQLException {
        if (this.wasDisconnected) {
            throw new SQLException(Translator.No_operations_allowed_on_this_connection_because_it_was_already_closed());
        }
        this.closeAbort(false);
        if (this.reconnectCount++ < 1) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new SQLException(interruptedException.toString());
            }
            try {
                this.setupConnection(true, null);
            }
            catch (ConnectionException connectionException) {
                if (connectionException instanceof ConnectionLost) {
                    this.closeSocket();
                    throw connectionException;
                }
                this.closeSocket();
                throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
            }
        }
        this.closeSocket();
        throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
        this.reconnectCount = 0;
    }

    protected static int getProtocolVersion() {
        return defaultDriverProtocollVersion;
    }

    void updateSessionAttributes(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ProtocolAttribute protocolAttribute = (ProtocolAttribute)vector.elementAt(i);
            if (protocolAttribute.id == ProtocolAttribute.ATTR_SESSIONID.id) {
                this.sessionID = (Long)protocolAttribute.value;
                this.log("Session id received: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_CURRENT_SCHEMA.id) {
                if (protocolAttribute.value != null) {
                    this.changeCurrentSchema(protocolAttribute.value.toString());
                    this.log("Current schema: " + protocolAttribute.value.toString());
                    continue;
                }
                this.changeCurrentSchema(null);
                this.log("Current schema: <none>");
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_CURRENT_CATALOG.id) {
                if (protocolAttribute.value != null) {
                    this.currentCatalog = protocolAttribute.value.toString();
                    this.log("Current catalog: " + protocolAttribute.value);
                    continue;
                }
                this.currentCatalog = null;
                this.log("Current catalog: <none>");
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PROTOCOL_VERSION.id) {
                this.activeProtocolVersion = (Integer)protocolAttribute.value;
                this.log("Protocol version: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATA_MESSAGE_SIZE.id) {
                this.maxMessageSize = (Long)protocolAttribute.value;
                this.log("maxDataMessageSize: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATE_FORMAT.id) {
                this.dateFormat = protocolAttribute.value != null ? protocolAttribute.value.toString() : DEFAULT_DATEFORMAT;
                this.log("NLS date format: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATETIME_FORMAT.id) {
                this.timestampFormat = protocolAttribute.value != null ? protocolAttribute.value.toString() : DEFAULT_TIMESTAMPFORMAT;
                this.log("NLS timestamp format: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATE_LANGUAGE.id) {
                this.dateLanguage = protocolAttribute.value != null ? protocolAttribute.value.toString() : "german";
                this.log("NLS date language: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_NUMERIC_CHARACTERS.id) {
                this.numericCharacters = protocolAttribute.value != null ? protocolAttribute.value.toString() : DEFAULT_NUMERIC_CHARACTERS;
                this.log("Numeric characters: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PUBLIC_KEY.id) {
                this.publicKey = (byte[])protocolAttribute.value;
                this.log("Public Key: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_RANDOM_PHRASE.id) {
                this.randomPhrase = (byte[])protocolAttribute.value;
                this.log("Random phrase: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DB_NAME.id) {
                this.databaseName = protocolAttribute.value.toString();
                this.log("Database Name: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PRODUCT_NAME.id) {
                this.databaseProductName = protocolAttribute.value.toString();
                this.log("Database Product Name: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_RELEASE_VERSION.id) {
                this.databaseProductVersion = protocolAttribute.value.toString();
                this.log("Database Product Version: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_QUERY_CACHE_ACCESS.id) {
                this.log("Query cache access: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_ENCRYPTION_REQUIRED.id) {
                this.encryptionRequired = (Boolean)protocolAttribute.value;
                this.log("Encryption required: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id) {
                this.feedbackInterval = (Integer)protocolAttribute.value;
                this.log("Feedback interval: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id != ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id) continue;
            this.snapshotTransactions = (Boolean)protocolAttribute.value;
            this.log("Snapshot transactions enabled: " + protocolAttribute.value);
        }
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public String getCurrentSchema() throws SQLException {
        return this.currentSchema;
    }

    protected void changeCurrentSchema(String string) {
        String string2 = this.currentSchema;
        this.currentSchema = string;
        this.fireSchemaChanged(string2, this.currentSchema);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getDateLanguage() {
        return this.dateLanguage;
    }

    public String getNumericCharacters() {
        return this.numericCharacters;
    }

    protected static int getDateFormatWidth(String string) {
        if (string == null) {
            return 10;
        }
        return string.length();
    }

    protected static int getTimestampFormatWidth(String string) {
        if (string == null) {
            return 23;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (n2 < 2) {
                if (cArray[i] == 'f' || cArray[i] == 'F') {
                    ++n2;
                    continue;
                }
                n2 = 0;
                continue;
            }
            if (cArray[i] >= '\u0000' || cArray[i] <= '\t') {
                int n3 = cArray[i] - 48;
                n = n - 3 + n3;
            }
            n2 = 0;
        }
        return n;
    }

    public String getSysSchema() {
        return this.sysSchema;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected String GetDatabaseName() {
        return this.databaseName;
    }

    protected String GetDatabaseProductName() {
        return this.databaseProductName;
    }

    protected String GetDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    private class CommOp
    implements RecoverableOperation {
        protected Header header = null;
        protected byte[] outBytes = null;
        protected byte[] inBytes = null;
        protected int responseTimeout = 0;
        ExecutionStatus execStatus = null;

        protected CommOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void op() throws IOException, SQLException {
            if (this.header != null) {
                this.header.write_to(AbstractEXAConnection.this.to_database);
            }
            if (this.outBytes != null) {
                AbstractEXAConnection.this.to_database.write(this.outBytes, 0, this.outBytes.length);
            }
            AbstractEXAConnection.this.to_database.flush();
            boolean bl = false;
            Header header = new Header(this.header);
            try {
                while (!bl) {
                    if (null != this.execStatus && this.execStatus.mustCancel()) {
                        this.inBytes = null;
                        return;
                    }
                    ((EncryptedInputStream)AbstractEXAConnection.this.from_database).SetMemoryStream(header.read_from(AbstractEXAConnection.this.from_database, this.responseTimeout));
                    AbstractEXAConnection.this.updateSessionAttributes(header.getAttributes());
                    this.inBytes = AbstractEXAConnection.this.readMessageBody(header);
                    if (AbstractEXAConnection.this.getActiveProtocolVersion() <= 8) {
                        bl = true;
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0]) {
                        byte[] byArray = new byte[this.inBytes.length - 5];
                        System.arraycopy(this.inBytes, 5, byArray, 0, byArray.length);
                        String string = null;
                        try {
                            string = new String(byArray, "UTF-8");
                            if (string.toUpperCase(Locale.ENGLISH).contains("<status>EXECUTING</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "EXECUTING";
                            }
                            if (string.toUpperCase(Locale.ENGLISH).contains("<status>QUEUED</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "QUEUED";
                            }
                            if (!AbstractEXAConnection.this.connectionStatus.equals("QUEUED") || !this.execStatus.isCanceled()) continue;
                            this.inBytes = null;
                            AbstractEXAConnection.this.closeAbort(false);
                            return;
                        }
                        catch (Exception exception) {
                            string = "UNKNOWN";
                        }
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0]) continue;
                    bl = true;
                }
            }
            finally {
                this.header.setSerialNumber(header.getSerialNumber());
            }
            this.header = header;
        }
    }

    private static final class ConnectionStatus {
        public static final String EXECUTING = "EXECUTING";
        public static final String QUEUED = "QUEUED";
        public static final String UNKNOWN = "UNKNOWN";

        private ConnectionStatus() {
        }
    }
}

