/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorDistance;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;

class OperatorDistanceLocal
extends OperatorDistance {
    OperatorDistanceLocal() {
    }

    @Override
    public double execute(Geometry geom1, Geometry geom2, ProgressTracker progressTracker) {
        if (geom1 == null || geom2 == null) {
            throw new IllegalArgumentException();
        }
        Geometry geometryA = geom1;
        Geometry geometryB = geom2;
        if (geometryA.isEmpty() || geometryB.isEmpty()) {
            return Double.NaN;
        }
        Geometry.Type gtA = geometryA.getType();
        Geometry.Type gtB = geometryB.getType();
        if (gtA == Geometry.Type.Point) {
            if (gtB == Geometry.Type.Point) {
                return Point2D.distance(((Point)geometryA).getXY(), ((Point)geometryB).getXY());
            }
            if (gtB == Geometry.Type.Envelope) {
                Envelope2D envB = new Envelope2D();
                geometryB.queryEnvelope2D(envB);
                return envB.distance(((Point)geometryA).getXY());
            }
            MultiPoint multiPointA = new MultiPoint();
            multiPointA.add((Point)geometryA);
            geometryA = multiPointA;
        } else if (gtA == Geometry.Type.Envelope) {
            if (gtB == Geometry.Type.Envelope) {
                Envelope2D envA = new Envelope2D();
                geometryA.queryEnvelope2D(envA);
                Envelope2D envB = new Envelope2D();
                geometryB.queryEnvelope2D(envB);
                return envB.distance(envA);
            }
            Polygon polygonA = new Polygon();
            polygonA.addEnvelope((Envelope)geometryA, false);
            geometryA = polygonA;
        }
        if (gtB == Geometry.Type.Point) {
            MultiPoint multiPointB = new MultiPoint();
            multiPointB.add((Point)geometryB);
            geometryB = multiPointB;
        } else if (gtB == Geometry.Type.Envelope) {
            Polygon polygonB = new Polygon();
            polygonB.addEnvelope((Envelope)geometryB, false);
            geometryB = polygonB;
        }
        DistanceCalculator distanceCalculator = new DistanceCalculator(progressTracker);
        double distance = distanceCalculator.calculate(geometryA, geometryB);
        return distance;
    }

    class DistanceCalculator {
        private ProgressTracker m_progressTracker;
        private Envelope2D m_env2DgeometryA;
        private Envelope2D m_env2DgeometryB;

        private void swapEnvelopes_() {
            double temp = this.m_env2DgeometryA.xmin;
            this.m_env2DgeometryA.xmin = this.m_env2DgeometryB.xmin;
            this.m_env2DgeometryB.xmin = temp;
            temp = this.m_env2DgeometryA.xmax;
            this.m_env2DgeometryA.xmax = this.m_env2DgeometryB.xmax;
            this.m_env2DgeometryB.xmax = temp;
            temp = this.m_env2DgeometryA.ymin;
            this.m_env2DgeometryA.ymin = this.m_env2DgeometryB.ymin;
            this.m_env2DgeometryB.ymin = temp;
            temp = this.m_env2DgeometryA.ymax;
            this.m_env2DgeometryA.ymax = this.m_env2DgeometryB.ymax;
            this.m_env2DgeometryB.ymax = temp;
        }

        private double executeBruteForce_(Geometry geometryA, Geometry geometryB) {
            boolean geometriesAreDisjoint;
            if (this.m_progressTracker != null && !this.m_progressTracker.progress(-1, -1)) {
                throw new RuntimeException("user_canceled");
            }
            boolean bl = geometriesAreDisjoint = !this.m_env2DgeometryA.isIntersecting(this.m_env2DgeometryB);
            if (Geometry.isMultiPath(geometryA.getType().value()) && Geometry.isMultiPath(geometryB.getType().value())) {
                if (((MultiPath)geometryA).getPointCount() > ((MultiPath)geometryB).getPointCount()) {
                    return this.bruteForceMultiPathMultiPath_((MultiPath)geometryA, (MultiPath)geometryB, geometriesAreDisjoint);
                }
                this.swapEnvelopes_();
                double answer = this.bruteForceMultiPathMultiPath_((MultiPath)geometryB, (MultiPath)geometryA, geometriesAreDisjoint);
                this.swapEnvelopes_();
                return answer;
            }
            if (geometryA.getType() == Geometry.Type.MultiPoint && Geometry.isMultiPath(geometryB.getType().value())) {
                this.swapEnvelopes_();
                double answer = this.bruteForceMultiPathMultiPoint_((MultiPath)geometryB, (MultiPoint)geometryA, geometriesAreDisjoint);
                this.swapEnvelopes_();
                return answer;
            }
            if (geometryB.getType() == Geometry.Type.MultiPoint && Geometry.isMultiPath(geometryA.getType().value())) {
                return this.bruteForceMultiPathMultiPoint_((MultiPath)geometryA, (MultiPoint)geometryB, geometriesAreDisjoint);
            }
            if (geometryA.getType() == Geometry.Type.MultiPoint && geometryB.getType() == Geometry.Type.MultiPoint) {
                if (((MultiPoint)geometryA).getPointCount() > ((MultiPoint)geometryB).getPointCount()) {
                    return this.bruteForceMultiPointMultiPoint_((MultiPoint)geometryA, (MultiPoint)geometryB, geometriesAreDisjoint);
                }
                this.swapEnvelopes_();
                double answer = this.bruteForceMultiPointMultiPoint_((MultiPoint)geometryB, (MultiPoint)geometryA, geometriesAreDisjoint);
                this.swapEnvelopes_();
                return answer;
            }
            return 0.0;
        }

        /*
         * Unable to fully structure code
         */
        private double bruteForceMultiPathMultiPath_(MultiPath geometryA, MultiPath geometryB, boolean geometriesAreDisjoint) {
            segIterA = geometryA.querySegmentIterator();
            segIterB = geometryB.querySegmentIterator();
            env2DSegmentA = new Envelope2D();
            env2DSegmentB = new Envelope2D();
            minSqrDistance = NumberUtils.doubleMax();
            if (geometriesAreDisjoint || !this.weakIntersectionTest_(geometryA, geometryB, segIterA, segIterB)) ** GOTO lbl27
            return 0.0;
            {
                block7: {
                    segmentA = segIterA.nextSegment();
                    segmentA.queryEnvelope2D(env2DSegmentA);
                    if (!(env2DSegmentA.sqrDistance(this.m_env2DgeometryB) > minSqrDistance)) ** GOTO lbl22
                    break block7;
                    {
                        segmentB = segIterB.nextSegment();
                        segmentB.queryEnvelope2D(env2DSegmentB);
                        if (env2DSegmentA.sqrDistance(env2DSegmentB) < minSqrDistance) {
                            sqrDistance = segmentA.distance(segmentB, geometriesAreDisjoint);
                            if ((sqrDistance *= sqrDistance) < minSqrDistance) {
                                if (sqrDistance == 0.0) {
                                    return 0.0;
                                }
                                minSqrDistance = sqrDistance;
                            }
                        }
                        do {
                            if (segIterB.hasNextSegment()) continue block1;
lbl22:
                            // 2 sources

                        } while (segIterB.nextPath());
                    }
                    segIterB.resetToFirstPath();
                }
                do {
                    if (segIterA.hasNextSegment()) continue block0;
lbl27:
                    // 2 sources

                } while (segIterA.nextPath());
            }
            return Math.sqrt(minSqrDistance);
        }

        /*
         * Unable to fully structure code
         */
        private double bruteForceMultiPathMultiPoint_(MultiPath geometryA, MultiPoint geometryB, boolean geometriesAreDisjoint) {
            segIterA = geometryA.querySegmentIterator();
            env2DSegmentA = new Envelope2D();
            minSqrDistance = NumberUtils.doubleMax();
            inputPoint = new Point2D();
            t = -1.0;
            sqrDistance = minSqrDistance;
            multiPointImplB = (MultiPointImpl)geometryB._getImpl();
            pointCountB = multiPointImplB.getPointCount();
            bDoPiPTest = geometriesAreDisjoint == false && geometryA.getType() == Geometry.Type.Polygon;
            ** GOTO lbl31
            {
                segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env2DSegmentA);
                if (pointCountB <= 1 || !(env2DSegmentA.sqrDistance(this.m_env2DgeometryB) > minSqrDistance)) {
                    i = 0;
                    while (i < pointCountB) {
                        multiPointImplB.getXY(i, inputPoint);
                        if (bDoPiPTest && PolygonUtils.isPointInPolygon2D((Polygon)geometryA, inputPoint, 0.0) != PolygonUtils.PiPResult.PiPOutside) {
                            return 0.0;
                        }
                        t = segmentA.getClosestCoordinate(inputPoint, false);
                        inputPoint.sub(segmentA.getCoord2D(t));
                        sqrDistance = inputPoint.sqrLength();
                        if (sqrDistance < minSqrDistance) {
                            if (sqrDistance == 0.0) {
                                return 0.0;
                            }
                            minSqrDistance = sqrDistance;
                        }
                        ++i;
                    }
                    bDoPiPTest = false;
                }
                do {
                    if (segIterA.hasNextSegment()) continue block0;
lbl31:
                    // 2 sources

                } while (segIterA.nextPath());
            }
            return Math.sqrt(minSqrDistance);
        }

        private double bruteForceMultiPointMultiPoint_(MultiPoint geometryA, MultiPoint geometryB, boolean geometriesAreDisjoint) {
            double minSqrDistance = NumberUtils.doubleMax();
            Point2D pointA = new Point2D();
            Point2D pointB = new Point2D();
            double sqrDistance = minSqrDistance;
            MultiPointImpl multiPointImplA = (MultiPointImpl)geometryA._getImpl();
            MultiPointImpl multiPointImplB = (MultiPointImpl)geometryB._getImpl();
            int pointCountA = multiPointImplA.getPointCount();
            int pointCountB = multiPointImplB.getPointCount();
            int i = 0;
            while (i < pointCountA) {
                multiPointImplA.getXY(i, pointA);
                if (pointCountB <= 1 || !(this.m_env2DgeometryB.sqrDistance(pointA) > minSqrDistance)) {
                    int j = 0;
                    while (j < pointCountB) {
                        multiPointImplB.getXY(j, pointB);
                        sqrDistance = Point2D.sqrDistance(pointA, pointB);
                        if (sqrDistance < minSqrDistance) {
                            if (sqrDistance == 0.0) {
                                return 0.0;
                            }
                            minSqrDistance = sqrDistance;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return Math.sqrt(minSqrDistance);
        }

        private boolean weakIntersectionTest_(Geometry geometryA, Geometry geometryB, SegmentIterator segIterA, SegmentIterator segIterB) {
            if (geometryA.getType() == Geometry.Type.Polygon) {
                while (segIterB.nextPath()) {
                    Segment segmentB;
                    if (!segIterB.hasNextSegment() || PolygonUtils.isPointInPolygon2D((Polygon)geometryA, (segmentB = segIterB.nextSegment()).getEndXY(), 0.0) == PolygonUtils.PiPResult.PiPOutside) continue;
                    return true;
                }
                segIterB.resetToFirstPath();
            }
            if (geometryB.getType() == Geometry.Type.Polygon) {
                while (segIterA.nextPath()) {
                    Segment segmentA;
                    if (!segIterA.hasNextSegment() || PolygonUtils.isPointInPolygon2D((Polygon)geometryB, (segmentA = segIterA.nextSegment()).getEndXY(), 0.0) == PolygonUtils.PiPResult.PiPOutside) continue;
                    return true;
                }
                segIterA.resetToFirstPath();
            }
            return false;
        }

        DistanceCalculator(ProgressTracker progressTracker) {
            this.m_progressTracker = progressTracker;
            this.m_env2DgeometryA = new Envelope2D();
            this.m_env2DgeometryA.setEmpty();
            this.m_env2DgeometryB = new Envelope2D();
            this.m_env2DgeometryB.setEmpty();
        }

        double calculate(Geometry geometryA, Geometry geometryB) {
            if (geometryA.isEmpty() || geometryB.isEmpty()) {
                return Double.NaN;
            }
            geometryA.queryEnvelope2D(this.m_env2DgeometryA);
            geometryB.queryEnvelope2D(this.m_env2DgeometryB);
            return this.executeBruteForce_(geometryA, geometryB);
        }
    }
}

