/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.IndexMultiDCList;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.RingOrientationFixer;
import com.esri.core.geometry.TopologicalOperations;

class Simplificator {
    private EditShape m_shape;
    private int m_geometry;
    private IndexMultiDCList m_sortedVertices;
    private AttributeStreamOfInt32 m_bunchEdgeEndPoints;
    private AttributeStreamOfInt32 m_bunchEdgeCenterPoints;
    private AttributeStreamOfInt32 m_bunchEdgeIndices;
    private int m_dbgCounter = 0;
    private int m_sortedVerticesListIndex;
    private int m_userIndexSortedIndexToVertex;
    private int m_userIndexSortedAngleIndexToVertex;
    private int m_nextVertexToProcess;
    private int m_firstCoincidentVertex;
    private int m_knownSimpleResult;
    private boolean m_bWinding;
    private boolean m_fixSelfTangency;
    private ProgressTracker m_progressTracker;

    private void _beforeRemoveVertex(int vertex, boolean bChangePathFirst) {
        int first;
        int path;
        int vertexlistIndex = this.m_shape.getUserIndex(vertex, this.m_userIndexSortedIndexToVertex);
        if (this.m_nextVertexToProcess == vertexlistIndex) {
            this.m_nextVertexToProcess = this.m_sortedVertices.getNext(this.m_nextVertexToProcess);
        }
        if (this.m_firstCoincidentVertex == vertexlistIndex) {
            this.m_firstCoincidentVertex = this.m_sortedVertices.getNext(this.m_firstCoincidentVertex);
        }
        this.m_sortedVertices.deleteElement(this.m_sortedVerticesListIndex, vertexlistIndex);
        this._removeAngleSortInfo(vertex);
        if (bChangePathFirst && (path = this.m_shape.getPathFromVertex(vertex)) != -1 && (first = this.m_shape.getFirstVertex(path)) == vertex) {
            int next = this.m_shape.getNextVertex(vertex);
            if (next != vertex) {
                int p = this.m_shape.getPathFromVertex(next);
                if (p == path) {
                    this.m_shape.setFirstVertex_(path, next);
                    return;
                }
                int prev = this.m_shape.getPrevVertex(vertex);
                if (prev != vertex && (p = this.m_shape.getPathFromVertex(prev)) == path) {
                    this.m_shape.setFirstVertex_(path, prev);
                    return;
                }
            }
            this.m_shape.setFirstVertex_(path, -1);
            this.m_shape.setLastVertex_(path, -1);
        }
    }

    private boolean _processBunch() {
        boolean bModified = false;
        int iter = 0;
        Point2D ptCenter = new Point2D();
        while (true) {
            ++this.m_dbgCounter;
            ++iter;
            if (this.m_bunchEdgeEndPoints == null) {
                this.m_bunchEdgeEndPoints = new AttributeStreamOfInt32(0);
                this.m_bunchEdgeCenterPoints = new AttributeStreamOfInt32(0);
                this.m_bunchEdgeIndices = new AttributeStreamOfInt32(0);
            } else {
                this.m_bunchEdgeEndPoints.clear(false);
                this.m_bunchEdgeCenterPoints.clear(false);
                this.m_bunchEdgeIndices.clear(false);
            }
            int currentVertex = this.m_firstCoincidentVertex;
            int index = 0;
            boolean bFirst = true;
            while (currentVertex != this.m_nextVertexToProcess) {
                int id2;
                int v = this.m_sortedVertices.getData(currentVertex);
                Point2D pt = new Point2D();
                this.m_shape.getXY(v, pt);
                double y = pt.x;
                if (bFirst) {
                    this.m_shape.getXY(v, ptCenter);
                    bFirst = false;
                }
                int vertP = this.m_shape.getPrevVertex(v);
                int vertN = this.m_shape.getNextVertex(v);
                int id = this.m_shape.getUserIndex(vertP, this.m_userIndexSortedAngleIndexToVertex);
                if (id != -559038737) {
                    this.m_bunchEdgeEndPoints.add(vertP);
                    this.m_shape.setUserIndex(vertP, this.m_userIndexSortedAngleIndexToVertex, -559038737);
                    this.m_bunchEdgeCenterPoints.add(v);
                    this.m_bunchEdgeIndices.add(index++);
                }
                if ((id2 = this.m_shape.getUserIndex(vertN, this.m_userIndexSortedAngleIndexToVertex)) != -559038737) {
                    this.m_bunchEdgeEndPoints.add(vertN);
                    this.m_shape.setUserIndex(vertN, this.m_userIndexSortedAngleIndexToVertex, -559038737);
                    this.m_bunchEdgeCenterPoints.add(v);
                    this.m_bunchEdgeIndices.add(index++);
                }
                currentVertex = this.m_sortedVertices.getNext(currentVertex);
            }
            if (this.m_bunchEdgeEndPoints.size() < 2) break;
            this.m_bunchEdgeIndices.Sort(0, this.m_bunchEdgeIndices.size(), new SimplificatorAngleComparer(this));
            int n = this.m_bunchEdgeIndices.size();
            for (int i = 0; i < n; ++i) {
                int indexL = this.m_bunchEdgeIndices.get(i);
                int vertex = this.m_bunchEdgeEndPoints.get(indexL);
                this.m_shape.setUserIndex(vertex, this.m_userIndexSortedAngleIndexToVertex, i);
                Point2D pt = new Point2D();
                this.m_shape.getXY(vertex, pt);
                double y = pt.x;
            }
            boolean bCrossOverResolved = this._processCrossOvers(ptCenter);
            int n2 = this.m_bunchEdgeIndices.size();
            for (int i = 0; i < n2; ++i) {
                int indexL = this.m_bunchEdgeIndices.get(i);
                if (indexL == -1) continue;
                int vertex = this.m_bunchEdgeEndPoints.get(indexL);
                this.m_shape.setUserIndex(vertex, this.m_userIndexSortedAngleIndexToVertex, -1);
            }
            if (!bCrossOverResolved) break;
            bModified = true;
        }
        return bModified;
    }

    private boolean _processCrossOvers(Point2D ptCenter) {
        int vertexC2;
        int vertexC1;
        boolean bDirection2;
        boolean bDirection1;
        int vertexA2;
        int vertexA1;
        int vertexB2;
        int vertexB1;
        int edgeindex2;
        int edgeindex1;
        int i;
        int n;
        int index2;
        int index1;
        boolean bFound = false;
        boolean bContinue = true;
        while (bContinue) {
            bContinue = false;
            index1 = 0;
            if (this.m_bunchEdgeIndices.get(index1) == -1) {
                index1 = this._getNextEdgeIndex(index1);
            }
            index2 = this._getNextEdgeIndex(index1);
            n = this.m_bunchEdgeIndices.size();
            for (i = 0; i < n && index1 != -1 && index2 != -1 && index1 != index2; ++i) {
                edgeindex1 = this.m_bunchEdgeIndices.get(index1);
                edgeindex2 = this.m_bunchEdgeIndices.get(index2);
                vertexB1 = this.m_bunchEdgeEndPoints.get(edgeindex1);
                vertexB2 = this.m_bunchEdgeEndPoints.get(edgeindex2);
                vertexA1 = this.m_shape.getNextVertex(vertexB1);
                if (!this.m_shape.isEqualXY(vertexA1, ptCenter)) {
                    vertexA1 = this.m_shape.getPrevVertex(vertexB1);
                }
                if (!this.m_shape.isEqualXY(vertexA2 = this.m_shape.getNextVertex(vertexB2), ptCenter)) {
                    vertexA2 = this.m_shape.getPrevVertex(vertexB2);
                }
                bDirection1 = this._getDirection(vertexA1, vertexB1);
                bDirection2 = this._getDirection(vertexA2, vertexB2);
                vertexC1 = bDirection1 ? this.m_shape.getPrevVertex(vertexA1) : this.m_shape.getNextVertex(vertexA1);
                vertexC2 = bDirection2 ? this.m_shape.getPrevVertex(vertexA2) : this.m_shape.getNextVertex(vertexA2);
                boolean bOverlap = false;
                if (this._removeSpike(vertexA1)) {
                    bOverlap = true;
                } else if (this._removeSpike(vertexA2)) {
                    bOverlap = true;
                } else if (this._removeSpike(vertexB1)) {
                    bOverlap = true;
                } else if (this._removeSpike(vertexB2)) {
                    bOverlap = true;
                } else if (this._removeSpike(vertexC1)) {
                    bOverlap = true;
                } else if (this._removeSpike(vertexC2)) {
                    bOverlap = true;
                }
                if (!bOverlap && this.m_shape.isEqualXY(vertexB1, vertexB2)) {
                    bOverlap = true;
                    this._resolveOverlap(bDirection1, bDirection2, vertexA1, vertexB1, vertexA2, vertexB2);
                }
                if (!bOverlap && this.m_shape.isEqualXY(vertexC1, vertexC2)) {
                    bOverlap = true;
                    this._resolveOverlap(!bDirection1, !bDirection2, vertexA1, vertexC1, vertexA2, vertexC2);
                }
                if (bOverlap) {
                    bFound = true;
                }
                bContinue |= bOverlap;
                index1 = this._getNextEdgeIndex(index1);
                index2 = this._getNextEdgeIndex(index1);
            }
        }
        if (!bFound) {
            index1 = 0;
            if (this.m_bunchEdgeIndices.get(index1) == -1) {
                index1 = this._getNextEdgeIndex(index1);
            }
            index2 = this._getNextEdgeIndex(index1);
            n = this.m_bunchEdgeIndices.size();
            for (i = 0; i < n && index1 != -1 && index2 != -1 && index1 != index2; ++i) {
                edgeindex1 = this.m_bunchEdgeIndices.get(index1);
                edgeindex2 = this.m_bunchEdgeIndices.get(index2);
                vertexB1 = this.m_bunchEdgeEndPoints.get(edgeindex1);
                vertexB2 = this.m_bunchEdgeEndPoints.get(edgeindex2);
                vertexA1 = this.m_shape.getNextVertex(vertexB1);
                if (!this.m_shape.isEqualXY(vertexA1, ptCenter)) {
                    vertexA1 = this.m_shape.getPrevVertex(vertexB1);
                }
                if (!this.m_shape.isEqualXY(vertexA2 = this.m_shape.getNextVertex(vertexB2), ptCenter)) {
                    vertexA2 = this.m_shape.getPrevVertex(vertexB2);
                }
                bDirection1 = this._getDirection(vertexA1, vertexB1);
                bDirection2 = this._getDirection(vertexA2, vertexB2);
                vertexC1 = bDirection1 ? this.m_shape.getPrevVertex(vertexA1) : this.m_shape.getNextVertex(vertexA1);
                int n2 = vertexC2 = bDirection2 ? this.m_shape.getPrevVertex(vertexA2) : this.m_shape.getNextVertex(vertexA2);
                if (this._detectAndResolveCrossOver(bDirection1, bDirection2, vertexB1, vertexA1, vertexC1, vertexB2, vertexA2, vertexC2)) {
                    bFound = true;
                }
                index1 = this._getNextEdgeIndex(index1);
                index2 = this._getNextEdgeIndex(index1);
            }
        }
        return bFound;
    }

    private boolean _simplify() {
        int vertex;
        if (this.m_shape.getGeometryType(this.m_geometry) == Geometry.Type.Polygon.value() && this.m_shape.getFillRule(this.m_geometry) == 1) {
            TopologicalOperations ops = new TopologicalOperations();
            ops.planarSimplifyNoCrackingAndCluster(this.m_fixSelfTangency, this.m_shape, this.m_geometry, this.m_progressTracker);
            assert (this.m_shape.getFillRule(this.m_geometry) == 0);
        }
        boolean bChanged = false;
        boolean bNeedWindingRepeat = true;
        boolean bWinding = false;
        this.m_userIndexSortedIndexToVertex = -1;
        this.m_userIndexSortedAngleIndexToVertex = -1;
        int pointCount = this.m_shape.getPointCount(this.m_geometry);
        AttributeStreamOfInt32 verticesSorter = new AttributeStreamOfInt32(0);
        verticesSorter.reserve(pointCount);
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            vertex = this.m_shape.getFirstVertex(path);
            int n = this.m_shape.getPathSize(path);
            for (int index = 0; index < n; ++index) {
                verticesSorter.add(vertex);
                vertex = this.m_shape.getNextVertex(vertex);
            }
            path = this.m_shape.getNextPath(path);
        }
        verticesSorter.Sort(0, pointCount, new SimplificatorVertexComparer(this));
        this.m_userIndexSortedIndexToVertex = this.m_shape.createUserIndex();
        this.m_sortedVertices = new IndexMultiDCList();
        this.m_sortedVerticesListIndex = this.m_sortedVertices.createList(0);
        for (int i = 0; i < pointCount; ++i) {
            vertex = verticesSorter.get(i);
            Point2D pt = new Point2D();
            this.m_shape.getXY(vertex, pt);
            double y = pt.x;
            int vertexlistIndex = this.m_sortedVertices.addElement(this.m_sortedVerticesListIndex, vertex);
            this.m_shape.setUserIndex(vertex, this.m_userIndexSortedIndexToVertex, vertexlistIndex);
        }
        this.m_userIndexSortedAngleIndexToVertex = this.m_shape.createUserIndex();
        this.m_nextVertexToProcess = -1;
        if (this._cleanupSpikes()) {
            bChanged = true;
        }
        while (bNeedWindingRepeat) {
            bNeedWindingRepeat = false;
            int max_iter = this.m_shape.getPointCount(this.m_geometry) + 10 > 30 ? 1000 : (this.m_shape.getPointCount(this.m_geometry) + 10) * (this.m_shape.getPointCount(this.m_geometry) + 10);
            int iRepeatNum = 0;
            boolean bNeedRepeat = false;
            do {
                boolean result;
                bNeedRepeat = false;
                boolean bVertexRecheck = false;
                this.m_firstCoincidentVertex = -1;
                int coincidentCount = 0;
                Point2D ptFirst = new Point2D();
                Point2D pt = new Point2D();
                int vlistindex = this.m_sortedVertices.getFirst(this.m_sortedVerticesListIndex);
                while (vlistindex != IndexMultiDCList.nullNode()) {
                    int vertex2 = this.m_sortedVertices.getData(vlistindex);
                    this.m_shape.getXY(vertex2, pt);
                    double d = pt.x;
                    if (this.m_firstCoincidentVertex != -1) {
                        this.m_shape.getXY(vertex2, pt);
                        if (ptFirst.isEqual(pt)) {
                            ++coincidentCount;
                        } else {
                            boolean result2;
                            ptFirst.setCoords(pt);
                            this.m_nextVertexToProcess = vlistindex;
                            if (coincidentCount > 0 && (result2 = this._processBunch())) {
                                bNeedRepeat = true;
                                if (this.m_nextVertexToProcess != IndexMultiDCList.nullNode()) {
                                    int v = this.m_sortedVertices.getData(this.m_nextVertexToProcess);
                                    this.m_shape.getXY(v, ptFirst);
                                }
                            }
                            this.m_firstCoincidentVertex = vlistindex = this.m_nextVertexToProcess;
                            coincidentCount = 0;
                        }
                    } else {
                        this.m_firstCoincidentVertex = vlistindex;
                        this.m_shape.getXY(this.m_sortedVertices.getData(vlistindex), ptFirst);
                        coincidentCount = 0;
                    }
                    if (vlistindex == -1) continue;
                    vlistindex = this.m_sortedVertices.getNext(vlistindex);
                }
                this.m_nextVertexToProcess = -1;
                if (coincidentCount > 0 && (result = this._processBunch())) {
                    bNeedRepeat = true;
                }
                if (iRepeatNum++ > 10) {
                    throw GeometryException.GeometryInternalError();
                }
                if (bNeedRepeat) {
                    this._fixOrphanVertices();
                }
                if (this._cleanupSpikes()) {
                    bNeedRepeat = true;
                }
                bNeedWindingRepeat |= bNeedRepeat && bWinding;
                bChanged |= bNeedRepeat;
            } while (bNeedRepeat);
        }
        this.m_shape.removeUserIndex(this.m_userIndexSortedIndexToVertex);
        this.m_shape.removeUserIndex(this.m_userIndexSortedAngleIndexToVertex);
        return bChanged |= RingOrientationFixer.execute(this.m_shape, this.m_geometry, this.m_sortedVertices, this.m_fixSelfTangency);
    }

    private boolean _getDirection(int vert1, int vert2) {
        return this.m_shape.getNextVertex(vert2) != vert1;
    }

    private boolean _detectAndResolveCrossOver(boolean bDirection1, boolean bDirection2, int vertexB1, int vertexA1, int vertexC1, int vertexB2, int vertexA2, int vertexC2) {
        if (vertexA1 == vertexA2) {
            this._removeAngleSortInfo(vertexB1);
            this._removeAngleSortInfo(vertexB2);
            return false;
        }
        int iB1 = this.m_shape.getUserIndex(vertexB1, this.m_userIndexSortedAngleIndexToVertex);
        int iC1 = this.m_shape.getUserIndex(vertexC1, this.m_userIndexSortedAngleIndexToVertex);
        int iB2 = this.m_shape.getUserIndex(vertexB2, this.m_userIndexSortedAngleIndexToVertex);
        int iC2 = this.m_shape.getUserIndex(vertexC2, this.m_userIndexSortedAngleIndexToVertex);
        int[] ar = new int[8];
        int[] br = new int[4];
        ar[0] = 0;
        br[0] = iB1;
        ar[1] = 0;
        br[1] = iC1;
        ar[2] = 1;
        br[2] = iB2;
        ar[3] = 1;
        br[3] = iC2;
        for (int j = 1; j < 4; ++j) {
            int key = br[j];
            int data = ar[j];
            for (int i = j - 1; i >= 0 && br[i] > key; --i) {
                br[i + 1] = br[i];
                ar[i + 1] = ar[i];
            }
            br[i + 1] = key;
            ar[i + 1] = data;
        }
        int detector = 0;
        if (ar[0] != 0) {
            detector |= 1;
        }
        if (ar[1] != 0) {
            detector |= 2;
        }
        if (ar[2] != 0) {
            detector |= 4;
        }
        if (ar[3] != 0) {
            detector |= 8;
        }
        if (detector != 5 && detector != 10) {
            return false;
        }
        if (bDirection1 == bDirection2) {
            if (bDirection1) {
                this.m_shape.setNextVertex_(vertexC2, vertexA1);
                this.m_shape.setPrevVertex_(vertexA1, vertexC2);
                this.m_shape.setNextVertex_(vertexC1, vertexA2);
                this.m_shape.setPrevVertex_(vertexA2, vertexC1);
            } else {
                this.m_shape.setPrevVertex_(vertexC2, vertexA1);
                this.m_shape.setNextVertex_(vertexA1, vertexC2);
                this.m_shape.setPrevVertex_(vertexC1, vertexA2);
                this.m_shape.setNextVertex_(vertexA2, vertexC1);
            }
        } else if (bDirection1) {
            this.m_shape.setPrevVertex_(vertexA1, vertexB2);
            this.m_shape.setNextVertex_(vertexB2, vertexA1);
            this.m_shape.setPrevVertex_(vertexA2, vertexC1);
            this.m_shape.setNextVertex_(vertexC1, vertexA2);
        } else {
            this.m_shape.setNextVertex_(vertexA1, vertexB2);
            this.m_shape.setPrevVertex_(vertexB2, vertexA1);
            this.m_shape.setNextVertex_(vertexA2, vertexC1);
            this.m_shape.setPrevVertex_(vertexC1, vertexA2);
        }
        return true;
    }

    private void _resolveOverlap(boolean bDirection1, boolean bDirection2, int vertexA1, int vertexB1, int vertexA2, int vertexB2) {
        if (this.m_bWinding) {
            this._resolveOverlapWinding(bDirection1, bDirection2, vertexA1, vertexB1, vertexA2, vertexB2);
        } else {
            this._resolveOverlapOddEven(bDirection1, bDirection2, vertexA1, vertexB1, vertexA2, vertexB2);
        }
    }

    private void _resolveOverlapWinding(boolean bDirection1, boolean bDirection2, int vertexA1, int vertexB1, int vertexA2, int vertexB2) {
        throw new GeometryException("not implemented.");
    }

    private void _resolveOverlapOddEven(boolean bDirection1, boolean bDirection2, int vertexA1, int vertexB1, int vertexA2, int vertexB2) {
        if (bDirection1 != bDirection2) {
            if (bDirection1) {
                this.m_shape.setNextVertex_(vertexA1, vertexA2);
                this.m_shape.setPrevVertex_(vertexA2, vertexA1);
                this.m_shape.setNextVertex_(vertexB2, vertexB1);
                this.m_shape.setPrevVertex_(vertexB1, vertexB2);
                this._transferVertexData(vertexA2, vertexA1);
                this._beforeRemoveVertex(vertexA2, true);
                this.m_shape.removeVertexInternal_(vertexA2, true);
                this._removeAngleSortInfo(vertexA1);
                this._transferVertexData(vertexB2, vertexB1);
                this._beforeRemoveVertex(vertexB2, true);
                this.m_shape.removeVertexInternal_(vertexB2, false);
                this._removeAngleSortInfo(vertexB1);
            } else {
                this.m_shape.setNextVertex_(vertexA2, vertexA1);
                this.m_shape.setPrevVertex_(vertexA1, vertexA2);
                this.m_shape.setNextVertex_(vertexB1, vertexB2);
                this.m_shape.setPrevVertex_(vertexB2, vertexB1);
                this._transferVertexData(vertexA2, vertexA1);
                this._beforeRemoveVertex(vertexA2, true);
                this.m_shape.removeVertexInternal_(vertexA2, false);
                this._removeAngleSortInfo(vertexA1);
                this._transferVertexData(vertexB2, vertexB1);
                this._beforeRemoveVertex(vertexB2, true);
                this.m_shape.removeVertexInternal_(vertexB2, true);
                this._removeAngleSortInfo(vertexB1);
            }
        } else {
            int next;
            int prev;
            if (!bDirection1) {
                // empty if block
            }
            int a1 = bDirection1 ? vertexA1 : vertexB1;
            int a2 = bDirection2 ? vertexA2 : vertexB2;
            int b1 = bDirection1 ? vertexB1 : vertexA1;
            int b2 = bDirection2 ? vertexB2 : vertexA2;
            boolean bVisitedA1 = false;
            this.m_shape.setNextVertex_(a1, a2);
            this.m_shape.setNextVertex_(a2, a1);
            this.m_shape.setPrevVertex_(b1, b2);
            this.m_shape.setPrevVertex_(b2, b1);
            int v = b2;
            while (v != a2) {
                prev = this.m_shape.getPrevVertex(v);
                next = this.m_shape.getNextVertex(v);
                this.m_shape.setPrevVertex_(v, next);
                this.m_shape.setNextVertex_(v, prev);
                bVisitedA1 |= v == a1;
                v = next;
            }
            if (!bVisitedA1) {
                prev = this.m_shape.getPrevVertex(a2);
                next = this.m_shape.getNextVertex(a2);
                this.m_shape.setPrevVertex_(a2, next);
                this.m_shape.setNextVertex_(a2, prev);
            }
            this._transferVertexData(a2, a1);
            this._beforeRemoveVertex(a2, true);
            this.m_shape.removeVertexInternal_(a2, false);
            this._removeAngleSortInfo(a1);
            this._transferVertexData(b2, b1);
            this._beforeRemoveVertex(b2, true);
            this.m_shape.removeVertexInternal_(b2, false);
            this._removeAngleSortInfo(b1);
        }
    }

    private boolean _cleanupSpikes() {
        boolean bModified = false;
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            int vertex = this.m_shape.getFirstVertex(path);
            int vindex = 0;
            int n = this.m_shape.getPathSize(path);
            while (vindex < n && n > 1) {
                int next;
                int prev = this.m_shape.getPrevVertex(vertex);
                if (this.m_shape.isEqualXY(prev, next = this.m_shape.getNextVertex(vertex))) {
                    bModified = true;
                    this._beforeRemoveVertex(vertex, false);
                    this.m_shape.removeVertex(vertex, true);
                    this._beforeRemoveVertex(next, false);
                    this.m_shape.removeVertex(next, true);
                    vertex = prev;
                    vindex = 0;
                    n = this.m_shape.getPathSize(path);
                    continue;
                }
                vertex = next;
                ++vindex;
            }
            if (this.m_shape.getPathSize(path) < 2) {
                int vertexL = this.m_shape.getFirstVertex(path);
                int n2 = this.m_shape.getPathSize(path);
                for (int vindex2 = 0; vindex2 < n2; ++vindex2) {
                    this._beforeRemoveVertex(vertexL, false);
                    vertexL = this.m_shape.getNextVertex(vertexL);
                }
                path = this.m_shape.removePath(path);
                bModified = true;
                continue;
            }
            path = this.m_shape.getNextPath(path);
        }
        return bModified;
    }

    private boolean _removeSpike(int vertexIn) {
        int vertex = vertexIn;
        boolean bFound = false;
        while (true) {
            int next = this.m_shape.getNextVertex(vertex);
            int prev = this.m_shape.getPrevVertex(vertex);
            if (next == vertex) {
                this._beforeRemoveVertex(vertex, true);
                this.m_shape.removeVertexInternal_(vertex, false);
                return true;
            }
            if (!this.m_shape.isEqualXY(next, prev)) break;
            bFound = true;
            this._removeAngleSortInfo(prev);
            this._removeAngleSortInfo(next);
            this._beforeRemoveVertex(vertex, true);
            this.m_shape.removeVertexInternal_(vertex, false);
            this._transferVertexData(next, prev);
            this._beforeRemoveVertex(next, true);
            this.m_shape.removeVertexInternal_(next, true);
            if (next == prev) break;
            vertex = prev;
        }
        return bFound;
    }

    private void _fixOrphanVertices() {
        int pathCount = 0;
        int node = this.m_sortedVertices.getFirst(this.m_sortedVertices.getFirstList());
        while (node != -1) {
            int vertex = this.m_sortedVertices.getData(node);
            this.m_shape.setPathToVertex_(vertex, -1);
            node = this.m_sortedVertices.getNext(node);
        }
        int geometrySize = 0;
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            int first = this.m_shape.getFirstVertex(path);
            if (first == -1 || this.m_shape.getPathFromVertex(first) != -1) {
                int p = path;
                path = this.m_shape.getNextPath(path);
                this.m_shape.removePathOnly_(p);
                continue;
            }
            this.m_shape.setPathToVertex_(first, path);
            int pathSize = 1;
            int vertex = this.m_shape.getNextVertex(first);
            while (vertex != first) {
                this.m_shape.setPathToVertex_(vertex, path);
                ++pathSize;
                vertex = this.m_shape.getNextVertex(vertex);
            }
            this.m_shape.setRingAreaValid_(path, false);
            this.m_shape.setPathSize_(path, pathSize);
            this.m_shape.setLastVertex_(path, this.m_shape.getPrevVertex(first));
            geometrySize += pathSize;
            ++pathCount;
            path = this.m_shape.getNextPath(path);
        }
        int node2 = this.m_sortedVertices.getFirst(this.m_sortedVertices.getFirstList());
        while (node2 != -1) {
            int vertex = this.m_sortedVertices.getData(node2);
            if (this.m_shape.getPathFromVertex(vertex) == -1) {
                int path2 = this.m_shape.insertClosedPath_(this.m_geometry, -1, vertex, vertex, null);
                geometrySize += this.m_shape.getPathSize(path2);
                ++pathCount;
            }
            node2 = this.m_sortedVertices.getNext(node2);
        }
        this.m_shape.setGeometryPathCount_(this.m_geometry, pathCount);
        this.m_shape.setGeometryVertexCount_(this.m_geometry, geometrySize);
        int totalPointCount = 0;
        int geometry = this.m_shape.getFirstGeometry();
        while (geometry != -1) {
            totalPointCount += this.m_shape.getPointCount(geometry);
            geometry = this.m_shape.getNextGeometry(geometry);
        }
        this.m_shape.setTotalPointCount_(totalPointCount);
    }

    private int _getNextEdgeIndex(int indexIn) {
        int index = indexIn;
        int n = this.m_bunchEdgeIndices.size() - 1;
        for (int i = 0; i < n; ++i) {
            if (this.m_bunchEdgeIndices.get(index = (index + 1) % this.m_bunchEdgeIndices.size()) == -1) continue;
            return index;
        }
        return -1;
    }

    private void _transferVertexData(int vertexFrom, int vertexTo) {
        int v1 = this.m_shape.getUserIndex(vertexTo, this.m_userIndexSortedIndexToVertex);
        int v2 = this.m_shape.getUserIndex(vertexTo, this.m_userIndexSortedAngleIndexToVertex);
        this.m_shape.transferAllDataToTheVertex(vertexFrom, vertexTo);
        this.m_shape.setUserIndex(vertexTo, this.m_userIndexSortedIndexToVertex, v1);
        this.m_shape.setUserIndex(vertexTo, this.m_userIndexSortedAngleIndexToVertex, v2);
    }

    private void _removeAngleSortInfo(int vertex) {
        int angleIndex = this.m_shape.getUserIndex(vertex, this.m_userIndexSortedAngleIndexToVertex);
        if (angleIndex != -1) {
            this.m_bunchEdgeIndices.set(angleIndex, -1);
            this.m_shape.setUserIndex(vertex, this.m_userIndexSortedAngleIndexToVertex, -1);
        }
    }

    protected Simplificator() {
    }

    public static boolean execute(EditShape shape, int geometry, int knownSimpleResult, boolean fixSelfTangency, ProgressTracker progressTracker) {
        Simplificator simplificator = new Simplificator();
        simplificator.m_shape = shape;
        simplificator.m_geometry = geometry;
        simplificator.m_knownSimpleResult = knownSimpleResult;
        simplificator.m_fixSelfTangency = fixSelfTangency;
        simplificator.m_progressTracker = progressTracker;
        return simplificator._simplify();
    }

    int _compareVerticesSimple(int v1, int v2) {
        Point2D pt1 = new Point2D();
        this.m_shape.getXY(v1, pt1);
        Point2D pt2 = new Point2D();
        this.m_shape.getXY(v2, pt2);
        int res = pt1.compare(pt2);
        if (res == 0) {
            int i2;
            int i1 = this.m_shape.getPathFromVertex(v1);
            res = i1 < (i2 = this.m_shape.getPathFromVertex(v2)) ? -1 : (i1 == i2 ? 0 : 1);
        }
        return res;
    }

    int _compareAngles(int index1, int index2) {
        int vert1 = this.m_bunchEdgeEndPoints.get(index1);
        Point2D pt1 = new Point2D();
        this.m_shape.getXY(vert1, pt1);
        Point2D pt2 = new Point2D();
        int vert2 = this.m_bunchEdgeEndPoints.get(index2);
        this.m_shape.getXY(vert2, pt2);
        if (pt1.isEqual(pt2)) {
            return 0;
        }
        int vert10 = this.m_bunchEdgeCenterPoints.get(index1);
        Point2D pt10 = new Point2D();
        this.m_shape.getXY(vert10, pt10);
        int vert20 = this.m_bunchEdgeCenterPoints.get(index2);
        Point2D pt20 = new Point2D();
        this.m_shape.getXY(vert20, pt20);
        Point2D v1 = new Point2D();
        v1.sub(pt1, pt10);
        Point2D v2 = new Point2D();
        v2.sub(pt2, pt20);
        int result = Point2D._compareVectors(v1, v2);
        return result;
    }

    static class SimplificatorVertexComparer
    extends AttributeStreamOfInt32.IntComparator {
        Simplificator m_parent;

        SimplificatorVertexComparer(Simplificator parent) {
            this.m_parent = parent;
        }

        @Override
        public int compare(int v1, int v2) {
            return this.m_parent._compareVerticesSimple(v1, v2);
        }
    }

    static class SimplificatorAngleComparer
    extends AttributeStreamOfInt32.IntComparator {
        Simplificator m_parent;

        public SimplificatorAngleComparer(Simplificator parent) {
            this.m_parent = parent;
        }

        @Override
        public int compare(int v1, int v2) {
            return this.m_parent._compareAngles(v1, v2);
        }
    }
}

