/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.project.email;

import com.epam.ta.reportportal.ws.annotations.In;
import com.epam.ta.reportportal.ws.annotations.NotBlankStringCollection;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SenderCaseDTO
implements Serializable {
    private static final long serialVersionUID = -3546546654348861010L;
    @NotEmpty
    @NotBlankStringCollection
    @JsonProperty(value="recipients")
    private List<String> recipients;
    @NotBlank
    @JsonProperty(value="sendCase")
    @In(allowedValues={"always", "failed", "toInvestigate", "more10", "more20", "more50"})
    @ApiModelProperty(allowableValues="ALWAYS, FAILED, MORE_10, MORE_20, MORE_50")
    private String sendCase;
    @NotBlankStringCollection
    @JsonProperty(value="launchNames")
    private List<String> launchNames;
    @Valid
    @JsonProperty(value="attributes")
    private Set<ItemAttributeResource> attributes;

    public SenderCaseDTO() {
    }

    public SenderCaseDTO(List<String> recs, String sendMode, List<String> laNames, Set<ItemAttributeResource> attributes) {
        this.recipients = recs;
        this.sendCase = sendMode;
        this.launchNames = laNames;
        this.attributes = attributes;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setSendCase(String value) {
        this.sendCase = value;
    }

    public String getSendCase() {
        return this.sendCase;
    }

    public void setLaunchNames(List<String> value) {
        this.launchNames = value;
    }

    public List<String> getLaunchNames() {
        return this.launchNames;
    }

    public Set<ItemAttributeResource> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<ItemAttributeResource> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "SenderCaseDTO [recipients=" + this.recipients + ", sendCase=" + this.sendCase + ", launchNames=" + this.launchNames + ", attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.launchNames == null ? 0 : this.launchNames.hashCode());
        result = 31 * result + (this.recipients == null ? 0 : this.recipients.hashCode());
        result = 31 * result + (this.sendCase == null ? 0 : this.sendCase.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SenderCaseDTO other = (SenderCaseDTO)obj;
        if (this.launchNames == null ? other.launchNames != null : !this.launchNames.equals(other.launchNames)) {
            return false;
        }
        if (this.recipients == null ? other.recipients != null : !this.recipients.equals(other.recipients)) {
            return false;
        }
        if (this.sendCase == null ? other.sendCase != null : !this.sendCase.equals(other.sendCase)) {
            return false;
        }
        if (this.attributes == null) {
            return other.attributes == null;
        }
        return this.attributes.equals(other.attributes);
    }
}

