/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.issue;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Issue {
    @NotBlank
    @JsonProperty(value="issueType", required=true)
    @JsonAlias(value={"issueType", "issue_type"})
    private String issueType;
    @JsonProperty(value="comment")
    @Size(max=65536)
    private @Size(max=65536) String comment;
    @JsonProperty(value="autoAnalyzed")
    private boolean autoAnalyzed;
    @JsonProperty(value="ignoreAnalyzer")
    private boolean ignoreAnalyzer;
    @JsonProperty(value="externalSystemIssues")
    private Set<ExternalSystemIssue> externalSystemIssues;

    public void setExternalSystemIssues(Set<ExternalSystemIssue> externalSystemIssues) {
        this.externalSystemIssues = externalSystemIssues;
    }

    public Set<ExternalSystemIssue> getExternalSystemIssues() {
        return this.externalSystemIssues;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean getAutoAnalyzed() {
        return this.autoAnalyzed;
    }

    public void setAutoAnalyzed(boolean autoAnalyzed) {
        this.autoAnalyzed = autoAnalyzed;
    }

    public boolean getIgnoreAnalyzer() {
        return this.ignoreAnalyzer;
    }

    public void setIgnoreAnalyzer(boolean ignoreAnalyzer) {
        this.ignoreAnalyzer = ignoreAnalyzer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Issue{");
        sb.append("issueType='").append(this.issueType).append('\'');
        sb.append(", comment='").append(this.comment).append('\'');
        sb.append(", autoAnalyzed='").append(this.autoAnalyzed).append("'");
        sb.append(", externalSystemIssues=").append(this.externalSystemIssues);
        sb.append('}');
        return sb.toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ExternalSystemIssue {
        @NotNull
        @JsonProperty(value="ticketId")
        private String ticketId;
        @JsonProperty(value="submitDate")
        private Long submitDate;
        @NotNull
        @JsonProperty(value="btsUrl")
        private String btsUrl;
        @NotNull
        @JsonProperty(value="btsProject")
        private String btsProject;
        @NotNull
        @JsonProperty(value="url")
        private String url;

        public void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public Long getSubmitDate() {
            return this.submitDate;
        }

        public void setSubmitDate(Long submitDate) {
            this.submitDate = submitDate;
        }

        public String getBtsUrl() {
            return this.btsUrl;
        }

        public void setBtsUrl(String btsUrl) {
            this.btsUrl = btsUrl;
        }

        public String getBtsProject() {
            return this.btsProject;
        }

        public void setBtsProject(String btsProject) {
            this.btsProject = btsProject;
        }

        public void setUrl(String value) {
            this.url = value;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalSystemIssue that = (ExternalSystemIssue)o;
            if (this.ticketId != null ? !this.ticketId.equals(that.ticketId) : that.ticketId != null) {
                return false;
            }
            if (this.btsUrl != null ? !this.btsUrl.equals(that.btsUrl) : that.btsUrl != null) {
                return false;
            }
            if (this.btsProject != null ? !this.btsProject.equals(that.btsProject) : that.btsProject != null) {
                return false;
            }
            return this.url != null ? this.url.equals(that.url) : that.url == null;
        }

        public int hashCode() {
            int result = this.ticketId != null ? this.ticketId.hashCode() : 0;
            result = 31 * result + (this.btsUrl != null ? this.btsUrl.hashCode() : 0);
            result = 31 * result + (this.btsProject != null ? this.btsProject.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ExternalSystemIssue{ticketId='" + this.ticketId + '\'' + ", btsUrl='" + this.btsUrl + '\'' + ", btsProject='" + this.btsProject + '\'' + ", url='" + this.url + '\'' + '}';
        }
    }
}

