/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.reflect;

import com.epam.reportportal.utils.reflect.AccessibleField;
import com.epam.reportportal.utils.reflect.AccessibleMethod;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Accessible {
    private final Object object;

    public Accessible(@Nonnull Object object) {
        this.object = object;
    }

    @Nonnull
    public AccessibleMethod method(@Nonnull Method m) {
        return new AccessibleMethod(this.object, m);
    }

    @Nonnull
    public AccessibleMethod method(@Nonnull String m, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return new AccessibleMethod(this.object, this.getMethod(m, parameterTypes));
    }

    @Nonnull
    public AccessibleField field(@Nonnull Field f) {
        return new AccessibleField(this.object, f);
    }

    @Nonnull
    public AccessibleField field(@Nonnull String name) throws NoSuchFieldException {
        return new AccessibleField(this.object, this.getField(name));
    }

    @Nonnull
    public static Accessible on(@Nonnull Object object) {
        return new Accessible(object);
    }

    @Nonnull
    private Field getField(@Nonnull String fieldName) throws NoSuchFieldException {
        Class<?> clazz = this.object.getClass();
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            while (true) {
                try {
                    return clazz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw e;
                }
                break;
            }
        }
    }

    @Nonnull
    private Method getMethod(@Nonnull String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?> clazz = this.object.getClass();
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            while (true) {
                try {
                    return clazz.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw e;
                }
                break;
            }
        }
    }
}

