/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.formatting;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class MarkdownUtils {
    public static final String MARKDOWN_MODE = "!!!MARKDOWN_MODE!!!";
    private static final String NEW_LINE = "\n";
    public static final String ONE_SPACE = "\u00a0";
    public static final String TABLE_INDENT = "\u00a0\u00a0\u00a0\u00a0";
    public static final String TABLE_COLUMN_SEPARATOR = "|";
    public static final String TABLE_ROW_SEPARATOR = "-";
    public static final String TRUNCATION_REPLACEMENT = "...";
    public static final int PADDING_SPACES_NUM = 2;
    public static final int MAX_TABLE_SIZE = 83;
    public static final int MIN_COL_SIZE = 3;
    public static final String LOGICAL_SEPARATOR = "\n\n---\n\n";

    private MarkdownUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String asMarkdown(@Nonnull String message) {
        return MARKDOWN_MODE.concat(message);
    }

    @Nonnull
    public static String asCode(@Nullable String language, @Nullable String script) {
        return MarkdownUtils.asMarkdown("```" + Optional.ofNullable(language).orElse("") + NEW_LINE + script + "\n```");
    }

    private static List<Integer> calculateColSizes(@Nonnull List<List<String>> table) {
        int tableColNum = table.stream().mapToInt(List::size).max().orElse(-1);
        List iterList = table.stream().map(List::iterator).collect(Collectors.toList());
        return IntStream.range(0, tableColNum).mapToObj(n -> iterList.stream().filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList())).map(col -> col.stream().mapToInt(String::length).max().orElse(0)).collect(Collectors.toList());
    }

    private static int calculateTableSize(@Nonnull List<Integer> colSizes) {
        int colTableSize = colSizes.stream().reduce(Integer::sum).orElse(-1);
        colTableSize += (2 + TABLE_COLUMN_SEPARATOR.length()) * colSizes.size() - 1;
        return colTableSize += 2;
    }

    private static <T> List<List<T>> transposeTable(@Nonnull List<List<T>> table) {
        int tableColNum = table.stream().mapToInt(List::size).max().orElse(-1);
        List iterList = table.stream().map(List::iterator).collect(Collectors.toList());
        return IntStream.range(0, tableColNum).mapToObj(n -> iterList.stream().filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Nonnull
    private static List<Integer> adjustColSizes(@Nonnull List<Integer> colSizes, int maxTableSize) {
        int colTableSize = MarkdownUtils.calculateTableSize(colSizes);
        if (maxTableSize >= colTableSize) {
            return colSizes;
        }
        List colsBySize = IntStream.range(0, colSizes.size()).mapToObj(i -> Pair.of((Object)((Integer)colSizes.get(i)), (Object)i)).sorted().collect(Collectors.toList());
        Collections.reverse(colsBySize);
        int sizeToShrink = colTableSize - maxTableSize;
        block0: for (int i2 = 0; i2 < sizeToShrink; ++i2) {
            for (int j = 0; j < colsBySize.size(); ++j) {
                Pair nextCol;
                Pair currentCol = (Pair)colsBySize.get(j);
                if ((Integer)currentCol.getKey() <= 3) continue;
                Pair pair = nextCol = colsBySize.size() > j + 1 ? (Pair)colsBySize.get(j + 1) : Pair.of((Object)0, (Object)0);
                if ((Integer)currentCol.getKey() < (Integer)nextCol.getKey()) continue;
                colsBySize.set(j, Pair.of((Object)((Integer)currentCol.getKey() - 1), (Object)((Integer)currentCol.getValue())));
                continue block0;
            }
        }
        return colsBySize.stream().sorted(Map.Entry.comparingByValue()).map(Pair::getKey).collect(Collectors.toList());
    }

    @Nonnull
    public static String formatDataTable(@Nonnull List<List<String>> table, int maxTableSize) {
        int tableSize;
        List<List<String>> printTable;
        List<Integer> colSizes = MarkdownUtils.calculateColSizes(table);
        boolean transpose = colSizes.size() > table.size() && MarkdownUtils.calculateTableSize(colSizes) > maxTableSize;
        List<List<String>> list = printTable = transpose ? MarkdownUtils.transposeTable(table) : table;
        if (transpose) {
            colSizes = MarkdownUtils.calculateColSizes(printTable);
        }
        boolean addPadding = (tableSize = MarkdownUtils.calculateTableSize(colSizes = MarkdownUtils.adjustColSizes(colSizes, maxTableSize))) <= maxTableSize;
        boolean header = !transpose;
        StringBuilder result = new StringBuilder();
        for (List<String> row : printTable) {
            int i;
            result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
            for (i = 0; i < row.size(); ++i) {
                Object cell = row.get(i);
                int colSize = colSizes.get(i);
                if (colSize < ((String)cell).length()) {
                    cell = TRUNCATION_REPLACEMENT.length() < colSize ? ((String)cell).substring(0, colSize - TRUNCATION_REPLACEMENT.length()) + TRUNCATION_REPLACEMENT : ((String)cell).substring(0, colSize);
                }
                int padSize = colSize - ((String)cell).length() + (addPadding ? 2 : 0);
                int lSpace = padSize / 2;
                int rSpace = padSize - lSpace;
                IntStream.range(0, lSpace).forEach(j -> result.append(ONE_SPACE));
                result.append((String)cell);
                IntStream.range(0, rSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(TABLE_COLUMN_SEPARATOR);
            }
            if (header) {
                header = false;
                result.append(NEW_LINE);
                result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
                for (i = 0; i < row.size(); ++i) {
                    int maxSize = colSizes.get(i) + (addPadding ? 2 : 0);
                    IntStream.range(0, maxSize).forEach(j -> result.append(TABLE_ROW_SEPARATOR));
                    result.append(TABLE_COLUMN_SEPARATOR);
                }
            }
            result.append(NEW_LINE);
        }
        return result.toString().trim();
    }

    @Nonnull
    public static String formatDataTable(@Nonnull List<List<String>> table) {
        return MarkdownUtils.formatDataTable(table, 83);
    }

    @Nonnull
    public static String formatDataTable(@Nonnull Map<String, String> table) {
        ArrayList<List<String>> toFormat = new ArrayList<List<String>>();
        ArrayList<String> keys = new ArrayList<String>(table.keySet());
        toFormat.add(keys);
        toFormat.add(keys.stream().map(table::get).collect(Collectors.toList()));
        return MarkdownUtils.formatDataTable(toFormat);
    }

    @Nonnull
    public static String asTwoParts(@Nonnull String firstPart, @Nonnull String secondPart) {
        return firstPart + LOGICAL_SEPARATOR + secondPart;
    }
}

