/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.formatting;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class ExceptionUtils {
    public static final String SKIP_TRACE_MARKER = "...";
    public static final String LINE_DELIMITER = "\n";

    private ExceptionUtils() {
        throw new IllegalStateException("Static only class");
    }

    public static String getStackTrace(Throwable throwable, Throwable baseThrowable, boolean preserveCause) {
        String[] mainFrames = org.apache.commons.lang3.exception.ExceptionUtils.getStackFrames((Throwable)throwable);
        Set baseFrames = Arrays.stream(org.apache.commons.lang3.exception.ExceptionUtils.getStackFrames((Throwable)baseThrowable)).collect(Collectors.toSet());
        StringBuilder sb = new StringBuilder();
        if (mainFrames.length > 0) {
            sb.append(mainFrames[0]).append(LINE_DELIMITER);
            boolean skipping = false;
            for (int i = 1; i < mainFrames.length; ++i) {
                String frame = mainFrames[i];
                if (!(!baseFrames.contains(frame) || frame.startsWith("Caused by:") && preserveCause)) {
                    if (skipping) continue;
                    sb.append(SKIP_TRACE_MARKER);
                    skipping = true;
                    continue;
                }
                skipping = false;
                sb.append(frame).append(LINE_DELIMITER);
            }
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable, Throwable baseThrowable) {
        return ExceptionUtils.getStackTrace(throwable, baseThrowable, false);
    }
}

