/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.files;

import com.epam.reportportal.utils.files.Utils;
import jakarta.annotation.Nonnull;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;

public class ByteSource {
    private volatile byte[] bytes;
    private final URL url;

    public ByteSource(@Nonnull ByteSource source) {
        this.url = source.url;
        byte[] myBytes = source.bytes;
        this.bytes = myBytes == null ? null : Arrays.copyOf(myBytes, myBytes.length);
    }

    private ByteSource(@Nonnull byte[] source) {
        this.url = null;
        this.bytes = Arrays.copyOf(source, source.length);
    }

    public ByteSource(@Nonnull URL sourceUrl) {
        this.url = sourceUrl;
        this.bytes = null;
    }

    @Nonnull
    public static ByteSource wrap(@Nonnull byte[] source) {
        return new ByteSource(source);
    }

    @Nonnull
    public InputStream openStream() throws IOException {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.url != null) {
            return this.url.openStream();
        }
        throw new IOException("Unable to open a stream for null sources.");
    }

    @Nonnull
    public InputStream openBufferedStream() throws IOException {
        return new BufferedInputStream(this.openStream());
    }

    @Nonnull
    public byte[] read() throws IOException {
        if (this.bytes != null) {
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }
        if (this.url != null) {
            try (InputStream is = this.url.openStream();){
                this.bytes = Utils.readInputStreamToBytes(is);
            }
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }
        throw new IOException("Unable to read null sources.");
    }
}

