/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.files.Utils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    @Nonnull
    public static KeyStore loadKeyStore(@Nonnull String keyStore, @Nullable String password, @Nonnull String type) {
        KeyStore keyStore2;
        block8: {
            InputStream is = Utils.getFile(new File(keyStore)).openStream();
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                trustStore.load(is, Optional.ofNullable(password).map(String::toCharArray).orElse(null));
                keyStore2 = trustStore;
                if (is == null) break block8;
            }
            catch (Throwable trustStore) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            trustStore.addSuppressed(throwable);
                        }
                    }
                    throw trustStore;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    String error = "Unable to load key store";
                    LOGGER.error(error, (Throwable)e);
                    throw new InternalReportPortalClientException(error, e);
                }
            }
            is.close();
        }
        return keyStore2;
    }
}

