/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.ParameterKey;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class ParameterUtils {
    public static final String NULL_VALUE = "NULL";

    private ParameterUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static <T> List<ParameterResource> getParameters(@Nonnull Executable method, @Nullable List<T> parameterValues) {
        List values = Optional.ofNullable(parameterValues).orElse(Collections.emptyList());
        Parameter[] params = method.getParameters();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        return IntStream.range(0, params.length).boxed().map(i -> {
            ParameterResource res = new ParameterResource();
            String parameterName = Arrays.stream(parameterAnnotations[i]).filter(a -> ParameterKey.class.equals(a.annotationType())).map(a -> ((ParameterKey)a).value()).findFirst().orElseGet(() -> params[i].getType().getName());
            res.setKey(parameterName);
            res.setValue(Optional.ofNullable(i < values.size() ? (Object)values.get((int)i) : null).map(String::valueOf).orElse(NULL_VALUE));
            return res;
        }).collect(Collectors.toList());
    }

    public static Class<?> toBoxedType(@Nonnull Class<?> primitiveType) {
        if (primitiveType.isPrimitive()) {
            if (primitiveType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (primitiveType == Byte.TYPE) {
                return Byte.class;
            }
            if (primitiveType == Character.TYPE) {
                return Character.class;
            }
            if (primitiveType == Short.TYPE) {
                return Short.class;
            }
            if (primitiveType == Integer.TYPE) {
                return Integer.class;
            }
            if (primitiveType == Long.TYPE) {
                return Long.class;
            }
            if (primitiveType == Float.TYPE) {
                return Float.class;
            }
            if (primitiveType == Double.TYPE) {
                return Double.class;
            }
            if (primitiveType == Void.TYPE) {
                return Void.class;
            }
            return null;
        }
        return primitiveType;
    }

    @Nonnull
    private static <T> List<ParameterResource> getParameters(@Nullable List<Pair<String, T>> arguments) {
        return Optional.ofNullable(arguments).map(args -> args.stream().map(a -> {
            ParameterResource p = new ParameterResource();
            p.setKey((String)a.getKey());
            p.setValue(Optional.ofNullable(a.getValue()).map(String::valueOf).orElse(NULL_VALUE));
            return p;
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Nonnull
    public static <T> List<ParameterResource> getParameters(@Nullable String codeRef, @Nullable List<Pair<String, T>> parameters) {
        Optional<List> paramValues = Optional.ofNullable(parameters).map(args -> args.stream().map(a -> a.getValue()).collect(Collectors.toList()));
        return Optional.ofNullable(codeRef).flatMap(cr -> {
            Optional<Class<Object>> testStepClass;
            int lastDelimiterIndex = cr.lastIndexOf(46);
            String className = cr.substring(0, lastDelimiterIndex);
            String methodName = cr.substring(lastDelimiterIndex + 1);
            try {
                testStepClass = Optional.of(Class.forName(className));
            }
            catch (ClassNotFoundException e1) {
                try {
                    testStepClass = Optional.of(Class.forName(cr));
                }
                catch (ClassNotFoundException e2) {
                    testStepClass = Optional.empty();
                }
            }
            return testStepClass.flatMap(cl -> Stream.concat(Arrays.stream(cl.getDeclaredMethods()), Arrays.stream(cl.getDeclaredConstructors())).filter(m -> methodName.equals(m.getName()) || cr.equals(m.getName())).filter(m -> m.getParameterCount() == paramValues.map(List::size).orElse(0).intValue()).findAny());
        }).map(m -> ParameterUtils.getParameters(m, paramValues.orElse(null))).orElse(ParameterUtils.getParameters(parameters));
    }

    @Nonnull
    public static String formatParametersAsTable(@Nonnull List<ParameterResource> parameters) {
        ArrayList<List<String>> tableList = new ArrayList<List<String>>();
        tableList.add(parameters.stream().map(ParameterResource::getKey).collect(Collectors.toList()));
        tableList.add(parameters.stream().map(ParameterResource::getValue).collect(Collectors.toList()));
        return MarkdownUtils.formatDataTable(tableList);
    }
}

