/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.UUID;

public class ClientIdProvider {
    private static final String CLIENT_ID_PROPERTY = "client.id";
    public static final Path RP_PROPERTIES_FILE_PATH = Paths.get(System.getProperty("user.home"), ".rp", "rp.properties");

    private ClientIdProvider() {
        throw new IllegalStateException("Static only class");
    }

    @Nullable
    private static String readClientId() {
        Properties properties = new Properties();
        if (Files.exists(RP_PROPERTIES_FILE_PATH, new LinkOption[0])) {
            try {
                properties.load(Files.newInputStream(RP_PROPERTIES_FILE_PATH, StandardOpenOption.READ));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return properties.getProperty(CLIENT_ID_PROPERTY);
        }
        return null;
    }

    private static void storeClientId(@Nonnull String clientId) {
        Path folder = RP_PROPERTIES_FILE_PATH.getParent();
        try {
            if (!Files.exists(folder, new LinkOption[0])) {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            Properties properties = new Properties();
            if (Files.exists(RP_PROPERTIES_FILE_PATH, new LinkOption[0])) {
                properties.load(Files.newInputStream(RP_PROPERTIES_FILE_PATH, StandardOpenOption.READ));
            }
            properties.put(CLIENT_ID_PROPERTY, clientId);
            properties.store(Files.newOutputStream(RP_PROPERTIES_FILE_PATH, StandardOpenOption.CREATE), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nonnull
    public static String getClientId() {
        String clientId = ClientIdProvider.readClientId();
        if (clientId == null) {
            clientId = UUID.randomUUID().toString();
            ClientIdProvider.storeClientId(clientId);
        }
        return clientId;
    }
}

