/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.tree;

import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.files.Utils;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTreeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemTreeReporter.class);

    private ItemTreeReporter() {
    }

    public static Maybe<String> startItem(ReportPortalClient reportPortalClient, StartTestItemRQ startTestItemRQ, Maybe<String> launchUuid, TestItemTree.TestItemLeaf testItemLeaf) {
        Maybe<String> parent = testItemLeaf.getParentId();
        if (parent != null && launchUuid != null) {
            return ItemTreeReporter.sendStartItemRequest(reportPortalClient, launchUuid, parent, startTestItemRQ);
        }
        return Maybe.empty();
    }

    public static Maybe<OperationCompletionRS> finishItem(ReportPortalClient reportPortalClient, FinishTestItemRQ finishTestItemRQ, Maybe<String> launchUuid, TestItemTree.TestItemLeaf testItemLeaf) {
        Throwable t;
        Maybe<String> item = testItemLeaf.getItemId();
        Maybe<OperationCompletionRS> finishResponse = testItemLeaf.getFinishResponse();
        if (item == null || launchUuid == null) {
            return Maybe.empty();
        }
        if (finishResponse != null && (t = finishResponse.ignoreElement().blockingGet()) != null) {
            LOGGER.warn("A main item finished with error", t);
        }
        return ItemTreeReporter.sendFinishItemRequest(reportPortalClient, launchUuid, item, finishTestItemRQ);
    }

    public static boolean sendLog(ReportPortalClient reportPortalClient, String level, String message, @Nonnull Comparable<? extends Comparable<?>> logTime, Maybe<String> launchUuid, TestItemTree.TestItemLeaf testItemLeaf) {
        Maybe<String> itemId = testItemLeaf.getItemId();
        if (launchUuid != null && itemId != null) {
            ItemTreeReporter.sendLogRequest(reportPortalClient, launchUuid, itemId, level, message, logTime).subscribe();
            return true;
        }
        return false;
    }

    public static boolean sendLog(ReportPortalClient reportPortalClient, String level, String message, @Nonnull Date logTime, Maybe<String> launchUuid, TestItemTree.TestItemLeaf testItemLeaf) {
        return ItemTreeReporter.sendLog(reportPortalClient, level, message, logTime, launchUuid, testItemLeaf);
    }

    public static boolean sendLog(ReportPortalClient reportPortalClient, String level, String message, @Nonnull Comparable<? extends Comparable<?>> logTime, File file, Maybe<String> launchUuid, TestItemTree.TestItemLeaf testItemLeaf) {
        Maybe<String> itemId = testItemLeaf.getItemId();
        if (launchUuid != null && itemId != null) {
            ItemTreeReporter.sendLogMultiPartRequest(reportPortalClient, launchUuid, itemId, level, message, logTime, file).subscribe();
            return true;
        }
        return false;
    }

    public static boolean sendLog(ReportPortalClient reportPortalClient, String level, String message, @Nonnull Date logTime, File file, Maybe<String> launchUuid, TestItemTree.TestItemLeaf testItemLeaf) {
        return ItemTreeReporter.sendLog(reportPortalClient, level, message, logTime, file, launchUuid, testItemLeaf);
    }

    private static Maybe<String> sendStartItemRequest(ReportPortalClient reportPortalClient, Maybe<String> launchUuid, Maybe<String> parent, StartTestItemRQ startTestItemRQ) {
        startTestItemRQ.setLaunchUuid((String)launchUuid.blockingGet());
        return reportPortalClient.startTestItem((String)parent.blockingGet(), startTestItemRQ).map(EntryCreatedAsyncRS::getId).cache();
    }

    private static Maybe<OperationCompletionRS> sendFinishItemRequest(ReportPortalClient reportPortalClient, Maybe<String> launchUuid, Maybe<String> item, FinishTestItemRQ finishTestItemRQ) {
        finishTestItemRQ.setLaunchUuid((String)launchUuid.blockingGet());
        return reportPortalClient.finishTestItem((String)item.blockingGet(), finishTestItemRQ);
    }

    private static Maybe<EntryCreatedAsyncRS> sendLogRequest(ReportPortalClient reportPortalClient, Maybe<String> launchUuid, Maybe<String> itemUuid, String level, String message, @Nonnull Comparable<? extends Comparable<?>> logTime) {
        SaveLogRQ saveLogRequest = ItemTreeReporter.createSaveLogRequest((String)launchUuid.blockingGet(), (String)itemUuid.blockingGet(), level, message, logTime);
        return reportPortalClient.log(saveLogRequest);
    }

    private static Maybe<BatchSaveOperatingRS> sendLogMultiPartRequest(ReportPortalClient reportPortalClient, Maybe<String> launchUuid, Maybe<String> itemId, String level, String message, @Nonnull Comparable<? extends Comparable<?>> logTime, File file) {
        SaveLogRQ saveLogRequest = ItemTreeReporter.createSaveLogRequest((String)launchUuid.blockingGet(), (String)itemId.blockingGet(), level, message, logTime);
        try {
            saveLogRequest.setFile(ItemTreeReporter.createFileModel(file));
        }
        catch (IOException e) {
            return Maybe.error((Throwable)e);
        }
        return reportPortalClient.log(HttpRequestUtils.buildLogMultiPartRequest(Collections.singletonList(saveLogRequest)));
    }

    private static Maybe<BatchSaveOperatingRS> sendLogMultiPartRequest(ReportPortalClient reportPortalClient, Maybe<String> launchUuid, Maybe<String> itemId, String level, String message, @Nonnull Date logTime, File file) {
        return ItemTreeReporter.sendLogMultiPartRequest(reportPortalClient, launchUuid, itemId, level, message, logTime, file);
    }

    private static SaveLogRQ createSaveLogRequest(String launchUuid, String itemId, String level, String message, @Nonnull Comparable<? extends Comparable<?>> logTime) {
        SaveLogRQ saveLogRQ = new SaveLogRQ();
        saveLogRQ.setLaunchUuid(launchUuid);
        saveLogRQ.setItemUuid(itemId);
        saveLogRQ.setLevel(level);
        saveLogRQ.setLogTime(logTime);
        saveLogRQ.setMessage(message);
        return saveLogRQ;
    }

    private static SaveLogRQ createSaveLogRequest(String launchUuid, String itemId, String level, String message, @Nonnull Date logTime) {
        return ItemTreeReporter.createSaveLogRequest(launchUuid, itemId, level, message, logTime);
    }

    private static SaveLogRQ.File createFileModel(File file) throws IOException {
        TypeAwareByteSource data = Utils.getFile(file);
        SaveLogRQ.File fileModel = new SaveLogRQ.File();
        fileModel.setContent(data.read());
        fileModel.setContentType(data.getMediaType());
        fileModel.setName(file.getName());
        return fileModel;
    }
}

