/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.BearerAuthInterceptor;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.LaunchImpl;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.PathParamInterceptor;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.ReportPortalClientV2;
import com.epam.reportportal.service.launch.PrimaryLaunch;
import com.epam.reportportal.service.launch.SecondaryLaunch;
import com.epam.reportportal.utils.MultithreadingUtils;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.SslUtils;
import com.epam.reportportal.utils.files.Utils;
import com.epam.reportportal.utils.http.ClientUtils;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ReportPortal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortal.class);
    private static final CookieJar COOKIE_JAR = new CookieJar(){
        private final Map<String, Map<String, Cookie>> HOST_STORAGE = new ConcurrentHashMap<String, Map<String, Cookie>>();

        public void saveFromResponse(@Nonnull HttpUrl url, @Nonnull List<Cookie> cookies) {
            Map storage = this.HOST_STORAGE.computeIfAbsent(url.url().getHost(), u -> new ConcurrentHashMap());
            cookies.forEach(cookie -> storage.put(cookie.name(), cookie));
        }

        @Nonnull
        public List<Cookie> loadForRequest(@Nonnull HttpUrl url) {
            return new ArrayList<Cookie>(this.HOST_STORAGE.computeIfAbsent(url.url().getHost(), u -> new ConcurrentHashMap()).values());
        }
    };
    private final ListenerParameters parameters;
    private final LaunchIdLock launchIdLock;
    private final ReportPortalClient rpClient;
    private final ExecutorService executor;

    ReportPortal(@Nullable ReportPortalClient rpClient, @Nonnull ExecutorService executor, @Nonnull ListenerParameters parameters, @Nullable LaunchIdLock launchIdLock) {
        this.rpClient = rpClient;
        this.executor = executor;
        this.parameters = Objects.requireNonNull(parameters);
        this.launchIdLock = launchIdLock;
    }

    @Nonnull
    public Launch newLaunch(@Nonnull StartLaunchRQ rq) {
        if (BooleanUtils.isNotTrue((Boolean)this.parameters.getEnable()) || this.rpClient == null) {
            return Launch.NOOP_LAUNCH;
        }
        StartLaunchRQ rqCopy = ObjectUtils.clonePojo(rq, StartLaunchRQ.class);
        String launchUuid = this.parameters.getLaunchUuid();
        boolean launchUuidSet = StringUtils.isNotBlank((CharSequence)launchUuid);
        if (launchUuidSet) {
            if (this.parameters.isLaunchUuidCreationSkip()) {
                return new LaunchImpl(this.rpClient, this.parameters, (Maybe<String>)Maybe.just((Object)launchUuid), this.executor);
            }
            rqCopy.setUuid(launchUuid);
        }
        if (this.launchIdLock == null) {
            return new LaunchImpl(this.rpClient, this.parameters, rqCopy, this.executor);
        }
        String instanceUuid = UUID.randomUUID().toString();
        String uuid = this.launchIdLock.obtainLaunchUuid(instanceUuid);
        if (uuid == null) {
            return new LaunchImpl(this.rpClient, this.parameters, rqCopy, this.executor);
        }
        if (instanceUuid.equals(uuid)) {
            if (!launchUuidSet) {
                rqCopy.setUuid(instanceUuid);
            }
            return new PrimaryLaunch(this.rpClient, this.parameters, rqCopy, this.executor, this.launchIdLock, instanceUuid);
        }
        Maybe launch = launchUuidSet ? Maybe.just((Object)launchUuid) : Maybe.just((Object)uuid);
        return new SecondaryLaunch(this.rpClient, this.parameters, (Maybe<String>)launch, this.executor, this.launchIdLock, instanceUuid);
    }

    @Nonnull
    public Launch withLaunch(@Nonnull Maybe<String> launchUuid) {
        return Optional.ofNullable(this.rpClient).map(c -> new LaunchImpl((ReportPortalClient)c, this.parameters, launchUuid, this.executor)).orElse(Launch.NOOP_LAUNCH);
    }

    @Nonnull
    public ListenerParameters getParameters() {
        return this.parameters;
    }

    @Nullable
    public ReportPortalClient getClient() {
        return this.rpClient;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static LaunchIdLock getLaunchLock(ListenerParameters parameters) {
        return parameters.getClientJoin() ? parameters.getClientJoinMode().getInstance(parameters) : null;
    }

    @Nonnull
    public static ReportPortal create(ReportPortalClient client, ListenerParameters params) {
        return ReportPortal.create(client, params, MultithreadingUtils.buildExecutorService("rp-io-", params));
    }

    @Nonnull
    public static ReportPortal create(@Nonnull ReportPortalClient client, @Nonnull ListenerParameters params, @Nonnull ExecutorService executor) {
        return new ReportPortal(client, executor, params, ReportPortal.getLaunchLock(params));
    }

    public static boolean emitLog(Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.context();
        if (null != loggingContext) {
            loggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLaunchLog(Function<String, SaveLogRQ> logSupplier) {
        Launch launch = Launch.currentLaunch();
        if (launch != null && launch != Launch.NOOP_LAUNCH) {
            launch.log(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(Maybe<String> itemUuid, Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.context();
        if (null != loggingContext) {
            loggingContext.emit(itemUuid, logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(@Nullable String message, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLevel(level);
            rq.setLogTime(time);
            rq.setItemUuid((String)itemUuid);
            rq.setMessage(message);
            return rq;
        });
    }

    public static boolean emitLog(@Nullable String message, @Nullable String level, @Nonnull Date time) {
        return ReportPortal.emitLog(message, level, time);
    }

    public static boolean emitLaunchLog(@Nullable String message, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLevel(level);
            rq.setLogTime(time);
            rq.setLaunchUuid((String)launchUuid);
            rq.setMessage(message);
            return rq;
        });
    }

    public static boolean emitLaunchLog(@Nullable String message, @Nullable String level, @Nonnull Date time) {
        return ReportPortal.emitLaunchLog(message, level, time);
    }

    @Nonnull
    public static SaveLogRQ toSaveLogRQ(@Nullable String launchUuid, @Nullable String itemUuid, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time, @Nonnull ReportPortalMessage message) {
        SaveLogRQ rq = new SaveLogRQ();
        rq.setItemUuid(itemUuid);
        rq.setLaunchUuid(launchUuid);
        rq.setLevel(level);
        rq.setLogTime(time);
        rq.setMessage(message.getMessage());
        TypeAwareByteSource data = message.getData();
        if (data != null) {
            try {
                SaveLogRQ.File file = new SaveLogRQ.File();
                file.setContent(data.read());
                file.setContentType(data.getMediaType());
                file.setName(UUID.randomUUID().toString());
                rq.setFile(file);
            }
            catch (IOException e) {
                LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
            }
        }
        return rq;
    }

    public static boolean emitLog(@Nullable String message, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time, File file) {
        return ReportPortal.emitLog(itemUuid -> {
            try {
                TypeAwareByteSource byteSource = Utils.getFile(file);
                return ReportPortal.toSaveLogRQ(null, itemUuid, level, time, new ReportPortalMessage(byteSource, message));
            }
            catch (IOException e) {
                LOGGER.error("Cannot read file", (Throwable)e);
                return ReportPortal.toSaveLogRQ(null, itemUuid, level, time, new ReportPortalMessage(message));
            }
        });
    }

    public static boolean emitLog(@Nullable String message, @Nullable String level, @Nonnull Date time, File file) {
        return ReportPortal.emitLog(message, level, time, file);
    }

    public static boolean emitLaunchLog(@Nullable String message, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time, File file) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            try {
                TypeAwareByteSource byteSource = Utils.getFile(file);
                return ReportPortal.toSaveLogRQ(launchUuid, null, level, time, new ReportPortalMessage(byteSource, message));
            }
            catch (IOException e) {
                LOGGER.error("Cannot read file", (Throwable)e);
                return ReportPortal.toSaveLogRQ(launchUuid, null, level, time, new ReportPortalMessage(message));
            }
        });
    }

    public static boolean emitLaunchLog(@Nullable String message, @Nullable String level, @Nonnull Date time, File file) {
        return ReportPortal.emitLaunchLog(message, level, time, file);
    }

    public static boolean emitLog(ReportPortalMessage message, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time) {
        return ReportPortal.emitLog(itemUuid -> ReportPortal.toSaveLogRQ(null, itemUuid, level, time, message));
    }

    public static boolean emitLog(ReportPortalMessage message, @Nullable String level, @Nonnull Date time) {
        return ReportPortal.emitLog(message, level, time);
    }

    public static boolean emitLaunchLog(ReportPortalMessage message, @Nullable String level, @Nonnull Comparable<? extends Comparable<?>> time) {
        return ReportPortal.emitLaunchLog(launchUuid -> ReportPortal.toSaveLogRQ(launchUuid, null, level, time, message));
    }

    public static boolean emitLaunchLog(ReportPortalMessage message, @Nullable String level, @Nonnull Date time) {
        return ReportPortal.emitLaunchLog(message, level, time);
    }

    public static void sendStackTraceToRP(Throwable cause) {
        Launch launch = Launch.currentLaunch();
        ListenerParameters myParameters = Optional.ofNullable(launch).map(Launch::getParameters).orElseGet(ListenerParameters::new);
        boolean useMicroseconds = Optional.ofNullable(launch).map(Launch::useMicroseconds).orElse(false);
        Throwable base = new Throwable();
        ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid((String)itemUuid);
            rq.setLevel("ERROR");
            rq.setLogTime(useMicroseconds ? Instant.now() : Calendar.getInstance().getTime());
            if (cause != null) {
                if (myParameters.isExceptionTruncate()) {
                    rq.setMessage(com.epam.reportportal.utils.formatting.ExceptionUtils.getStackTrace(cause, base));
                } else {
                    rq.setMessage(ExceptionUtils.getStackTrace((Throwable)cause));
                }
            } else {
                rq.setMessage("Test has failed without exception");
            }
            return rq;
        });
    }

    public static class Builder {
        static final String API_PATH = "api/";
        private static final String HTTPS = "https";
        private OkHttpClient.Builder httpClient;
        private ListenerParameters parameters;
        private ExecutorService executor;

        public Builder withHttpClient(OkHttpClient.Builder client) {
            this.httpClient = client;
            return this;
        }

        public Builder withParameters(ListenerParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withExecutorService(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ReportPortal build() {
            ListenerParameters params = Optional.ofNullable(this.parameters).orElse(new ListenerParameters(this.defaultPropertiesLoader()));
            ExecutorService executorService = this.executor == null ? this.buildExecutorService(params) : this.executor;
            Class clientType = params.isAsyncReporting() ? ReportPortalClientV2.class : ReportPortalClient.class;
            return new ReportPortal(this.buildClient(clientType, params, executorService), executorService, params, this.buildLaunchLock(params));
        }

        public <T extends ReportPortalClient> T buildClient(@Nonnull Class<T> clientType, @Nonnull ListenerParameters params) {
            return this.buildClient(clientType, params, this.buildExecutorService(params));
        }

        public <T extends ReportPortalClient> T buildClient(@Nonnull Class<T> clientType, @Nonnull ListenerParameters params, @Nonnull ExecutorService executor) {
            OkHttpClient client = Optional.ofNullable(this.httpClient).map(c -> c.addInterceptor((Interceptor)new BearerAuthInterceptor(params.getApiKey())).build()).orElseGet(() -> this.defaultClient(params));
            return (T)((ReportPortalClient)Optional.ofNullable(client).map(c -> (ReportPortalClient)this.buildRestEndpoint(params, (OkHttpClient)c, executor).create(clientType)).orElse(null));
        }

        protected Retrofit buildRestEndpoint(@Nonnull ListenerParameters parameters, @Nonnull OkHttpClient client) {
            return this.buildRestEndpoint(parameters, client, this.buildExecutorService(parameters));
        }

        protected Retrofit buildRestEndpoint(@Nonnull ListenerParameters parameters, @Nonnull OkHttpClient client, @Nonnull ExecutorService executor) {
            String baseUrl = (String)(parameters.getBaseUrl().endsWith("/") ? parameters.getBaseUrl() : parameters.getBaseUrl() + "/") + API_PATH;
            Retrofit.Builder builder = new Retrofit.Builder().client(client);
            try {
                builder.baseUrl(baseUrl);
            }
            catch (NoSuchMethodError e) {
                throw new InternalReportPortalClientException("Unable to initialize OkHttp client. ReportPortal client supports OkHttp version 3.11.0 as minimum.\nPlease update OkHttp dependency.\nBesides this usually happens due to old selenium-java version (it overrides our dependency), please use selenium-java 3.141.0 as minimum.", e);
            }
            return builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.from((Executor)executor))).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)HttpRequestUtils.MAPPER)).build();
        }

        @Nullable
        protected OkHttpClient defaultClient(@Nonnull ListenerParameters parameters) {
            URL baseUrl;
            String baseUrlStr = parameters.getBaseUrl();
            if (baseUrlStr == null) {
                LOGGER.warn("Base url for ReportPortal server is not set!");
                return null;
            }
            try {
                baseUrl = new URL(baseUrlStr);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Unable to parse ReportPortal URL", (Throwable)e);
                return null;
            }
            String keyStore = parameters.getKeystore();
            String keyStorePassword = parameters.getKeystorePassword();
            String trustStore = parameters.getTruststore();
            String trustStorePassword = parameters.getTruststorePassword();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (HTTPS.equals(baseUrl.getProtocol()) && (keyStore != null || trustStore != null)) {
                KeyManager[] keyManagers = null;
                if (keyStore != null) {
                    KeyStore ks = SslUtils.loadKeyStore(keyStore, keyStorePassword, parameters.getKeystoreType());
                    try {
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(ks, Optional.ofNullable(keyStorePassword).map(String::toCharArray).orElse(null));
                        keyManagers = kmf.getKeyManagers();
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                        String error = "Unable to load key store";
                        LOGGER.error(error, (Throwable)e);
                        throw new InternalReportPortalClientException(error, e);
                    }
                }
                TrustManager[] trustManagers = null;
                if (trustStore != null) {
                    KeyStore ts = SslUtils.loadKeyStore(trustStore, trustStorePassword, parameters.getTruststoreType());
                    try {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(ts);
                        trustManagers = tmf.getTrustManagers();
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException e) {
                        String trustStoreError = "Unable to load trust store";
                        LOGGER.error(trustStoreError, (Throwable)e);
                        throw new InternalReportPortalClientException(trustStoreError, e);
                    }
                }
                if (trustManagers == null) {
                    try {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init((KeyStore)null);
                        trustManagers = tmf.getTrustManagers();
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException e) {
                        String trustStoreError = "Unable to load default trust store";
                        LOGGER.error(trustStoreError, (Throwable)e);
                        throw new InternalReportPortalClientException(trustStoreError, e);
                    }
                }
                try {
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(keyManagers, trustManagers, new SecureRandom());
                    X509TrustManager trustManager = Arrays.stream(Optional.ofNullable(trustManagers).orElse(new TrustManager[0])).filter(m -> m instanceof X509TrustManager).map(m -> (X509TrustManager)m).findAny().orElseThrow(() -> new InternalReportPortalClientException("Unable to find X509 trust manager"));
                    builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    String error = "Unable to initialize SSL context";
                    LOGGER.error(error, (Throwable)e);
                    throw new InternalReportPortalClientException(error, e);
                }
            }
            ClientUtils.setupProxy(builder, parameters);
            builder.addInterceptor((Interceptor)new BearerAuthInterceptor(parameters.getApiKey()));
            builder.addInterceptor((Interceptor)new PathParamInterceptor("projectName", parameters.getProjectName()));
            if (parameters.isHttpLogging()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                builder.addNetworkInterceptor((Interceptor)logging);
            }
            Optional.ofNullable(parameters.getHttpCallTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).callTimeout(arg_0));
            Optional.ofNullable(parameters.getHttpConnectTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).connectTimeout(arg_0));
            Optional.ofNullable(parameters.getHttpReadTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).readTimeout(arg_0));
            Optional.ofNullable(parameters.getHttpWriteTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).writeTimeout(arg_0));
            builder.retryOnConnectionFailure(true).cookieJar(COOKIE_JAR);
            return builder.build();
        }

        protected LaunchIdLock buildLaunchLock(ListenerParameters parameters) {
            return ReportPortal.getLaunchLock(parameters);
        }

        protected PropertiesLoader defaultPropertiesLoader() {
            return PropertiesLoader.load();
        }

        protected ExecutorService buildExecutorService(ListenerParameters params) {
            return MultithreadingUtils.buildExecutorService("rp-io-", params);
        }
    }
}

