/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.message;

import com.epam.reportportal.message.MessageParser;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.files.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HashMarkSeparatedMessageParser
implements MessageParser {
    private static final int CHUNKS_COUNT = 4;
    private static final Pattern CHUNK_DELIMITER = Pattern.compile("#");

    @Override
    public ReportPortalMessage parse(String message) throws IOException {
        Matcher m = CHUNK_DELIMITER.matcher(Pattern.quote(message));
        int chunkIdx = 0;
        ArrayList<String> split = new ArrayList<String>(4);
        int prevRegion = 0;
        while (m.find()) {
            String chunk = message.substring(prevRegion, m.start() - 2);
            prevRegion = m.start() - 1;
            if (!chunk.isEmpty()) {
                split.add(chunk);
            }
            if (++chunkIdx < 3) continue;
            break;
        }
        split.add(message.substring(prevRegion));
        if (4 != split.size()) {
            throw new RuntimeException("Incorrect message format. Chunks: " + String.join((CharSequence)"\n", split) + "\n count: " + split.size());
        }
        return new ReportPortalMessage(MessageType.fromString((String)split.get(1)).toByteSource((String)split.get(2)), (String)split.get(3));
    }

    @Override
    public boolean supports(String message) {
        return message.startsWith("RP_MESSAGE");
    }

    private static enum MessageType {
        FILE{

            @Override
            public TypeAwareByteSource toByteSource(String data) throws IOException {
                File file = new File(data);
                if (!file.exists()) {
                    return null;
                }
                return Utils.getFile(file);
            }
        }
        ,
        BASE64{

            @Override
            public TypeAwareByteSource toByteSource(String data) throws IOException {
                if (data.contains(":")) {
                    String[] parts = data.split(":");
                    String type = parts[1];
                    return new TypeAwareByteSource(ByteSource.wrap(Base64.getDecoder().decode(parts[0])), type);
                }
                ByteSource source = ByteSource.wrap(Base64.getDecoder().decode(data));
                return new TypeAwareByteSource(source, MimeTypeDetector.detect(source, null));
            }
        }
        ,
        RESOURCE{

            @Override
            public TypeAwareByteSource toByteSource(String resourceName) throws IOException {
                ByteSource source = new ByteSource(Utils.getResource(resourceName));
                return new TypeAwareByteSource(source, MimeTypeDetector.detect(source, resourceName));
            }
        };


        public abstract TypeAwareByteSource toByteSource(String var1) throws IOException;

        public static MessageType fromString(String messageType) {
            return MessageType.valueOf(messageType);
        }
    }
}

