/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.Issues;
import com.epam.reportportal.annotations.TestNameFilter;
import com.epam.reportportal.annotations.TestParamFilter;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class IssueUtils {
    private IssueUtils() {
        throw new IllegalStateException("Static only class");
    }

    private static boolean matchName(@Nonnull String testName, @Nonnull TestNameFilter filter) {
        boolean startsWith = filter.startsWith().isEmpty() || testName.startsWith(filter.startsWith());
        boolean endsWith = filter.endsWith().isEmpty() || testName.endsWith(filter.endsWith());
        boolean contains = filter.contains().isEmpty() || testName.contains(filter.contains());
        return startsWith && endsWith && contains;
    }

    private static boolean matchParameter(@Nonnull ParameterResource param, @Nonnull TestParamFilter filter) {
        boolean nameStartsWith = filter.nameStartsWith().isEmpty() || param.getKey().startsWith(filter.nameStartsWith());
        boolean nameEndsWith = filter.nameEndsWith().isEmpty() || param.getKey().endsWith(filter.nameEndsWith());
        boolean nameContains = filter.nameContains().isEmpty() || param.getKey().contains(filter.nameContains());
        boolean valueStartsWith = filter.valueStartsWith().isEmpty() || param.getValue().startsWith(filter.valueStartsWith());
        boolean valueEndsWith = filter.valueEndsWith().isEmpty() || param.getValue().endsWith(filter.valueEndsWith());
        boolean valueContains = filter.valueContains().isEmpty() || param.getValue().contains(filter.valueContains());
        return nameStartsWith && nameEndsWith && nameContains && valueStartsWith && valueEndsWith && valueContains;
    }

    @Nullable
    public static Issue createIssue(@Nullable com.epam.reportportal.annotations.Issue issue, @Nonnull String testName, @Nonnull List<ParameterResource> parameters) {
        if (issue == null || StringUtils.isBlank((CharSequence)issue.value())) {
            return null;
        }
        boolean matches = Arrays.stream(issue.filter()).allMatch(filter -> {
            boolean nameMatches = Arrays.stream(filter.name()).allMatch(nameFilter -> IssueUtils.matchName(testName, nameFilter));
            boolean paramMatches = Arrays.stream(filter.param()).allMatch(paramFilter -> {
                if (paramFilter.paramIndex() == -1) {
                    return parameters.stream().anyMatch(param -> IssueUtils.matchParameter(param, paramFilter));
                }
                int paramIndex = paramFilter.paramIndex();
                if (paramIndex < 0 || paramIndex >= parameters.size()) {
                    return false;
                }
                ParameterResource param2 = (ParameterResource)parameters.get(paramIndex);
                return IssueUtils.matchParameter(param2, paramFilter);
            });
            return nameMatches && paramMatches;
        });
        if (!matches) {
            return null;
        }
        Issue result = new Issue();
        result.setIssueType(issue.value());
        if (StringUtils.isNotBlank((CharSequence)issue.comment())) {
            result.setComment(issue.comment());
        }
        result.setAutoAnalyzed(false);
        result.setIgnoreAnalyzer(false);
        Set externalIssues = Arrays.stream(issue.external()).filter(ext -> StringUtils.isNotBlank((CharSequence)ext.value())).map(ext -> {
            Issue.ExternalSystemIssue externalIssue = new Issue.ExternalSystemIssue();
            externalIssue.setTicketId(ext.value());
            if (StringUtils.isNotBlank((CharSequence)ext.btsUrl())) {
                externalIssue.setBtsUrl(ext.btsUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)ext.btsProject())) {
                externalIssue.setBtsProject(ext.btsProject());
            }
            if (StringUtils.isNotBlank((CharSequence)ext.urlPattern())) {
                externalIssue.setUrl(ext.urlPattern());
            }
            return externalIssue;
        }).collect(Collectors.toSet());
        if (!externalIssues.isEmpty()) {
            result.setExternalSystemIssues(externalIssues);
        }
        return result;
    }

    @Nullable
    public static Issue createIssue(@Nullable List<com.epam.reportportal.annotations.Issue> issues, @Nonnull String testName, @Nonnull List<ParameterResource> parameters) {
        if (Optional.ofNullable(issues).filter(i -> !i.isEmpty()).isPresent()) {
            return issues.stream().map(i -> IssueUtils.createIssue(i, testName, parameters)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public static Issue createIssue(@Nullable com.epam.reportportal.annotations.Issue[] issues, @Nonnull String testName, @Nonnull List<ParameterResource> parameters) {
        return Optional.ofNullable(issues).map(Arrays::asList).filter(i -> !i.isEmpty()).map(i -> IssueUtils.createIssue(i, testName, parameters)).orElse(null);
    }

    @Nullable
    public static Issue createIssue(@Nullable Issues issues, @Nonnull String testName, @Nonnull List<ParameterResource> parameters) {
        return Optional.ofNullable(issues).map(Issues::value).map(Arrays::asList).filter(i -> !i.isEmpty()).map(i -> IssueUtils.createIssue(i, testName, parameters)).orElse(null);
    }
}

