/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.logs;

import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class BufferSubscriber
implements FlowableSubscriber<SaveLogRQ>,
Subscription {
    private final ReentrantLock lock = new ReentrantLock();
    private final Subscriber<? super List<SaveLogRQ>> downstream;
    private final int maxSize;
    private final long payloadLimit;
    private volatile List<SaveLogRQ> buffer;
    private volatile long payloadSize;
    private volatile Subscription upstream;
    private volatile boolean done;

    public BufferSubscriber(Subscriber<? super List<SaveLogRQ>> actual, int batchMaxSize, long batchPayloadLimit) {
        this.downstream = actual;
        this.maxSize = batchMaxSize;
        this.payloadLimit = batchPayloadLimit;
    }

    public void onSubscribe(@Nonnull Subscription s) {
        if (!SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
            return;
        }
        this.upstream = s;
        this.buffer = new ArrayList<SaveLogRQ>();
        this.payloadSize = HttpRequestUtils.TYPICAL_MULTIPART_FOOTER_LENGTH;
        this.downstream.onSubscribe((Subscription)this);
    }

    private void reset() {
        this.buffer = new ArrayList<SaveLogRQ>();
        this.payloadSize = HttpRequestUtils.TYPICAL_MULTIPART_FOOTER_LENGTH;
    }

    public void onNext(SaveLogRQ t) {
        long newSize;
        if (this.done) {
            return;
        }
        long size = HttpRequestUtils.calculateRequestSize(t);
        ArrayList<List<SaveLogRQ>> toSend = new ArrayList<List<SaveLogRQ>>();
        this.lock.lock();
        if (this.buffer == null) {
            this.lock.unlock();
            return;
        }
        if (this.payloadSize + size > this.payloadLimit && !this.buffer.isEmpty()) {
            toSend.add(this.buffer);
            this.reset();
        }
        this.buffer.add(t);
        this.payloadSize = newSize = this.payloadSize + size;
        if (this.buffer.size() >= this.maxSize) {
            toSend.add(this.buffer);
            this.reset();
        }
        this.lock.unlock();
        toSend.forEach(arg_0 -> this.downstream.onNext(arg_0));
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        this.downstream.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        ArrayList<List<SaveLogRQ>> toSend = new ArrayList<List<SaveLogRQ>>();
        this.lock.lock();
        if (this.buffer != null && !this.buffer.isEmpty()) {
            toSend.add(this.buffer);
            this.reset();
        }
        this.lock.unlock();
        toSend.forEach(arg_0 -> this.downstream.onNext(arg_0));
        this.downstream.onComplete();
    }

    public void request(long n) {
        if (SubscriptionHelper.validate((long)n)) {
            this.upstream.request(BackpressureHelper.multiplyCap((long)n, (long)this.maxSize));
        }
    }

    public void cancel() {
        this.upstream.cancel();
    }
}

