/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch.lock;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.launch.lock.AbstractLaunchIdLock;
import com.epam.reportportal.service.launch.lock.LaunchIdLockFile;
import com.epam.reportportal.service.launch.lock.LaunchIdLockSocket;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;

public enum LaunchIdLockMode {
    FILE(LaunchIdLockFile.class),
    SOCKET(LaunchIdLockSocket.class);

    private final Class<? extends AbstractLaunchIdLock> clazz;

    private LaunchIdLockMode(Class<? extends AbstractLaunchIdLock> launchIdLock) {
        this.clazz = launchIdLock;
    }

    @Nonnull
    public LaunchIdLock getInstance(@Nonnull ListenerParameters parameters) {
        try {
            Constructor<? extends AbstractLaunchIdLock> constructor = this.clazz.getConstructor(ListenerParameters.class);
            try {
                return constructor.newInstance(parameters);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException instantiationException) {
                throw new IllegalStateException("Unable to instantiate class", instantiationException);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to locate suitable constructor", e);
        }
    }
}

