/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.launch.AbstractJoinedLaunch;
import com.epam.reportportal.service.launch.SecondaryLaunchFinishCondition;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.Waiter;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class PrimaryLaunch
extends AbstractJoinedLaunch {
    public PrimaryLaunch(ReportPortalClient rpClient, ListenerParameters parameters, StartLaunchRQ launch, ExecutorService executorService, LaunchIdLock launchIdLock, String instanceUuid) {
        super(rpClient, parameters, launch, executorService, launchIdLock, instanceUuid);
    }

    @Override
    public void finish(FinishExecutionRQ request) {
        this.stopRunning();
        SecondaryLaunchFinishCondition finishCondition = new SecondaryLaunchFinishCondition(this.lock, this.uuid);
        Boolean finished = Boolean.FALSE;
        while (finished != Boolean.TRUE && finished != null) {
            Waiter waiter = new Waiter("Wait for all launches end").duration(this.getParameters().getClientJoinTimeout(), TimeUnit.MILLISECONDS).pollingEvery(1L, TimeUnit.SECONDS);
            finished = waiter.till(finishCondition);
        }
        this.lock.finishInstanceUuid(this.uuid);
        FinishExecutionRQ rq = ObjectUtils.clonePojo(request, FinishExecutionRQ.class);
        rq.setEndTime(Calendar.getInstance().getTime());
        super.finish(rq);
    }
}

