/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.DummyReportPortalClientHandler;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.step.DefaultStepReporter;
import com.epam.reportportal.service.step.StepReporter;
import com.epam.reportportal.utils.StaticStructuresUtils;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launch {
    private static final ThreadLocal<Launch> CURRENT_LAUNCH = new InheritableThreadLocal<Launch>();
    static final Logger LOGGER = LoggerFactory.getLogger(Launch.class);
    private final ListenerParameters parameters;
    private final StepReporter stepReporter;
    protected final ReportPortalClient client;
    public static final Launch NOOP_LAUNCH = new Launch((ReportPortalClient)Proxy.newProxyInstance(Launch.class.getClassLoader(), new Class[]{ReportPortalClient.class}, (InvocationHandler)new DummyReportPortalClientHandler()), new ListenerParameters(), StepReporter.NOOP_STEP_REPORTER){

        @Override
        @Nonnull
        public Maybe<String> start() {
            return Maybe.empty();
        }

        @Override
        public void finish(FinishExecutionRQ rq) {
        }

        @Override
        @NotNull
        public Maybe<String> createVirtualItem() {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public Maybe<String> startTestItem(StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        @NotNull
        public Maybe<String> startVirtualTestItem(Maybe<String> virtualItem, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        @NotNull
        public Maybe<String> startVirtualTestItem(Maybe<String> parentId, Maybe<String> virtualItem, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public void log(@Nonnull SaveLogRQ rq) {
        }

        @Override
        public void log(@Nonnull Function<String, SaveLogRQ> logSupplier) {
        }

        @Override
        @Nonnull
        public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> itemId, FinishTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public Maybe<String> getLaunch() {
            return Maybe.empty();
        }
    };
    public static final Issue NOT_ISSUE = StaticStructuresUtils.NOT_ISSUE;

    Launch(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters listenerParameters, @Nonnull StepReporter reporter) {
        this.parameters = Objects.requireNonNull(listenerParameters, "ListenerParameters shouldn't be NULL");
        this.stepReporter = Objects.requireNonNull(reporter, "StepReporter shouldn't be NULL");
        CURRENT_LAUNCH.set(this);
        this.client = reportPortalClient;
    }

    Launch(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters listenerParameters) {
        this.parameters = Objects.requireNonNull(listenerParameters, "ListenerParameters shouldn't be NULL");
        this.stepReporter = new DefaultStepReporter(this);
        CURRENT_LAUNCH.set(this);
        this.client = Objects.requireNonNull(reportPortalClient, "ReportPortalClient shouldn't be NULL");
    }

    @Nonnull
    public abstract Maybe<String> start();

    public abstract void finish(FinishExecutionRQ var1);

    @Nonnull
    public abstract Maybe<String> createVirtualItem();

    @Nonnull
    public abstract Maybe<String> startTestItem(StartTestItemRQ var1);

    @Nonnull
    public abstract Maybe<String> startTestItem(Maybe<String> var1, StartTestItemRQ var2);

    @Nonnull
    public abstract Maybe<String> startTestItem(Maybe<String> var1, Maybe<String> var2, StartTestItemRQ var3);

    @Nonnull
    public abstract Maybe<String> startVirtualTestItem(Maybe<String> var1, StartTestItemRQ var2);

    @Nonnull
    public abstract Maybe<String> startVirtualTestItem(Maybe<String> var1, Maybe<String> var2, StartTestItemRQ var3);

    public abstract void log(@Nonnull SaveLogRQ var1);

    public abstract void log(@Nonnull Function<String, SaveLogRQ> var1);

    @Nonnull
    public abstract Maybe<OperationCompletionRS> finishTestItem(Maybe<String> var1, FinishTestItemRQ var2);

    @Nonnull
    public ListenerParameters getParameters() {
        CURRENT_LAUNCH.set(this);
        return this.parameters;
    }

    @Nullable
    public static Launch currentLaunch() {
        return CURRENT_LAUNCH.get();
    }

    @Nonnull
    public StepReporter getStepReporter() {
        return this.stepReporter;
    }

    @Nonnull
    public ReportPortalClient getClient() {
        return this.client;
    }

    @Nonnull
    public abstract Maybe<String> getLaunch();
}

