/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.files.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MimeTypeDetector {
    private static final String UNKNOWN_TYPE = "application/octet-stream";
    private static final String EXTENSION_DELIMITER = ".";
    private static final int BYTES_TO_READ_FOR_DETECTION = 20;
    private static final Map<String, String> ADDITIONAL_EXTENSION_MAPPING = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(".properties", "text/plain");
            this.put(".json", "application/json");
        }
    });

    private MimeTypeDetector() {
        throw new IllegalStateException("Static only class. No instances should exist for the class!");
    }

    private static int[] readDetectionBytes(@Nonnull InputStream is) throws IOException {
        int read;
        if (!is.markSupported()) {
            is.reset();
        }
        int[] bytes = new int[20];
        int readNum = 0;
        while ((read = is.read()) != -1 && readNum < 20) {
            bytes[readNum++] = read;
        }
        if (readNum < 19) {
            bytes = Arrays.copyOf(bytes, readNum);
        }
        is.reset();
        return bytes;
    }

    @Nullable
    static String guessContentTypeFromStream(@Nonnull InputStream is) throws IOException {
        int[] bytes = MimeTypeDetector.readDetectionBytes(is);
        if (bytes.length >= 8 && bytes[0] == 137 && bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71 && bytes[4] == 13 && bytes[5] == 10 && bytes[6] == 26 && bytes[7] == 10) {
            return "image/png";
        }
        if (bytes.length >= 4) {
            if (bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4) {
                if (bytes.length >= 7 && bytes[4] == 20 && bytes[5] == 0 && bytes[6] == 8) {
                    return "application/java-archive";
                }
                return "application/zip";
            }
            if (bytes[0] == 37 && bytes[1] == 80 && bytes[2] == 68 && bytes[3] == 70) {
                return "application/pdf";
            }
            if (bytes[0] == 255 && bytes[1] == 216 && bytes[2] == 255 && (bytes[3] == 224 || bytes[3] == 225 || bytes[3] == 232)) {
                return "image/jpeg";
            }
        }
        return null;
    }

    private static String detectByExtensionInternal(String name) {
        int extensionIndex = name.lastIndexOf(EXTENSION_DELIMITER);
        if (extensionIndex >= 0) {
            return ADDITIONAL_EXTENSION_MAPPING.get(name.substring(extensionIndex));
        }
        return null;
    }

    @Nonnull
    public static String detect(@Nonnull File file) throws IOException {
        ByteSource source = Utils.getFileAsByteSource(file);
        String type = URLConnection.guessContentTypeFromStream(source.openStream());
        if (type == null) {
            type = MimeTypeDetector.guessContentTypeFromStream(source.openStream());
        }
        if (type == null) {
            type = Files.probeContentType(file.toPath());
        }
        if (type == null) {
            type = URLConnection.guessContentTypeFromName(file.getName());
        }
        if (type == null) {
            type = MimeTypeDetector.detectByExtensionInternal(file.getName());
        }
        return type == null ? UNKNOWN_TYPE : type;
    }

    @Nonnull
    public static String detect(@Nonnull ByteSource source, @Nullable String resourceName) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(source.openStream());
        if (type == null) {
            type = MimeTypeDetector.guessContentTypeFromStream(source.openStream());
        }
        if (resourceName != null && type == null) {
            type = Files.probeContentType(Paths.get(resourceName, new String[0]));
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(resourceName);
            }
            if (type == null) {
                type = MimeTypeDetector.detectByExtensionInternal(resourceName);
            }
        }
        return type == null ? UNKNOWN_TYPE : type;
    }
}

