/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.templating;

import com.epam.reportportal.annotations.TemplateConfig;
import java.util.Objects;

public class TemplateConfiguration {
    public static final String CLASS_SIMPLE_NAME_TEMPLATE = "class";
    public static final String CLASS_FULL_NAME_TEMPLATE = "classRef";
    public static final String METHOD_NAME_TEMPLATE = "method";
    public static final String SELF_NAME_TEMPLATE = "this";
    public static final String FIELD_REFERENCE_DELIMITER = ".";
    public static final String ITERABLE_START_PATTERN = "[";
    public static final String ITERABLE_END_PATTERN = "]";
    public static final String ITERABLE_ELEMENT_DELIMITER = ", ";
    public static final String ARRAY_START_PATTERN = "{";
    public static final String ARRAY_END_PATTERN = "}";
    public static final String ARRAY_ELEMENT_DELIMITER = ", ";
    private String className;
    private String classRef;
    private String methodName;
    private String selfName;
    private String fieldDelimiter;
    private String iterableStart;
    private String iterableEnd;
    private String iterableDelimiter;
    private String arrayStart;
    private String arrayEnd;
    private String arrayDelimiter;

    public TemplateConfiguration() {
        this.className = CLASS_SIMPLE_NAME_TEMPLATE;
        this.classRef = CLASS_FULL_NAME_TEMPLATE;
        this.methodName = METHOD_NAME_TEMPLATE;
        this.selfName = SELF_NAME_TEMPLATE;
        this.fieldDelimiter = FIELD_REFERENCE_DELIMITER;
        this.iterableStart = ITERABLE_START_PATTERN;
        this.iterableEnd = ITERABLE_END_PATTERN;
        this.iterableDelimiter = ", ";
        this.arrayStart = ARRAY_START_PATTERN;
        this.arrayEnd = ARRAY_END_PATTERN;
        this.arrayDelimiter = ", ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration that = (TemplateConfiguration)o;
        return this.className.equals(that.className) && this.classRef.equals(that.classRef) && this.methodName.equals(that.methodName) && this.selfName.equals(that.selfName) && this.fieldDelimiter.equals(that.fieldDelimiter) && this.iterableStart.equals(that.iterableStart) && this.iterableEnd.equals(that.iterableEnd) && this.iterableDelimiter.equals(that.iterableDelimiter) && this.arrayStart.equals(that.arrayStart) && this.arrayEnd.equals(that.arrayEnd) && this.arrayDelimiter.equals(that.arrayDelimiter);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.classRef, this.methodName, this.selfName, this.fieldDelimiter, this.iterableStart, this.iterableEnd, this.iterableDelimiter, this.arrayStart, this.arrayEnd, this.arrayDelimiter);
    }

    public TemplateConfiguration(TemplateConfig config) {
        this.className = config.classNameTemplate();
        this.classRef = config.classRefTemplate();
        this.methodName = config.methodNameTemplate();
        this.selfName = config.selfNameTemplate();
        this.fieldDelimiter = config.fieldDelimiter();
        this.iterableStart = config.iterableStartSymbol();
        this.iterableEnd = config.iterableEndSymbol();
        this.iterableDelimiter = config.iterableElementDelimiter();
        this.arrayStart = config.arrayStartSymbol();
        this.arrayEnd = config.arrayEndSymbol();
        this.arrayDelimiter = config.arrayElementDelimiter();
    }

    public String getClassName() {
        return this.className;
    }

    public TemplateConfiguration setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getClassRef() {
        return this.classRef;
    }

    public TemplateConfiguration setClassRef(String classRef) {
        this.classRef = classRef;
        return this;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public TemplateConfiguration setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public String getSelfName() {
        return this.selfName;
    }

    public TemplateConfiguration setSelfName(String selfName) {
        this.selfName = selfName;
        return this;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public TemplateConfiguration setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
        return this;
    }

    public String getIterableStart() {
        return this.iterableStart;
    }

    public TemplateConfiguration setIterableStart(String iterableStart) {
        this.iterableStart = iterableStart;
        return this;
    }

    public String getIterableEnd() {
        return this.iterableEnd;
    }

    public TemplateConfiguration setIterableEnd(String iterableEnd) {
        this.iterableEnd = iterableEnd;
        return this;
    }

    public String getIterableDelimiter() {
        return this.iterableDelimiter;
    }

    public TemplateConfiguration setIterableDelimiter(String iterableDelimiter) {
        this.iterableDelimiter = iterableDelimiter;
        return this;
    }

    public String getArrayStart() {
        return this.arrayStart;
    }

    public TemplateConfiguration setArrayStart(String arrayStart) {
        this.arrayStart = arrayStart;
        return this;
    }

    public String getArrayEnd() {
        return this.arrayEnd;
    }

    public TemplateConfiguration setArrayEnd(String arrayEnd) {
        this.arrayEnd = arrayEnd;
        return this;
    }

    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    public TemplateConfiguration setArrayDelimiter(String arrayDelimiter) {
        this.arrayDelimiter = arrayDelimiter;
        return this;
    }
}

